/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils;

import com.notnoop.apns.internal.Utilities;
import junit.framework.Assert;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class StringTruncationTest {
    @DataPoints
    public static Object[][] dataPoints = new Object[][]{{"abcd", 0, 0}, {"abcd", 1, 1}, {"abcd", 2, 2}, {"abcd", 3, 3}, {"abcd", 4, 4}, {"abcd", 5, 4}, {"a\u0080b", 0, 0}, {"a\u0080b", 1, 1}, {"a\u0080b", 2, 1}, {"a\u0080b", 3, 3}, {"a\u0080b", 4, 4}, {"a\u0080b", 5, 4}, {"a\u0800b", 0, 0}, {"a\u0800b", 1, 1}, {"a\u0800b", 2, 1}, {"a\u0800b", 3, 1}, {"a\u0800b", 4, 4}, {"a\u0800b", 5, 5}, {"a\u0800b", 6, 5}};
    @DataPoints
    public static Object[][] surregatePairs = new Object[][]{{"\ud834\udd1e", 0, 0}, {"\ud834\udd1e", 1, 0}, {"\ud834\udd1e", 2, 0}, {"\ud834\udd1e", 3, 0}, {"\ud834\udd1e", 4, 4}, {"\ud834\udd1e", 5, 4}};

    @Theory
    public void truncateUTF8Properly(Object[] p) {
        String str = (String)p[0];
        int maxBytes = (Integer)p[1];
        int expectedBytes = (Integer)p[2];
        String result = Utilities.truncateWhenUTF8((String)str, (int)maxBytes);
        byte[] utf8 = Utilities.toUTF8Bytes((String)result);
        Assert.assertEquals((int)expectedBytes, (int)utf8.length);
    }
}

