/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils;

import com.notnoop.apns.utils.FixedCertificates;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ServerSocketFactory;

public class ApnsServerStub {
    public final ByteArrayOutputStream received;
    public final ByteArrayOutputStream toSend;
    public final Semaphore messages = new Semaphore(0);
    private final Semaphore startUp = new Semaphore(0);
    private final Semaphore gatewayOutLock = new Semaphore(0);
    public final Semaphore waitForError = new Semaphore(1);
    private final ServerSocketFactory sslFactory;
    private final int gatewayPort;
    private final int feedbackPort;
    private OutputStream gatewayOutputStream = null;
    Thread gatewayThread;
    Thread feedbackThread;
    ServerSocket gatewaySocket;
    ServerSocket feedbackSocket;
    AtomicInteger readLen = new AtomicInteger();

    public static ApnsServerStub prepareAndStartServer(int gatePort, int feedPort) {
        ApnsServerStub server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), gatePort, feedPort);
        server.start();
        return server;
    }

    public ApnsServerStub(ServerSocketFactory sslFactory, int gatewayPort, int feedbackPort) {
        this.sslFactory = sslFactory;
        this.gatewayPort = gatewayPort;
        this.feedbackPort = feedbackPort;
        this.received = new ByteArrayOutputStream();
        this.toSend = new ByteArrayOutputStream();
    }

    public void start() {
        this.gatewayThread = new Thread(new GatewayRunner());
        this.feedbackThread = new Thread(new FeedbackRunner());
        this.gatewayThread.start();
        this.feedbackThread.start();
        this.startUp.acquireUninterruptibly(2);
    }

    public void stop() {
        try {
            this.gatewaySocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.feedbackSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.gatewayThread.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.feedbackThread.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendError(int err, int id) {
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.put((byte)8).put((byte)err).putInt(id);
        try {
            this.gatewayOutLock.acquire();
            this.gatewayOutputStream.write(buf.array());
            this.gatewayOutputStream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopAt(int length) {
        this.readLen.set(length);
    }

    public byte[] readFully(InputStream st) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            int read;
            while (this.readLen.getAndDecrement() > 0 && (read = st.read()) != -1) {
                stream.write(read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    private class FeedbackRunner
    implements Runnable {
        private FeedbackRunner() {
        }

        public void run() {
            try {
                ApnsServerStub.this.feedbackSocket = ApnsServerStub.this.sslFactory.createServerSocket(ApnsServerStub.this.feedbackPort);
            }
            catch (IOException e) {
                e.printStackTrace();
                ApnsServerStub.this.messages.release();
                throw new RuntimeException(e);
            }
            try {
                ApnsServerStub.this.startUp.release();
                Socket socket = ApnsServerStub.this.feedbackSocket.accept();
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                ApnsServerStub.this.toSend.writeTo(out);
                in.close();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ApnsServerStub.this.messages.release();
        }
    }

    private class GatewayRunner
    implements Runnable {
        private GatewayRunner() {
        }

        public void run() {
            try {
                ApnsServerStub.this.gatewaySocket = ApnsServerStub.this.sslFactory.createServerSocket(ApnsServerStub.this.gatewayPort);
            }
            catch (IOException e) {
                ApnsServerStub.this.messages.release();
                throw new RuntimeException(e);
            }
            InputStream in = null;
            try {
                ApnsServerStub.this.startUp.release();
                Socket socket = ApnsServerStub.this.gatewaySocket.accept();
                in = socket.getInputStream();
                ApnsServerStub.this.gatewayOutputStream = socket.getOutputStream();
                ApnsServerStub.this.gatewayOutLock.release();
                byte[] read = ApnsServerStub.this.readFully(in);
                ApnsServerStub.this.received.write(read);
                ApnsServerStub.this.messages.release();
                ApnsServerStub.this.waitForError.acquire();
                in.close();
                ApnsServerStub.this.gatewayOutputStream.close();
            }
            catch (Throwable e) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception _) {
                    // empty catch block
                }
                try {
                    if (ApnsServerStub.this.gatewayOutputStream != null) {
                        ApnsServerStub.this.gatewayOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ApnsServerStub.this.messages.release();
            }
        }
    }
}

