/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.PayloadBuilder;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.internal.Utilities;
import org.junit.Assert;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class SimpleApnsNotificationTest {
    @DataPoints
    public static String[] deviceTokens = new String[]{"298893742908AB98C", "98234098203BACCCC93284092"};
    @DataPoints
    public static PayloadBuilder[] payloaders = new PayloadBuilder[]{PayloadBuilder.newPayload().alertBody("test").sound("default"), PayloadBuilder.newPayload().sound("chimes").actionKey("Cancel"), PayloadBuilder.newPayload().customField("notice", (Object)"this")};

    @Theory
    public void lengthConsistency(String deviceToken, PayloadBuilder payload) {
        SimpleApnsNotification msg = new SimpleApnsNotification(deviceToken, payload.build());
        Assert.assertEquals((long)msg.marshall().length, (long)msg.length());
    }

    @Theory
    public void commandIsZero(String deviceToken, PayloadBuilder payload) {
        SimpleApnsNotification msg = new SimpleApnsNotification(deviceToken, payload.build());
        byte[] bytes = msg.marshall();
        Assert.assertEquals((long)0L, (long)bytes[0]);
    }

    @Theory
    public void deviceTokenPart(String deviceToken, PayloadBuilder payload) {
        SimpleApnsNotification msg = new SimpleApnsNotification(deviceToken, payload.build());
        byte[] bytes = msg.marshall();
        byte[] dt = Utilities.decodeHex((String)deviceToken);
        Assert.assertEquals((long)dt.length, (long)((bytes[1] << 8) + bytes[2]));
        Assert.assertArrayEquals((byte[])dt, (byte[])Utilities.copyOfRange((byte[])bytes, (int)3, (int)(3 + dt.length)));
    }

    @Theory
    public void payloadPart(String deviceToken, PayloadBuilder payload) {
        String payloadString = payload.build();
        SimpleApnsNotification msg = new SimpleApnsNotification(deviceToken, payloadString);
        byte[] bytes = msg.marshall();
        byte[] pl = Utilities.toUTF8Bytes((String)payloadString);
        int plBegin = bytes.length - pl.length;
        Assert.assertArrayEquals((byte[])pl, (byte[])Utilities.copyOfRange((byte[])bytes, (int)plBegin, (int)bytes.length));
        Assert.assertEquals((long)pl.length, (long)((bytes[plBegin - 2] << 8) + bytes[plBegin - 1]));
    }

    @Theory
    public void allPartsLength(String deviceToken, PayloadBuilder payload) {
        String payloadString = payload.build();
        SimpleApnsNotification msg = new SimpleApnsNotification(deviceToken, payloadString);
        byte[] bytes = msg.marshall();
        int expectedLength = 3 + Utilities.decodeHex((String)deviceToken).length + 2 + Utilities.toUTF8Bytes((String)payloadString).length;
        Assert.assertEquals((long)expectedLength, (long)bytes.length);
    }
}

