/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.internal.ApnsFeedbackParsingUtils;
import com.notnoop.apns.utils.ApnsServerStub;
import com.notnoop.apns.utils.FixedCertificates;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FeedbackTest {
    ApnsServerStub server;
    SSLContext clientContext = FixedCertificates.clientContext();

    @Before
    public void startup() {
        this.server = ApnsServerStub.prepareAndStartServer(7654, 7843);
    }

    @After
    public void tearDown() {
        this.server.stop();
        this.server = null;
    }

    @Test
    public void simpleFeedback() throws IOException {
        this.server.toSend.write(ApnsFeedbackParsingUtils.simple);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", 7654).withFeedbackDestination("localhost", 7843).build();
        ApnsFeedbackParsingUtils.checkParsedSimple(service.getInactiveDevices());
    }

    @Test
    public void threeFeedback() throws IOException {
        this.server.toSend.write(ApnsFeedbackParsingUtils.three);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", 7654).withFeedbackDestination("localhost", 7843).build();
        ApnsFeedbackParsingUtils.checkParsedThree(service.getInactiveDevices());
    }

    @Test
    public void simpleQueuedFeedback() throws IOException {
        this.server.toSend.write(ApnsFeedbackParsingUtils.simple);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", 7654).withFeedbackDestination("localhost", 7843).asQueued().build();
        ApnsFeedbackParsingUtils.checkParsedSimple(service.getInactiveDevices());
    }

    @Test
    public void threeQueuedFeedback() throws IOException {
        this.server.toSend.write(ApnsFeedbackParsingUtils.three);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", 7654).withFeedbackDestination("localhost", 7843).asQueued().build();
        ApnsFeedbackParsingUtils.checkParsedThree(service.getInactiveDevices());
    }
}

