/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.notnoop.apns.APNS;
import com.notnoop.apns.PayloadBuilder;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.internal.Utilities;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;

public class PayloadBuilderTest {
    @Test
    public void testEmpty() {
        PayloadBuilder builder = new PayloadBuilder();
        String expected = "{\"aps\":{}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{}}", actual);
    }

    @Test
    public void testOneAps() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("test");
        String expected = "{\"aps\":{\"alert\":\"test\"}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":\"test\"}}", actual);
    }

    @Test
    public void testTwoAps() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("test");
        builder.badge(9);
        String expected = "{\"aps\":{\"alert\":\"test\",\"badge\":9}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":\"test\",\"badge\":9}}", actual);
    }

    @Test
    public void testTwoApsMultipleBuilds() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("test");
        builder.badge(9);
        String expected = "{\"aps\":{\"alert\":\"test\",\"badge\":9}}";
        this.assertEqualsJson("{\"aps\":{\"alert\":\"test\",\"badge\":9}}", builder.build());
        this.assertEqualsJson("{\"aps\":{\"alert\":\"test\",\"badge\":9}}", builder.build());
    }

    @Test
    public void testIncludeBadge() {
        String badge0 = APNS.newPayload().badge(0).toString();
        String badgeNo = APNS.newPayload().clearBadge().toString();
        String expected = "{\"aps\":{\"badge\":0}}";
        this.assertEqualsJson("{\"aps\":{\"badge\":0}}", badge0);
        this.assertEqualsJson("{\"aps\":{\"badge\":0}}", badgeNo);
    }

    @Test
    public void localizedOneWithArray() {
        PayloadBuilder builder = new PayloadBuilder().localizedKey("GAME_PLAY_REQUEST_FORMAT").localizedArguments(new String[]{"Jenna", "Frank"});
        builder.sound("chime");
        String expected = "{\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}", actual);
    }

    @Test
    public void localizedOneWithVarargs() {
        PayloadBuilder builder = new PayloadBuilder().localizedKey("GAME_PLAY_REQUEST_FORMAT").localizedArguments(new String[]{"Jenna", "Frank"});
        builder.sound("chime");
        String expected = "{\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}", actual);
    }

    @Test
    public void localizedTwo() {
        PayloadBuilder builder = new PayloadBuilder().sound("chime").localizedKey("GAME_PLAY_REQUEST_FORMAT").localizedArguments(new String[]{"Jenna", "Frank"});
        String expected = "{\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}", actual);
    }

    @Test
    public void customFieldSimple() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("test");
        builder.customField("ache1", (Object)"what");
        builder.customField("ache2", (Object)2);
        String expected = "{\"ache1\":\"what\",\"ache2\":2,\"aps\":{\"alert\":\"test\"}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"ache1\":\"what\",\"ache2\":2,\"aps\":{\"alert\":\"test\"}}", actual);
    }

    @Test
    public void customFieldArray() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("test");
        builder.customField("ache1", Arrays.asList("a1", "a2"));
        builder.customField("ache2", (Object)new int[]{1, 2});
        String expected = "{\"ache1\":[\"a1\",\"a2\"],\"ache2\":[1,2],\"aps\":{\"alert\":\"test\"}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"ache1\":[\"a1\",\"a2\"],\"ache2\":[1,2],\"aps\":{\"alert\":\"test\"}}", actual);
    }

    @Test
    public void customBody() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("what").actionKey("Cancel");
        String expected = "{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}", actual);
    }

    @Test
    public void multipleBuildCallsWithCustomBody() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("what").actionKey("Cancel");
        String expected = "{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}";
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}", builder.build());
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}", builder.build());
    }

    @Test
    public void customBodyReverseOrder() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.actionKey("Cancel").alertBody("what");
        String expected = "{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"action-loc-key\":\"Cancel\",\"body\":\"what\"}}}", actual);
    }

    @Test
    public void alertNoView() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.actionKey(null).alertBody("what");
        String expected = "{\"aps\":{\"alert\":{\"action-loc-key\":null,\"body\":\"what\"}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"action-loc-key\":null,\"body\":\"what\"}}}", actual);
    }

    @Test
    public void alertNoViewSimpler() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.noActionButton().alertBody("what");
        String expected = "{\"aps\":{\"alert\":{\"action-loc-key\":null,\"body\":\"what\"}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"action-loc-key\":null,\"body\":\"what\"}}}", actual);
    }

    @Test
    public void alertWithImageOnly() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.launchImage("/test");
        String expected = "{\"aps\":{\"alert\":{\"launch-image\":\"/test\"}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"launch-image\":\"/test\"}}}", actual);
    }

    @Test
    public void alertWithImageAndText() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.launchImage("/test").alertBody("hello");
        String expected = "{\"aps\":{\"alert\":{\"launch-image\":\"/test\",\"body\":\"hello\"}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"aps\":{\"alert\":{\"launch-image\":\"/test\",\"body\":\"hello\"}}}", actual);
    }

    @Test
    public void emptyApsWithFields() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.customField("achme2", (Object)new int[]{5, 8});
        String expected = "{\"achme2\":[5,8],\"aps\":{}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"achme2\":[5,8],\"aps\":{}}", actual);
    }

    @Test
    public void abitComplicated() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.customField("achme", (Object)"foo");
        builder.sound("chime");
        builder.localizedKey("GAME_PLAY_REQUEST_FORMAT").localizedArguments(new String[]{"Jenna", "Frank"});
        String expected = "{\"achme\":\"foo\",\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}";
        String actual = builder.toString();
        this.assertEqualsJson("{\"achme\":\"foo\",\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}", actual);
    }

    @Test
    public void multipleBuildAbitComplicated() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.customField("achme", (Object)"foo");
        builder.sound("chime");
        builder.localizedKey("GAME_PLAY_REQUEST_FORMAT").localizedArguments(new String[]{"Jenna", "Frank"});
        String expected = "{\"achme\":\"foo\",\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}";
        this.assertEqualsJson("{\"achme\":\"foo\",\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}", builder.build());
        this.assertEqualsJson("{\"achme\":\"foo\",\"aps\":{\"sound\":\"chime\",\"alert\":{\"loc-key\":\"GAME_PLAY_REQUEST_FORMAT\",\"loc-args\":[\"Jenna\",\"Frank\"]}}}", builder.build());
    }

    @Test
    public void copyReturnsNewInstance() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.sound("chime");
        PayloadBuilder copy = builder.copy();
        copy.badge(5);
        Assert.assertNotSame((Object)builder, (Object)copy);
        String expected = "{\"aps\":{\"sound\":\"chime\"}}";
        this.assertEqualsJson("{\"aps\":{\"sound\":\"chime\"}}", builder.build());
        String copyExpected = "{\"aps\":{\"sound\":\"chime\",\"badge\":5}}";
        this.assertEqualsJson("{\"aps\":{\"sound\":\"chime\",\"badge\":5}}", copy.build());
    }

    @Test
    public void simpleEnglishLength() {
        PayloadBuilder builder = new PayloadBuilder().alertBody("test");
        String expected = "{\"aps\":{\"alert\":\"test\"}}";
        this.assertEqualsJson("{\"aps\":{\"alert\":\"test\"}}", builder.build());
        int actualLength = Utilities.toUTF8Bytes((String)"{\"aps\":{\"alert\":\"test\"}}").length;
        Assert.assertEquals((long)actualLength, (long)builder.length());
        Assert.assertFalse((boolean)builder.isTooLong());
    }

    @Test
    public void abitComplicatedEnglishLength() {
        byte[] dtBytes = new byte[32];
        new Random().nextBytes(dtBytes);
        String deviceToken = Utilities.encodeHex((byte[])dtBytes);
        PayloadBuilder builder = new PayloadBuilder().alertBody("test");
        SimpleApnsNotification fromString = new SimpleApnsNotification(deviceToken, builder.build());
        SimpleApnsNotification fromBytes = new SimpleApnsNotification(dtBytes, Utilities.toUTF8Bytes((String)builder.build()));
        String expected = "{\"aps\":{\"alert\":\"test\"}}";
        int actualPacketLength = 3 + dtBytes.length + 2 + Utilities.toUTF8Bytes((String)"{\"aps\":{\"alert\":\"test\"}}").length;
        Assert.assertEquals((long)actualPacketLength, (long)fromString.length());
        Assert.assertEquals((long)actualPacketLength, (long)fromBytes.length());
        Assert.assertEquals((long)"{\"aps\":{\"alert\":\"test\"}}".length(), (long)fromString.getPayload().length);
        Assert.assertArrayEquals((byte[])fromString.marshall(), (byte[])fromBytes.marshall());
        Assert.assertFalse((boolean)builder.isTooLong());
    }

    private String strOfLen(int l) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            sb.append('c');
        }
        String alert = sb.toString();
        return alert;
    }

    private PayloadBuilder payloadOf(int l) {
        return APNS.newPayload().alertBody(this.strOfLen(l));
    }

    @Test
    public void detectingLongMessages() {
        String basic = "{\"aps\":{\"alert\":\"\"}}";
        int wrapperOverhead = "{\"aps\":{\"alert\":\"\"}}".length();
        int cutoffForAlert = 256 - wrapperOverhead;
        PayloadBuilder wayShort = this.payloadOf(1);
        Assert.assertFalse((boolean)wayShort.isTooLong());
        Assert.assertTrue((wayShort.length() == wrapperOverhead + 1 ? 1 : 0) != 0);
        PayloadBuilder bitShort = this.payloadOf(cutoffForAlert - 1);
        Assert.assertFalse((boolean)bitShort.isTooLong());
        Assert.assertTrue((bitShort.length() == wrapperOverhead + cutoffForAlert - 1 ? 1 : 0) != 0);
        PayloadBuilder border = this.payloadOf(cutoffForAlert);
        Assert.assertFalse((boolean)border.isTooLong());
        Assert.assertTrue((border.length() == wrapperOverhead + cutoffForAlert ? 1 : 0) != 0);
        Assert.assertTrue((border.length() == 256 ? 1 : 0) != 0);
        PayloadBuilder abitLong = this.payloadOf(cutoffForAlert + 1);
        Assert.assertTrue((boolean)abitLong.isTooLong());
        Assert.assertTrue((abitLong.length() == wrapperOverhead + cutoffForAlert + 1 ? 1 : 0) != 0);
        PayloadBuilder tooLong = this.payloadOf(cutoffForAlert + 1000);
        Assert.assertTrue((boolean)tooLong.isTooLong());
        Assert.assertTrue((tooLong.length() == wrapperOverhead + cutoffForAlert + 1000 ? 1 : 0) != 0);
    }

    @Test
    public void shrinkLongMessages() {
        String basic = "{\"aps\":{\"alert\":\"\"}}";
        int wrapperOverhead = "{\"aps\":{\"alert\":\"\"}}".length();
        int cutoffForAlert = 256 - wrapperOverhead;
        int max_length = 256;
        PayloadBuilder wayShort = this.payloadOf(1);
        wayShort.shrinkBody();
        Assert.assertFalse((boolean)wayShort.isTooLong());
        Assert.assertTrue((wayShort.length() == wrapperOverhead + 1 ? 1 : 0) != 0);
        PayloadBuilder bitShort = this.payloadOf(cutoffForAlert - 1);
        bitShort.shrinkBody();
        Assert.assertFalse((boolean)bitShort.isTooLong());
        Assert.assertTrue((bitShort.length() == wrapperOverhead + cutoffForAlert - 1 ? 1 : 0) != 0);
        PayloadBuilder border = this.payloadOf(cutoffForAlert);
        Assert.assertFalse((boolean)border.isTooLong());
        Assert.assertTrue((border.length() == 256 ? 1 : 0) != 0);
        PayloadBuilder abitLong = this.payloadOf(cutoffForAlert + 1);
        abitLong.shrinkBody();
        Assert.assertFalse((boolean)abitLong.isTooLong());
        Assert.assertTrue((abitLong.length() == 256 ? 1 : 0) != 0);
        PayloadBuilder tooLong = this.payloadOf(cutoffForAlert + 1000);
        tooLong.shrinkBody();
        Assert.assertFalse((boolean)tooLong.isTooLong());
        Assert.assertTrue((tooLong.length() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void shrinkLongMessagesWithOtherthigns() {
        String basic = "{\"aps\":{\"alert\":\"\"}}";
        int wrapperOverhead = "{\"aps\":{\"alert\":\"\"}}".length();
        int cutoffForAlert = 256 - wrapperOverhead;
        int max_length = 256;
        PayloadBuilder wayShort = this.payloadOf(1).sound("default");
        Assert.assertFalse((boolean)wayShort.isTooLong());
        Assert.assertTrue((wayShort.length() <= 256 ? 1 : 0) != 0);
        PayloadBuilder bitShort = this.payloadOf(cutoffForAlert - 1).sound("default");
        bitShort.shrinkBody();
        Assert.assertFalse((boolean)bitShort.isTooLong());
        Assert.assertTrue((bitShort.length() <= 256 ? 1 : 0) != 0);
        PayloadBuilder border = this.payloadOf(cutoffForAlert).sound("default");
        border.shrinkBody();
        Assert.assertFalse((boolean)border.isTooLong());
        Assert.assertTrue((border.length() == 256 ? 1 : 0) != 0);
        PayloadBuilder abitLong = this.payloadOf(cutoffForAlert + 1).sound("default");
        abitLong.shrinkBody();
        Assert.assertFalse((boolean)abitLong.isTooLong());
        Assert.assertTrue((abitLong.length() == 256 ? 1 : 0) != 0);
        PayloadBuilder tooLong = this.payloadOf(cutoffForAlert + 1000).sound("default");
        tooLong.shrinkBody();
        Assert.assertFalse((boolean)tooLong.isTooLong());
        Assert.assertTrue((tooLong.length() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void removeAlertIfSooLong() {
        PayloadBuilder tooLong = APNS.newPayload().customField("test", (Object)this.strOfLen(256)).alertBody("what");
        tooLong.shrinkBody();
        String payload = tooLong.build();
        MatcherAssert.assertThat((Object)payload, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)"alert")));
    }

    private void assertEqualsJson(String expected, String actual) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map exNode = (Map)mapper.readValue(expected, Map.class);
            Map acNode = (Map)mapper.readValue(actual, Map.class);
            Assert.assertEquals((Object)exNode, (Object)acNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Test
    public void supportsMDM() {
        String mdm = APNS.newPayload().mdm("213").toString();
        String expected = "{\"mdm\":\"213\"}";
        this.assertEqualsJson("{\"mdm\":\"213\"}", mdm);
    }

    @Test
    public void supportsNewsstand() {
        String news = APNS.newPayload().forNewsstand().toString();
        String expected = "{\"aps\":{\"content-available\":1}}";
        this.assertEqualsJson("{\"aps\":{\"content-available\":1}}", news);
    }

    @Test
    public void tooLongWithCustomFields() {
        PayloadBuilder builder = new PayloadBuilder();
        builder.alertBody("12345678");
        builder.customField("ache1", (Object)"what");
        builder.customField("ache2", (Object)2);
        String s1 = builder.toString();
        MatcherAssert.assertThat((Object)s1, (Matcher)StringContains.containsString((String)"12345678"));
        String s2 = builder.toString();
        MatcherAssert.assertThat((Object)s2, (Matcher)StringContains.containsString((String)"12345678"));
        this.assertEqualsJson(s1, s2);
    }

    @Test
    public void trimWorksWithLongFields() {
        PayloadBuilder builder = new PayloadBuilder();
        String toolong = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        builder.alertBody("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        builder.actionKey("OK");
        builder.shrinkBody();
        String s2 = builder.toString();
        MatcherAssert.assertThat((Object)s2, (Matcher)StringContains.containsString((String)"12345678"));
    }

    @Test
    public void utf8Encoding() {
        String str = "esem\ufffdny";
        PayloadBuilder builder = new PayloadBuilder();
        String s1 = builder.alertBody("esem\ufffdny").toString();
        MatcherAssert.assertThat((Object)s1, (Matcher)StringContains.containsString((String)"esem\ufffdny"));
    }

    @Test
    public void utf8EncodingEscaped() {
        String str = "esem\u00e9ny";
        PayloadBuilder builder = new PayloadBuilder();
        String s1 = builder.alertBody("esem\u00e9ny").toString();
        MatcherAssert.assertThat((Object)s1, (Matcher)StringContains.containsString((String)"esem\u00e9ny"));
    }
}

