(ns clj-karaoke.lyrics-event-specs
  (:require [clojure.spec.alpha :as s]))


(s/def ::id string?)

(s/def ::zero-pos (s/or :zero zero? :pos pos?))

(s/valid? ::zero-pos 0)
(s/valid? ::zero-pos 1)
(s/valid? ::zero-pos 0.12) 
(s/valid? ::zero-pos -1)

(s/def ::offset (s/and number? ::zero-pos))
(s/def ::ticks (s/and int? ::zero-pos))
(s/def ::text string?)
(s/def ::midi-type #{1 5})
(s/def ::numbers (s/every ::zero-pos))
(s/def ::type   #{:lyrics-event})
(s/valid? ::type :lyrics-event)
(s/valid? ::type :another-event)
(s/def ::lyrics-event (s/keys :req-un [::ticks ::text ::ticks ::id]  :opt-un [::midi-type ::offset]))
(s/def ::lyrics-event-map (s/merge ::lyrics-event (s/keys :req-un [::type])))
