(ns zilch.mq
  (:refer-clojure :exclude [send])
  )

(defmacro zeromq-imports []
  '(do
    (import '[org.zeromq ZMQ ZMQ$Context ZMQ$Socket])
    ))

(zeromq-imports)

(defn ^ZMQ$Context context [threads]
  (ZMQ/context threads))

(defmacro with-context
  [id threads & body]
  `(let [~id (context ~threads)]
     (try ~@body
          (finally (.term ~id)))))

(def sndmore ZMQ/SNDMORE)

(def req ZMQ/REQ)
(def rep ZMQ/REP)
(def xreq ZMQ/XREQ)
(def xrep ZMQ/XREP)
(def pub ZMQ/PUB)
(def sub ZMQ/SUB)
(def pair ZMQ/PAIR)
(def push ZMQ/PUSH)
(def pull ZMQ/PULL)

(defn ^bytes barr [& arr]
  (byte-array (map byte arr)))

(defn ^ZMQ$Socket socket
  [^ZMQ$Context context type]
  (.socket context type))

(defn bind
  [^ZMQ$Socket socket url]
  (doto socket
    (.bind url)))

(defn connect
  [^ZMQ$Socket socket url]
  (doto socket
    (.connect url)))

(defn subscribe
  ([^ZMQ$Socket socket ^bytes topic]
     (doto socket
       (.subscribe topic)))
  ([^ZMQ$Socket socket]
     (subscribe socket (byte-array []))))

(defn unsubscribe
  ([^ZMQ$Socket socket ^bytes topic]
     (doto socket
       (.unsubscribe (.getBytes topic))))
  ([^ZMQ$Socket socket]
     (unsubscribe socket "")))

(defn send
  ([^ZMQ$Socket socket ^bytes message flags]
     (.send socket message flags))
  ([^ZMQ$Socket socket ^bytes message]
     (send socket message ZMQ/NOBLOCK)))

(defn ^bytes recv
  ([^ZMQ$Socket socket flags]
     (.recv socket flags))
  ([^ZMQ$Socket socket]
     (recv socket 0)))
