/*
 * Decompiled with CFR 0.152.
 */
package com.infochimps.elasticsearch;

import com.infochimps.elasticsearch.ElasticSearchOutputFormat;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ElasticTest
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ElasticTest.class);

    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf());
        job.setJarByClass(ElasticTest.class);
        job.setJobName("ElasticTest");
        job.setMapperClass(IndexMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(MapWritable.class);
        job.setOutputFormatClass(ElasticSearchOutputFormat.class);
        ArrayList<String> other_args = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
            other_args.add(args[i]);
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path((String)other_args.get(0))});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path((String)other_args.get(1)));
        try {
            job.waitForCompletion(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new ElasticTest(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexMapper
    extends Mapper<LongWritable, Text, NullWritable, MapWritable> {
        private String[] fieldNames;

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] fields = value.toString().split("\t");
            MapWritable record = new MapWritable();
            for (int i = 0; i < fields.length; ++i) {
                if (i >= this.fieldNames.length) continue;
                record.put((Writable)new Text(this.fieldNames[i]), (Writable)new Text(fields[i]));
            }
            context.write((Object)NullWritable.get(), (Object)record);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.fieldNames = conf.get("wonderdog.field.names").split(",");
        }
    }
}

