(ns restql.main
  (:require [restql.core.api.restql :as restql]
            [clj-http.conn-mgr :as http-conn]
            [clj-http.core :as http-core]
            [ring.adapter.jetty :as ring]))
(use 'ring.adapter.jetty)

(defn create-http-client [opts]
  (http-core/build-async-http-client {}
    (http-conn/make-reuseable-async-conn-manager {:connect-timeout 5000
                                                  :so-timeout 5000
                                                  :default-per-route 100})))

(defn make-restquery
  []
  (restql/execute-query :mappings {:test "http://localhost:9001"}
                        :query "from test"
                        :http-client (create-http-client {})))

(defn handler [request respond raise]
    (respond
        {:status 200
        :headers {"Content-Type" "text/html"}
        :body (str (make-restquery))}))

(ring/run-jetty handler {:port 3000 :async? true})