(defproject b-social/jason "0.0.1"
  :description "Factory functions around jsonista, mostly for key conversion."
  :url "https://github.com/b-social/jason"

  :license {:name "The MIT License"
            :url  "https://opensource.org/licenses/MIT"}

  :dependencies [[metosin/jsonista "0.2.2"]
                 [cheshire "5.9.0"]
                 [camel-snake-kebab "672421b575737c5496b7ddcfb83cf150b0d0bc75"]]

  :middleware [lein-git-down.plugin/inject-properties]

  :plugins [[lein-cloverage "1.0.13"]
            [lein-shell "0.5.0"]
            [lein-ancient "0.6.15"]
            [lein-changelog "0.3.2"]
            [lein-eftest "0.5.8"]
            [lein-codox "0.10.7"]
            [lein-cljfmt "0.6.4"]
            [lein-kibit "0.1.6"]
            [lein-bikeshed "0.5.1"]
            [reifyhealth/lein-git-down "0.3.5"]]

  :profiles {:shared {:dependencies
                      [[org.clojure/clojure "1.10.0"]
                       [eftest "0.5.8"]]}
             :dev    [:shared {:source-paths ["dev"]
                               :eftest       {:multithread? false}}]
             :test   [:shared {:eftest {:multithread? false}}]}

  :cloverage
  {:ns-exclude-regex [#"^user"]}

  :codox
  {:namespaces  [#"^jason\."]
   :output-path "docs"
   :source-uri  "https://github.com/b-social/jason/blob/{version}/{filepath}#L{line}"}

  :cljfmt {:indents ^:replace {#".*" [[:inner 0]]}}

  :git-down
  {camel-snake-kebab {:coordinates clj-commons/camel-snake-kebab}}

  :repositories [["public-github" {:url "git://github.com"}]]

  :deploy-repositories
  {"releases" {:url "https://repo.clojars.org" :creds :gpg}}

  :release-tasks
  [["shell" "git" "diff" "--exit-code"]
   ["change" "version" "leiningen.release/bump-version" "release"]
   ["codox"]
   ["changelog" "release"]
   ["shell" "sed" "-E" "-i" "" "s/\"[0-9]+\\.[0-9]+\\.[0-9]+\"/\"${:version}\"/g" "README.md"]
   ["shell" "git" "add" "."]
   ["vcs" "commit"]
   ["vcs" "tag"]
   ["deploy"]
   ["change" "version" "leiningen.release/bump-version"]
   ["vcs" "commit"]
   ["vcs" "tag"]
   ["vcs" "push"]]

  :aliases {"test"      ["with-profile" "test" "eftest" ":all"]
            "precommit" ["do"
                         ["check"]
                         ["kibit" "--replace"]
                         ["cljfmt" "fix"]
                         ["bikeshed"
                          "--name-collisions" "false"
                          "--verbose" "true"]
                         ["test"]]})
