// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__20255__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__20255__auto__){
return or__20255__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__20255__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__25319_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__25319_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__25324 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__25325 = null;
var count__25326 = (0);
var i__25327 = (0);
while(true){
if((i__25327 < count__25326)){
var n = cljs.core._nth.call(null,chunk__25325,i__25327);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__25328 = seq__25324;
var G__25329 = chunk__25325;
var G__25330 = count__25326;
var G__25331 = (i__25327 + (1));
seq__25324 = G__25328;
chunk__25325 = G__25329;
count__25326 = G__25330;
i__25327 = G__25331;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25324);
if(temp__4657__auto__){
var seq__25324__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25324__$1)){
var c__21069__auto__ = cljs.core.chunk_first.call(null,seq__25324__$1);
var G__25332 = cljs.core.chunk_rest.call(null,seq__25324__$1);
var G__25333 = c__21069__auto__;
var G__25334 = cljs.core.count.call(null,c__21069__auto__);
var G__25335 = (0);
seq__25324 = G__25332;
chunk__25325 = G__25333;
count__25326 = G__25334;
i__25327 = G__25335;
continue;
} else {
var n = cljs.core.first.call(null,seq__25324__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__25336 = cljs.core.next.call(null,seq__25324__$1);
var G__25337 = null;
var G__25338 = (0);
var G__25339 = (0);
seq__25324 = G__25336;
chunk__25325 = G__25337;
count__25326 = G__25338;
i__25327 = G__25339;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__25390_25401 = cljs.core.seq.call(null,deps);
var chunk__25391_25402 = null;
var count__25392_25403 = (0);
var i__25393_25404 = (0);
while(true){
if((i__25393_25404 < count__25392_25403)){
var dep_25405 = cljs.core._nth.call(null,chunk__25391_25402,i__25393_25404);
topo_sort_helper_STAR_.call(null,dep_25405,(depth + (1)),state);

var G__25406 = seq__25390_25401;
var G__25407 = chunk__25391_25402;
var G__25408 = count__25392_25403;
var G__25409 = (i__25393_25404 + (1));
seq__25390_25401 = G__25406;
chunk__25391_25402 = G__25407;
count__25392_25403 = G__25408;
i__25393_25404 = G__25409;
continue;
} else {
var temp__4657__auto___25410 = cljs.core.seq.call(null,seq__25390_25401);
if(temp__4657__auto___25410){
var seq__25390_25411__$1 = temp__4657__auto___25410;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25390_25411__$1)){
var c__21069__auto___25412 = cljs.core.chunk_first.call(null,seq__25390_25411__$1);
var G__25413 = cljs.core.chunk_rest.call(null,seq__25390_25411__$1);
var G__25414 = c__21069__auto___25412;
var G__25415 = cljs.core.count.call(null,c__21069__auto___25412);
var G__25416 = (0);
seq__25390_25401 = G__25413;
chunk__25391_25402 = G__25414;
count__25392_25403 = G__25415;
i__25393_25404 = G__25416;
continue;
} else {
var dep_25417 = cljs.core.first.call(null,seq__25390_25411__$1);
topo_sort_helper_STAR_.call(null,dep_25417,(depth + (1)),state);

var G__25418 = cljs.core.next.call(null,seq__25390_25411__$1);
var G__25419 = null;
var G__25420 = (0);
var G__25421 = (0);
seq__25390_25401 = G__25418;
chunk__25391_25402 = G__25419;
count__25392_25403 = G__25420;
i__25393_25404 = G__25421;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__25394){
var vec__25398 = p__25394;
var seq__25399 = cljs.core.seq.call(null,vec__25398);
var first__25400 = cljs.core.first.call(null,seq__25399);
var seq__25399__$1 = cljs.core.next.call(null,seq__25399);
var x = first__25400;
var xs = seq__25399__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__25398,seq__25399,first__25400,seq__25399__$1,x,xs,get_deps__$1){
return (function (p1__25340_SHARP_){
return clojure.set.difference.call(null,p1__25340_SHARP_,x);
});})(vec__25398,seq__25399,first__25400,seq__25399__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__25434 = cljs.core.seq.call(null,provides);
var chunk__25435 = null;
var count__25436 = (0);
var i__25437 = (0);
while(true){
if((i__25437 < count__25436)){
var prov = cljs.core._nth.call(null,chunk__25435,i__25437);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25438_25446 = cljs.core.seq.call(null,requires);
var chunk__25439_25447 = null;
var count__25440_25448 = (0);
var i__25441_25449 = (0);
while(true){
if((i__25441_25449 < count__25440_25448)){
var req_25450 = cljs.core._nth.call(null,chunk__25439_25447,i__25441_25449);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25450,prov);

var G__25451 = seq__25438_25446;
var G__25452 = chunk__25439_25447;
var G__25453 = count__25440_25448;
var G__25454 = (i__25441_25449 + (1));
seq__25438_25446 = G__25451;
chunk__25439_25447 = G__25452;
count__25440_25448 = G__25453;
i__25441_25449 = G__25454;
continue;
} else {
var temp__4657__auto___25455 = cljs.core.seq.call(null,seq__25438_25446);
if(temp__4657__auto___25455){
var seq__25438_25456__$1 = temp__4657__auto___25455;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25438_25456__$1)){
var c__21069__auto___25457 = cljs.core.chunk_first.call(null,seq__25438_25456__$1);
var G__25458 = cljs.core.chunk_rest.call(null,seq__25438_25456__$1);
var G__25459 = c__21069__auto___25457;
var G__25460 = cljs.core.count.call(null,c__21069__auto___25457);
var G__25461 = (0);
seq__25438_25446 = G__25458;
chunk__25439_25447 = G__25459;
count__25440_25448 = G__25460;
i__25441_25449 = G__25461;
continue;
} else {
var req_25462 = cljs.core.first.call(null,seq__25438_25456__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25462,prov);

var G__25463 = cljs.core.next.call(null,seq__25438_25456__$1);
var G__25464 = null;
var G__25465 = (0);
var G__25466 = (0);
seq__25438_25446 = G__25463;
chunk__25439_25447 = G__25464;
count__25440_25448 = G__25465;
i__25441_25449 = G__25466;
continue;
}
} else {
}
}
break;
}

var G__25467 = seq__25434;
var G__25468 = chunk__25435;
var G__25469 = count__25436;
var G__25470 = (i__25437 + (1));
seq__25434 = G__25467;
chunk__25435 = G__25468;
count__25436 = G__25469;
i__25437 = G__25470;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25434);
if(temp__4657__auto__){
var seq__25434__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25434__$1)){
var c__21069__auto__ = cljs.core.chunk_first.call(null,seq__25434__$1);
var G__25471 = cljs.core.chunk_rest.call(null,seq__25434__$1);
var G__25472 = c__21069__auto__;
var G__25473 = cljs.core.count.call(null,c__21069__auto__);
var G__25474 = (0);
seq__25434 = G__25471;
chunk__25435 = G__25472;
count__25436 = G__25473;
i__25437 = G__25474;
continue;
} else {
var prov = cljs.core.first.call(null,seq__25434__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25442_25475 = cljs.core.seq.call(null,requires);
var chunk__25443_25476 = null;
var count__25444_25477 = (0);
var i__25445_25478 = (0);
while(true){
if((i__25445_25478 < count__25444_25477)){
var req_25479 = cljs.core._nth.call(null,chunk__25443_25476,i__25445_25478);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25479,prov);

var G__25480 = seq__25442_25475;
var G__25481 = chunk__25443_25476;
var G__25482 = count__25444_25477;
var G__25483 = (i__25445_25478 + (1));
seq__25442_25475 = G__25480;
chunk__25443_25476 = G__25481;
count__25444_25477 = G__25482;
i__25445_25478 = G__25483;
continue;
} else {
var temp__4657__auto___25484__$1 = cljs.core.seq.call(null,seq__25442_25475);
if(temp__4657__auto___25484__$1){
var seq__25442_25485__$1 = temp__4657__auto___25484__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25442_25485__$1)){
var c__21069__auto___25486 = cljs.core.chunk_first.call(null,seq__25442_25485__$1);
var G__25487 = cljs.core.chunk_rest.call(null,seq__25442_25485__$1);
var G__25488 = c__21069__auto___25486;
var G__25489 = cljs.core.count.call(null,c__21069__auto___25486);
var G__25490 = (0);
seq__25442_25475 = G__25487;
chunk__25443_25476 = G__25488;
count__25444_25477 = G__25489;
i__25445_25478 = G__25490;
continue;
} else {
var req_25491 = cljs.core.first.call(null,seq__25442_25485__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25491,prov);

var G__25492 = cljs.core.next.call(null,seq__25442_25485__$1);
var G__25493 = null;
var G__25494 = (0);
var G__25495 = (0);
seq__25442_25475 = G__25492;
chunk__25443_25476 = G__25493;
count__25444_25477 = G__25494;
i__25445_25478 = G__25495;
continue;
}
} else {
}
}
break;
}

var G__25496 = cljs.core.next.call(null,seq__25434__$1);
var G__25497 = null;
var G__25498 = (0);
var G__25499 = (0);
seq__25434 = G__25496;
chunk__25435 = G__25497;
count__25436 = G__25498;
i__25437 = G__25499;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__25504_25508 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__25505_25509 = null;
var count__25506_25510 = (0);
var i__25507_25511 = (0);
while(true){
if((i__25507_25511 < count__25506_25510)){
var ns_25512 = cljs.core._nth.call(null,chunk__25505_25509,i__25507_25511);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25512);

var G__25513 = seq__25504_25508;
var G__25514 = chunk__25505_25509;
var G__25515 = count__25506_25510;
var G__25516 = (i__25507_25511 + (1));
seq__25504_25508 = G__25513;
chunk__25505_25509 = G__25514;
count__25506_25510 = G__25515;
i__25507_25511 = G__25516;
continue;
} else {
var temp__4657__auto___25517 = cljs.core.seq.call(null,seq__25504_25508);
if(temp__4657__auto___25517){
var seq__25504_25518__$1 = temp__4657__auto___25517;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25504_25518__$1)){
var c__21069__auto___25519 = cljs.core.chunk_first.call(null,seq__25504_25518__$1);
var G__25520 = cljs.core.chunk_rest.call(null,seq__25504_25518__$1);
var G__25521 = c__21069__auto___25519;
var G__25522 = cljs.core.count.call(null,c__21069__auto___25519);
var G__25523 = (0);
seq__25504_25508 = G__25520;
chunk__25505_25509 = G__25521;
count__25506_25510 = G__25522;
i__25507_25511 = G__25523;
continue;
} else {
var ns_25524 = cljs.core.first.call(null,seq__25504_25518__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25524);

var G__25525 = cljs.core.next.call(null,seq__25504_25518__$1);
var G__25526 = null;
var G__25527 = (0);
var G__25528 = (0);
seq__25504_25508 = G__25525;
chunk__25505_25509 = G__25526;
count__25506_25510 = G__25527;
i__25507_25511 = G__25528;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__20255__auto__ = goog.require__;
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__25529__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__25529 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25530__i = 0, G__25530__a = new Array(arguments.length -  0);
while (G__25530__i < G__25530__a.length) {G__25530__a[G__25530__i] = arguments[G__25530__i + 0]; ++G__25530__i;}
  args = new cljs.core.IndexedSeq(G__25530__a,0);
} 
return G__25529__delegate.call(this,args);};
G__25529.cljs$lang$maxFixedArity = 0;
G__25529.cljs$lang$applyTo = (function (arglist__25531){
var args = cljs.core.seq(arglist__25531);
return G__25529__delegate(args);
});
G__25529.cljs$core$IFn$_invoke$arity$variadic = G__25529__delegate;
return G__25529;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__25533 = cljs.core._EQ_;
var expr__25534 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__25533.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__25534))){
var path_parts = ((function (pred__25533,expr__25534){
return (function (p1__25532_SHARP_){
return clojure.string.split.call(null,p1__25532_SHARP_,/[\/\\]/);
});})(pred__25533,expr__25534))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__25533,expr__25534){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e25536){if((e25536 instanceof Error)){
var e = e25536;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e25536;

}
}})());
});
;})(path_parts,sep,root,pred__25533,expr__25534))
} else {
if(cljs.core.truth_(pred__25533.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__25534))){
return ((function (pred__25533,expr__25534){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__25533,expr__25534){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__25533,expr__25534))
);

return deferred.addErrback(((function (deferred,pred__25533,expr__25534){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__25533,expr__25534))
);
});
;})(pred__25533,expr__25534))
} else {
return ((function (pred__25533,expr__25534){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__25533,expr__25534))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__25537,callback){
var map__25540 = p__25537;
var map__25540__$1 = ((((!((map__25540 == null)))?((((map__25540.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25540.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25540):map__25540);
var file_msg = map__25540__$1;
var request_url = cljs.core.get.call(null,map__25540__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__25540,map__25540__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__25540,map__25540__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__22460__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto__){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto__){
return (function (state_25564){
var state_val_25565 = (state_25564[(1)]);
if((state_val_25565 === (7))){
var inst_25560 = (state_25564[(2)]);
var state_25564__$1 = state_25564;
var statearr_25566_25586 = state_25564__$1;
(statearr_25566_25586[(2)] = inst_25560);

(statearr_25566_25586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (1))){
var state_25564__$1 = state_25564;
var statearr_25567_25587 = state_25564__$1;
(statearr_25567_25587[(2)] = null);

(statearr_25567_25587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (4))){
var inst_25544 = (state_25564[(7)]);
var inst_25544__$1 = (state_25564[(2)]);
var state_25564__$1 = (function (){var statearr_25568 = state_25564;
(statearr_25568[(7)] = inst_25544__$1);

return statearr_25568;
})();
if(cljs.core.truth_(inst_25544__$1)){
var statearr_25569_25588 = state_25564__$1;
(statearr_25569_25588[(1)] = (5));

} else {
var statearr_25570_25589 = state_25564__$1;
(statearr_25570_25589[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (6))){
var state_25564__$1 = state_25564;
var statearr_25571_25590 = state_25564__$1;
(statearr_25571_25590[(2)] = null);

(statearr_25571_25590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (3))){
var inst_25562 = (state_25564[(2)]);
var state_25564__$1 = state_25564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25564__$1,inst_25562);
} else {
if((state_val_25565 === (2))){
var state_25564__$1 = state_25564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25564__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_25565 === (11))){
var inst_25556 = (state_25564[(2)]);
var state_25564__$1 = (function (){var statearr_25572 = state_25564;
(statearr_25572[(8)] = inst_25556);

return statearr_25572;
})();
var statearr_25573_25591 = state_25564__$1;
(statearr_25573_25591[(2)] = null);

(statearr_25573_25591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (9))){
var inst_25550 = (state_25564[(9)]);
var inst_25548 = (state_25564[(10)]);
var inst_25552 = inst_25550.call(null,inst_25548);
var state_25564__$1 = state_25564;
var statearr_25574_25592 = state_25564__$1;
(statearr_25574_25592[(2)] = inst_25552);

(statearr_25574_25592[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (5))){
var inst_25544 = (state_25564[(7)]);
var inst_25546 = figwheel.client.file_reloading.blocking_load.call(null,inst_25544);
var state_25564__$1 = state_25564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25564__$1,(8),inst_25546);
} else {
if((state_val_25565 === (10))){
var inst_25548 = (state_25564[(10)]);
var inst_25554 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_25548);
var state_25564__$1 = state_25564;
var statearr_25575_25593 = state_25564__$1;
(statearr_25575_25593[(2)] = inst_25554);

(statearr_25575_25593[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25565 === (8))){
var inst_25544 = (state_25564[(7)]);
var inst_25550 = (state_25564[(9)]);
var inst_25548 = (state_25564[(2)]);
var inst_25549 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_25550__$1 = cljs.core.get.call(null,inst_25549,inst_25544);
var state_25564__$1 = (function (){var statearr_25576 = state_25564;
(statearr_25576[(9)] = inst_25550__$1);

(statearr_25576[(10)] = inst_25548);

return statearr_25576;
})();
if(cljs.core.truth_(inst_25550__$1)){
var statearr_25577_25594 = state_25564__$1;
(statearr_25577_25594[(1)] = (9));

} else {
var statearr_25578_25595 = state_25564__$1;
(statearr_25578_25595[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto__))
;
return ((function (switch__22348__auto__,c__22460__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__22349__auto__ = null;
var figwheel$client$file_reloading$state_machine__22349__auto____0 = (function (){
var statearr_25582 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25582[(0)] = figwheel$client$file_reloading$state_machine__22349__auto__);

(statearr_25582[(1)] = (1));

return statearr_25582;
});
var figwheel$client$file_reloading$state_machine__22349__auto____1 = (function (state_25564){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_25564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e25583){if((e25583 instanceof Object)){
var ex__22352__auto__ = e25583;
var statearr_25584_25596 = state_25564;
(statearr_25584_25596[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25583;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25597 = state_25564;
state_25564 = G__25597;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__22349__auto__ = function(state_25564){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__22349__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__22349__auto____1.call(this,state_25564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__22349__auto____0;
figwheel$client$file_reloading$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__22349__auto____1;
return figwheel$client$file_reloading$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto__))
})();
var state__22462__auto__ = (function (){var statearr_25585 = f__22461__auto__.call(null);
(statearr_25585[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto__);

return statearr_25585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto__))
);

return c__22460__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__25598,callback){
var map__25601 = p__25598;
var map__25601__$1 = ((((!((map__25601 == null)))?((((map__25601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25601.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25601):map__25601);
var file_msg = map__25601__$1;
var namespace = cljs.core.get.call(null,map__25601__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__25601,map__25601__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__25601,map__25601__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__25603){
var map__25606 = p__25603;
var map__25606__$1 = ((((!((map__25606 == null)))?((((map__25606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25606.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25606):map__25606);
var file_msg = map__25606__$1;
var namespace = cljs.core.get.call(null,map__25606__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__20243__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__20243__auto__){
var or__20255__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
var or__20255__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20255__auto____$1)){
return or__20255__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__20243__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__25608,callback){
var map__25611 = p__25608;
var map__25611__$1 = ((((!((map__25611 == null)))?((((map__25611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25611.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25611):map__25611);
var file_msg = map__25611__$1;
var request_url = cljs.core.get.call(null,map__25611__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__25611__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__22460__auto___25715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___25715,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___25715,out){
return (function (state_25697){
var state_val_25698 = (state_25697[(1)]);
if((state_val_25698 === (1))){
var inst_25671 = cljs.core.seq.call(null,files);
var inst_25672 = cljs.core.first.call(null,inst_25671);
var inst_25673 = cljs.core.next.call(null,inst_25671);
var inst_25674 = files;
var state_25697__$1 = (function (){var statearr_25699 = state_25697;
(statearr_25699[(7)] = inst_25673);

(statearr_25699[(8)] = inst_25674);

(statearr_25699[(9)] = inst_25672);

return statearr_25699;
})();
var statearr_25700_25716 = state_25697__$1;
(statearr_25700_25716[(2)] = null);

(statearr_25700_25716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25698 === (2))){
var inst_25680 = (state_25697[(10)]);
var inst_25674 = (state_25697[(8)]);
var inst_25679 = cljs.core.seq.call(null,inst_25674);
var inst_25680__$1 = cljs.core.first.call(null,inst_25679);
var inst_25681 = cljs.core.next.call(null,inst_25679);
var inst_25682 = (inst_25680__$1 == null);
var inst_25683 = cljs.core.not.call(null,inst_25682);
var state_25697__$1 = (function (){var statearr_25701 = state_25697;
(statearr_25701[(10)] = inst_25680__$1);

(statearr_25701[(11)] = inst_25681);

return statearr_25701;
})();
if(inst_25683){
var statearr_25702_25717 = state_25697__$1;
(statearr_25702_25717[(1)] = (4));

} else {
var statearr_25703_25718 = state_25697__$1;
(statearr_25703_25718[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25698 === (3))){
var inst_25695 = (state_25697[(2)]);
var state_25697__$1 = state_25697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25697__$1,inst_25695);
} else {
if((state_val_25698 === (4))){
var inst_25680 = (state_25697[(10)]);
var inst_25685 = figwheel.client.file_reloading.reload_js_file.call(null,inst_25680);
var state_25697__$1 = state_25697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25697__$1,(7),inst_25685);
} else {
if((state_val_25698 === (5))){
var inst_25691 = cljs.core.async.close_BANG_.call(null,out);
var state_25697__$1 = state_25697;
var statearr_25704_25719 = state_25697__$1;
(statearr_25704_25719[(2)] = inst_25691);

(statearr_25704_25719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25698 === (6))){
var inst_25693 = (state_25697[(2)]);
var state_25697__$1 = state_25697;
var statearr_25705_25720 = state_25697__$1;
(statearr_25705_25720[(2)] = inst_25693);

(statearr_25705_25720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25698 === (7))){
var inst_25681 = (state_25697[(11)]);
var inst_25687 = (state_25697[(2)]);
var inst_25688 = cljs.core.async.put_BANG_.call(null,out,inst_25687);
var inst_25674 = inst_25681;
var state_25697__$1 = (function (){var statearr_25706 = state_25697;
(statearr_25706[(8)] = inst_25674);

(statearr_25706[(12)] = inst_25688);

return statearr_25706;
})();
var statearr_25707_25721 = state_25697__$1;
(statearr_25707_25721[(2)] = null);

(statearr_25707_25721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__22460__auto___25715,out))
;
return ((function (switch__22348__auto__,c__22460__auto___25715,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto____0 = (function (){
var statearr_25711 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25711[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto__);

(statearr_25711[(1)] = (1));

return statearr_25711;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto____1 = (function (state_25697){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_25697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e25712){if((e25712 instanceof Object)){
var ex__22352__auto__ = e25712;
var statearr_25713_25722 = state_25697;
(statearr_25713_25722[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25723 = state_25697;
state_25697 = G__25723;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto__ = function(state_25697){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto____1.call(this,state_25697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___25715,out))
})();
var state__22462__auto__ = (function (){var statearr_25714 = f__22461__auto__.call(null);
(statearr_25714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___25715);

return statearr_25714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___25715,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__25724,opts){
var map__25728 = p__25724;
var map__25728__$1 = ((((!((map__25728 == null)))?((((map__25728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25728.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25728):map__25728);
var eval_body = cljs.core.get.call(null,map__25728__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__25728__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__20243__auto__ = eval_body;
if(cljs.core.truth_(and__20243__auto__)){
return typeof eval_body === 'string';
} else {
return and__20243__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e25730){var e = e25730;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__25731_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25731_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__25740){
var vec__25741 = p__25740;
var k = cljs.core.nth.call(null,vec__25741,(0),null);
var v = cljs.core.nth.call(null,vec__25741,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__25744){
var vec__25745 = p__25744;
var k = cljs.core.nth.call(null,vec__25745,(0),null);
var v = cljs.core.nth.call(null,vec__25745,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__25751,p__25752){
var map__26000 = p__25751;
var map__26000__$1 = ((((!((map__26000 == null)))?((((map__26000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26000.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26000):map__26000);
var opts = map__26000__$1;
var before_jsload = cljs.core.get.call(null,map__26000__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__26000__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__26000__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__26001 = p__25752;
var map__26001__$1 = ((((!((map__26001 == null)))?((((map__26001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26001.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26001):map__26001);
var msg = map__26001__$1;
var files = cljs.core.get.call(null,map__26001__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__26001__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__26001__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__22460__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26155){
var state_val_26156 = (state_26155[(1)]);
if((state_val_26156 === (7))){
var inst_26017 = (state_26155[(7)]);
var inst_26018 = (state_26155[(8)]);
var inst_26015 = (state_26155[(9)]);
var inst_26016 = (state_26155[(10)]);
var inst_26023 = cljs.core._nth.call(null,inst_26016,inst_26018);
var inst_26024 = figwheel.client.file_reloading.eval_body.call(null,inst_26023,opts);
var inst_26025 = (inst_26018 + (1));
var tmp26157 = inst_26017;
var tmp26158 = inst_26015;
var tmp26159 = inst_26016;
var inst_26015__$1 = tmp26158;
var inst_26016__$1 = tmp26159;
var inst_26017__$1 = tmp26157;
var inst_26018__$1 = inst_26025;
var state_26155__$1 = (function (){var statearr_26160 = state_26155;
(statearr_26160[(7)] = inst_26017__$1);

(statearr_26160[(8)] = inst_26018__$1);

(statearr_26160[(9)] = inst_26015__$1);

(statearr_26160[(11)] = inst_26024);

(statearr_26160[(10)] = inst_26016__$1);

return statearr_26160;
})();
var statearr_26161_26247 = state_26155__$1;
(statearr_26161_26247[(2)] = null);

(statearr_26161_26247[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (20))){
var inst_26058 = (state_26155[(12)]);
var inst_26066 = figwheel.client.file_reloading.sort_files.call(null,inst_26058);
var state_26155__$1 = state_26155;
var statearr_26162_26248 = state_26155__$1;
(statearr_26162_26248[(2)] = inst_26066);

(statearr_26162_26248[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (27))){
var state_26155__$1 = state_26155;
var statearr_26163_26249 = state_26155__$1;
(statearr_26163_26249[(2)] = null);

(statearr_26163_26249[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (1))){
var inst_26007 = (state_26155[(13)]);
var inst_26004 = before_jsload.call(null,files);
var inst_26005 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_26006 = (function (){return ((function (inst_26007,inst_26004,inst_26005,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25748_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25748_SHARP_);
});
;})(inst_26007,inst_26004,inst_26005,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26007__$1 = cljs.core.filter.call(null,inst_26006,files);
var inst_26008 = cljs.core.not_empty.call(null,inst_26007__$1);
var state_26155__$1 = (function (){var statearr_26164 = state_26155;
(statearr_26164[(14)] = inst_26005);

(statearr_26164[(15)] = inst_26004);

(statearr_26164[(13)] = inst_26007__$1);

return statearr_26164;
})();
if(cljs.core.truth_(inst_26008)){
var statearr_26165_26250 = state_26155__$1;
(statearr_26165_26250[(1)] = (2));

} else {
var statearr_26166_26251 = state_26155__$1;
(statearr_26166_26251[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (24))){
var state_26155__$1 = state_26155;
var statearr_26167_26252 = state_26155__$1;
(statearr_26167_26252[(2)] = null);

(statearr_26167_26252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (39))){
var inst_26108 = (state_26155[(16)]);
var state_26155__$1 = state_26155;
var statearr_26168_26253 = state_26155__$1;
(statearr_26168_26253[(2)] = inst_26108);

(statearr_26168_26253[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (46))){
var inst_26150 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
var statearr_26169_26254 = state_26155__$1;
(statearr_26169_26254[(2)] = inst_26150);

(statearr_26169_26254[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (4))){
var inst_26052 = (state_26155[(2)]);
var inst_26053 = cljs.core.List.EMPTY;
var inst_26054 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_26053);
var inst_26055 = (function (){return ((function (inst_26052,inst_26053,inst_26054,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25749_SHARP_){
var and__20243__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25749_SHARP_);
if(cljs.core.truth_(and__20243__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25749_SHARP_));
} else {
return and__20243__auto__;
}
});
;})(inst_26052,inst_26053,inst_26054,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26056 = cljs.core.filter.call(null,inst_26055,files);
var inst_26057 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_26058 = cljs.core.concat.call(null,inst_26056,inst_26057);
var state_26155__$1 = (function (){var statearr_26170 = state_26155;
(statearr_26170[(12)] = inst_26058);

(statearr_26170[(17)] = inst_26054);

(statearr_26170[(18)] = inst_26052);

return statearr_26170;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26171_26255 = state_26155__$1;
(statearr_26171_26255[(1)] = (16));

} else {
var statearr_26172_26256 = state_26155__$1;
(statearr_26172_26256[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (15))){
var inst_26042 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
var statearr_26173_26257 = state_26155__$1;
(statearr_26173_26257[(2)] = inst_26042);

(statearr_26173_26257[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (21))){
var inst_26068 = (state_26155[(19)]);
var inst_26068__$1 = (state_26155[(2)]);
var inst_26069 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_26068__$1);
var state_26155__$1 = (function (){var statearr_26174 = state_26155;
(statearr_26174[(19)] = inst_26068__$1);

return statearr_26174;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26155__$1,(22),inst_26069);
} else {
if((state_val_26156 === (31))){
var inst_26153 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26155__$1,inst_26153);
} else {
if((state_val_26156 === (32))){
var inst_26108 = (state_26155[(16)]);
var inst_26113 = inst_26108.cljs$lang$protocol_mask$partition0$;
var inst_26114 = (inst_26113 & (64));
var inst_26115 = inst_26108.cljs$core$ISeq$;
var inst_26116 = (cljs.core.PROTOCOL_SENTINEL === inst_26115);
var inst_26117 = (inst_26114) || (inst_26116);
var state_26155__$1 = state_26155;
if(cljs.core.truth_(inst_26117)){
var statearr_26175_26258 = state_26155__$1;
(statearr_26175_26258[(1)] = (35));

} else {
var statearr_26176_26259 = state_26155__$1;
(statearr_26176_26259[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (40))){
var inst_26130 = (state_26155[(20)]);
var inst_26129 = (state_26155[(2)]);
var inst_26130__$1 = cljs.core.get.call(null,inst_26129,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26131 = cljs.core.get.call(null,inst_26129,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26132 = cljs.core.not_empty.call(null,inst_26130__$1);
var state_26155__$1 = (function (){var statearr_26177 = state_26155;
(statearr_26177[(21)] = inst_26131);

(statearr_26177[(20)] = inst_26130__$1);

return statearr_26177;
})();
if(cljs.core.truth_(inst_26132)){
var statearr_26178_26260 = state_26155__$1;
(statearr_26178_26260[(1)] = (41));

} else {
var statearr_26179_26261 = state_26155__$1;
(statearr_26179_26261[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (33))){
var state_26155__$1 = state_26155;
var statearr_26180_26262 = state_26155__$1;
(statearr_26180_26262[(2)] = false);

(statearr_26180_26262[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (13))){
var inst_26028 = (state_26155[(22)]);
var inst_26032 = cljs.core.chunk_first.call(null,inst_26028);
var inst_26033 = cljs.core.chunk_rest.call(null,inst_26028);
var inst_26034 = cljs.core.count.call(null,inst_26032);
var inst_26015 = inst_26033;
var inst_26016 = inst_26032;
var inst_26017 = inst_26034;
var inst_26018 = (0);
var state_26155__$1 = (function (){var statearr_26181 = state_26155;
(statearr_26181[(7)] = inst_26017);

(statearr_26181[(8)] = inst_26018);

(statearr_26181[(9)] = inst_26015);

(statearr_26181[(10)] = inst_26016);

return statearr_26181;
})();
var statearr_26182_26263 = state_26155__$1;
(statearr_26182_26263[(2)] = null);

(statearr_26182_26263[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (22))){
var inst_26076 = (state_26155[(23)]);
var inst_26071 = (state_26155[(24)]);
var inst_26068 = (state_26155[(19)]);
var inst_26072 = (state_26155[(25)]);
var inst_26071__$1 = (state_26155[(2)]);
var inst_26072__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26071__$1);
var inst_26073 = (function (){var all_files = inst_26068;
var res_SINGLEQUOTE_ = inst_26071__$1;
var res = inst_26072__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_26076,inst_26071,inst_26068,inst_26072,inst_26071__$1,inst_26072__$1,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25750_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__25750_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_26076,inst_26071,inst_26068,inst_26072,inst_26071__$1,inst_26072__$1,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26074 = cljs.core.filter.call(null,inst_26073,inst_26071__$1);
var inst_26075 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_26076__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26075);
var inst_26077 = cljs.core.not_empty.call(null,inst_26076__$1);
var state_26155__$1 = (function (){var statearr_26183 = state_26155;
(statearr_26183[(23)] = inst_26076__$1);

(statearr_26183[(24)] = inst_26071__$1);

(statearr_26183[(26)] = inst_26074);

(statearr_26183[(25)] = inst_26072__$1);

return statearr_26183;
})();
if(cljs.core.truth_(inst_26077)){
var statearr_26184_26264 = state_26155__$1;
(statearr_26184_26264[(1)] = (23));

} else {
var statearr_26185_26265 = state_26155__$1;
(statearr_26185_26265[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (36))){
var state_26155__$1 = state_26155;
var statearr_26186_26266 = state_26155__$1;
(statearr_26186_26266[(2)] = false);

(statearr_26186_26266[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (41))){
var inst_26130 = (state_26155[(20)]);
var inst_26134 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26135 = cljs.core.map.call(null,inst_26134,inst_26130);
var inst_26136 = cljs.core.pr_str.call(null,inst_26135);
var inst_26137 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_26136)].join('');
var inst_26138 = figwheel.client.utils.log.call(null,inst_26137);
var state_26155__$1 = state_26155;
var statearr_26187_26267 = state_26155__$1;
(statearr_26187_26267[(2)] = inst_26138);

(statearr_26187_26267[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (43))){
var inst_26131 = (state_26155[(21)]);
var inst_26141 = (state_26155[(2)]);
var inst_26142 = cljs.core.not_empty.call(null,inst_26131);
var state_26155__$1 = (function (){var statearr_26188 = state_26155;
(statearr_26188[(27)] = inst_26141);

return statearr_26188;
})();
if(cljs.core.truth_(inst_26142)){
var statearr_26189_26268 = state_26155__$1;
(statearr_26189_26268[(1)] = (44));

} else {
var statearr_26190_26269 = state_26155__$1;
(statearr_26190_26269[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (29))){
var inst_26076 = (state_26155[(23)]);
var inst_26071 = (state_26155[(24)]);
var inst_26068 = (state_26155[(19)]);
var inst_26074 = (state_26155[(26)]);
var inst_26072 = (state_26155[(25)]);
var inst_26108 = (state_26155[(16)]);
var inst_26104 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_26107 = (function (){var all_files = inst_26068;
var res_SINGLEQUOTE_ = inst_26071;
var res = inst_26072;
var files_not_loaded = inst_26074;
var dependencies_that_loaded = inst_26076;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26108,inst_26104,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26106){
var map__26191 = p__26106;
var map__26191__$1 = ((((!((map__26191 == null)))?((((map__26191.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26191.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26191):map__26191);
var namespace = cljs.core.get.call(null,map__26191__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26108,inst_26104,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26108__$1 = cljs.core.group_by.call(null,inst_26107,inst_26074);
var inst_26110 = (inst_26108__$1 == null);
var inst_26111 = cljs.core.not.call(null,inst_26110);
var state_26155__$1 = (function (){var statearr_26193 = state_26155;
(statearr_26193[(28)] = inst_26104);

(statearr_26193[(16)] = inst_26108__$1);

return statearr_26193;
})();
if(inst_26111){
var statearr_26194_26270 = state_26155__$1;
(statearr_26194_26270[(1)] = (32));

} else {
var statearr_26195_26271 = state_26155__$1;
(statearr_26195_26271[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (44))){
var inst_26131 = (state_26155[(21)]);
var inst_26144 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26131);
var inst_26145 = cljs.core.pr_str.call(null,inst_26144);
var inst_26146 = [cljs.core.str("not required: "),cljs.core.str(inst_26145)].join('');
var inst_26147 = figwheel.client.utils.log.call(null,inst_26146);
var state_26155__$1 = state_26155;
var statearr_26196_26272 = state_26155__$1;
(statearr_26196_26272[(2)] = inst_26147);

(statearr_26196_26272[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (6))){
var inst_26049 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
var statearr_26197_26273 = state_26155__$1;
(statearr_26197_26273[(2)] = inst_26049);

(statearr_26197_26273[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (28))){
var inst_26074 = (state_26155[(26)]);
var inst_26101 = (state_26155[(2)]);
var inst_26102 = cljs.core.not_empty.call(null,inst_26074);
var state_26155__$1 = (function (){var statearr_26198 = state_26155;
(statearr_26198[(29)] = inst_26101);

return statearr_26198;
})();
if(cljs.core.truth_(inst_26102)){
var statearr_26199_26274 = state_26155__$1;
(statearr_26199_26274[(1)] = (29));

} else {
var statearr_26200_26275 = state_26155__$1;
(statearr_26200_26275[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (25))){
var inst_26072 = (state_26155[(25)]);
var inst_26088 = (state_26155[(2)]);
var inst_26089 = cljs.core.not_empty.call(null,inst_26072);
var state_26155__$1 = (function (){var statearr_26201 = state_26155;
(statearr_26201[(30)] = inst_26088);

return statearr_26201;
})();
if(cljs.core.truth_(inst_26089)){
var statearr_26202_26276 = state_26155__$1;
(statearr_26202_26276[(1)] = (26));

} else {
var statearr_26203_26277 = state_26155__$1;
(statearr_26203_26277[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (34))){
var inst_26124 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
if(cljs.core.truth_(inst_26124)){
var statearr_26204_26278 = state_26155__$1;
(statearr_26204_26278[(1)] = (38));

} else {
var statearr_26205_26279 = state_26155__$1;
(statearr_26205_26279[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (17))){
var state_26155__$1 = state_26155;
var statearr_26206_26280 = state_26155__$1;
(statearr_26206_26280[(2)] = recompile_dependents);

(statearr_26206_26280[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (3))){
var state_26155__$1 = state_26155;
var statearr_26207_26281 = state_26155__$1;
(statearr_26207_26281[(2)] = null);

(statearr_26207_26281[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (12))){
var inst_26045 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
var statearr_26208_26282 = state_26155__$1;
(statearr_26208_26282[(2)] = inst_26045);

(statearr_26208_26282[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (2))){
var inst_26007 = (state_26155[(13)]);
var inst_26014 = cljs.core.seq.call(null,inst_26007);
var inst_26015 = inst_26014;
var inst_26016 = null;
var inst_26017 = (0);
var inst_26018 = (0);
var state_26155__$1 = (function (){var statearr_26209 = state_26155;
(statearr_26209[(7)] = inst_26017);

(statearr_26209[(8)] = inst_26018);

(statearr_26209[(9)] = inst_26015);

(statearr_26209[(10)] = inst_26016);

return statearr_26209;
})();
var statearr_26210_26283 = state_26155__$1;
(statearr_26210_26283[(2)] = null);

(statearr_26210_26283[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (23))){
var inst_26076 = (state_26155[(23)]);
var inst_26071 = (state_26155[(24)]);
var inst_26068 = (state_26155[(19)]);
var inst_26074 = (state_26155[(26)]);
var inst_26072 = (state_26155[(25)]);
var inst_26079 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_26081 = (function (){var all_files = inst_26068;
var res_SINGLEQUOTE_ = inst_26071;
var res = inst_26072;
var files_not_loaded = inst_26074;
var dependencies_that_loaded = inst_26076;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26079,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26080){
var map__26211 = p__26080;
var map__26211__$1 = ((((!((map__26211 == null)))?((((map__26211.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26211.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26211):map__26211);
var request_url = cljs.core.get.call(null,map__26211__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26079,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26082 = cljs.core.reverse.call(null,inst_26076);
var inst_26083 = cljs.core.map.call(null,inst_26081,inst_26082);
var inst_26084 = cljs.core.pr_str.call(null,inst_26083);
var inst_26085 = figwheel.client.utils.log.call(null,inst_26084);
var state_26155__$1 = (function (){var statearr_26213 = state_26155;
(statearr_26213[(31)] = inst_26079);

return statearr_26213;
})();
var statearr_26214_26284 = state_26155__$1;
(statearr_26214_26284[(2)] = inst_26085);

(statearr_26214_26284[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (35))){
var state_26155__$1 = state_26155;
var statearr_26215_26285 = state_26155__$1;
(statearr_26215_26285[(2)] = true);

(statearr_26215_26285[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (19))){
var inst_26058 = (state_26155[(12)]);
var inst_26064 = figwheel.client.file_reloading.expand_files.call(null,inst_26058);
var state_26155__$1 = state_26155;
var statearr_26216_26286 = state_26155__$1;
(statearr_26216_26286[(2)] = inst_26064);

(statearr_26216_26286[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (11))){
var state_26155__$1 = state_26155;
var statearr_26217_26287 = state_26155__$1;
(statearr_26217_26287[(2)] = null);

(statearr_26217_26287[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (9))){
var inst_26047 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
var statearr_26218_26288 = state_26155__$1;
(statearr_26218_26288[(2)] = inst_26047);

(statearr_26218_26288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (5))){
var inst_26017 = (state_26155[(7)]);
var inst_26018 = (state_26155[(8)]);
var inst_26020 = (inst_26018 < inst_26017);
var inst_26021 = inst_26020;
var state_26155__$1 = state_26155;
if(cljs.core.truth_(inst_26021)){
var statearr_26219_26289 = state_26155__$1;
(statearr_26219_26289[(1)] = (7));

} else {
var statearr_26220_26290 = state_26155__$1;
(statearr_26220_26290[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (14))){
var inst_26028 = (state_26155[(22)]);
var inst_26037 = cljs.core.first.call(null,inst_26028);
var inst_26038 = figwheel.client.file_reloading.eval_body.call(null,inst_26037,opts);
var inst_26039 = cljs.core.next.call(null,inst_26028);
var inst_26015 = inst_26039;
var inst_26016 = null;
var inst_26017 = (0);
var inst_26018 = (0);
var state_26155__$1 = (function (){var statearr_26221 = state_26155;
(statearr_26221[(7)] = inst_26017);

(statearr_26221[(8)] = inst_26018);

(statearr_26221[(32)] = inst_26038);

(statearr_26221[(9)] = inst_26015);

(statearr_26221[(10)] = inst_26016);

return statearr_26221;
})();
var statearr_26222_26291 = state_26155__$1;
(statearr_26222_26291[(2)] = null);

(statearr_26222_26291[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (45))){
var state_26155__$1 = state_26155;
var statearr_26223_26292 = state_26155__$1;
(statearr_26223_26292[(2)] = null);

(statearr_26223_26292[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (26))){
var inst_26076 = (state_26155[(23)]);
var inst_26071 = (state_26155[(24)]);
var inst_26068 = (state_26155[(19)]);
var inst_26074 = (state_26155[(26)]);
var inst_26072 = (state_26155[(25)]);
var inst_26091 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_26093 = (function (){var all_files = inst_26068;
var res_SINGLEQUOTE_ = inst_26071;
var res = inst_26072;
var files_not_loaded = inst_26074;
var dependencies_that_loaded = inst_26076;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26091,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26092){
var map__26224 = p__26092;
var map__26224__$1 = ((((!((map__26224 == null)))?((((map__26224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26224.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26224):map__26224);
var namespace = cljs.core.get.call(null,map__26224__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26224__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26091,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26094 = cljs.core.map.call(null,inst_26093,inst_26072);
var inst_26095 = cljs.core.pr_str.call(null,inst_26094);
var inst_26096 = figwheel.client.utils.log.call(null,inst_26095);
var inst_26097 = (function (){var all_files = inst_26068;
var res_SINGLEQUOTE_ = inst_26071;
var res = inst_26072;
var files_not_loaded = inst_26074;
var dependencies_that_loaded = inst_26076;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26091,inst_26093,inst_26094,inst_26095,inst_26096,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26076,inst_26071,inst_26068,inst_26074,inst_26072,inst_26091,inst_26093,inst_26094,inst_26095,inst_26096,state_val_26156,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26098 = setTimeout(inst_26097,(10));
var state_26155__$1 = (function (){var statearr_26226 = state_26155;
(statearr_26226[(33)] = inst_26091);

(statearr_26226[(34)] = inst_26096);

return statearr_26226;
})();
var statearr_26227_26293 = state_26155__$1;
(statearr_26227_26293[(2)] = inst_26098);

(statearr_26227_26293[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (16))){
var state_26155__$1 = state_26155;
var statearr_26228_26294 = state_26155__$1;
(statearr_26228_26294[(2)] = reload_dependents);

(statearr_26228_26294[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (38))){
var inst_26108 = (state_26155[(16)]);
var inst_26126 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26108);
var state_26155__$1 = state_26155;
var statearr_26229_26295 = state_26155__$1;
(statearr_26229_26295[(2)] = inst_26126);

(statearr_26229_26295[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (30))){
var state_26155__$1 = state_26155;
var statearr_26230_26296 = state_26155__$1;
(statearr_26230_26296[(2)] = null);

(statearr_26230_26296[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (10))){
var inst_26028 = (state_26155[(22)]);
var inst_26030 = cljs.core.chunked_seq_QMARK_.call(null,inst_26028);
var state_26155__$1 = state_26155;
if(inst_26030){
var statearr_26231_26297 = state_26155__$1;
(statearr_26231_26297[(1)] = (13));

} else {
var statearr_26232_26298 = state_26155__$1;
(statearr_26232_26298[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (18))){
var inst_26062 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
if(cljs.core.truth_(inst_26062)){
var statearr_26233_26299 = state_26155__$1;
(statearr_26233_26299[(1)] = (19));

} else {
var statearr_26234_26300 = state_26155__$1;
(statearr_26234_26300[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (42))){
var state_26155__$1 = state_26155;
var statearr_26235_26301 = state_26155__$1;
(statearr_26235_26301[(2)] = null);

(statearr_26235_26301[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (37))){
var inst_26121 = (state_26155[(2)]);
var state_26155__$1 = state_26155;
var statearr_26236_26302 = state_26155__$1;
(statearr_26236_26302[(2)] = inst_26121);

(statearr_26236_26302[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26156 === (8))){
var inst_26015 = (state_26155[(9)]);
var inst_26028 = (state_26155[(22)]);
var inst_26028__$1 = cljs.core.seq.call(null,inst_26015);
var state_26155__$1 = (function (){var statearr_26237 = state_26155;
(statearr_26237[(22)] = inst_26028__$1);

return statearr_26237;
})();
if(inst_26028__$1){
var statearr_26238_26303 = state_26155__$1;
(statearr_26238_26303[(1)] = (10));

} else {
var statearr_26239_26304 = state_26155__$1;
(statearr_26239_26304[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__22348__auto__,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto____0 = (function (){
var statearr_26243 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26243[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto__);

(statearr_26243[(1)] = (1));

return statearr_26243;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto____1 = (function (state_26155){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_26155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e26244){if((e26244 instanceof Object)){
var ex__22352__auto__ = e26244;
var statearr_26245_26305 = state_26155;
(statearr_26245_26305[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26155);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26244;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26306 = state_26155;
state_26155 = G__26306;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto__ = function(state_26155){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto____1.call(this,state_26155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__22462__auto__ = (function (){var statearr_26246 = f__22461__auto__.call(null);
(statearr_26246[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto__);

return statearr_26246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto__,map__26000,map__26000__$1,opts,before_jsload,on_jsload,reload_dependents,map__26001,map__26001__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__22460__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__26309,link){
var map__26312 = p__26309;
var map__26312__$1 = ((((!((map__26312 == null)))?((((map__26312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26312):map__26312);
var file = cljs.core.get.call(null,map__26312__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__26312,map__26312__$1,file){
return (function (p1__26307_SHARP_,p2__26308_SHARP_){
if(cljs.core._EQ_.call(null,p1__26307_SHARP_,p2__26308_SHARP_)){
return p1__26307_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__26312,map__26312__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__26318){
var map__26319 = p__26318;
var map__26319__$1 = ((((!((map__26319 == null)))?((((map__26319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26319.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26319):map__26319);
var match_length = cljs.core.get.call(null,map__26319__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__26319__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__26314_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__26314_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args26321 = [];
var len__21363__auto___26324 = arguments.length;
var i__21364__auto___26325 = (0);
while(true){
if((i__21364__auto___26325 < len__21363__auto___26324)){
args26321.push((arguments[i__21364__auto___26325]));

var G__26326 = (i__21364__auto___26325 + (1));
i__21364__auto___26325 = G__26326;
continue;
} else {
}
break;
}

var G__26323 = args26321.length;
switch (G__26323) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26321.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__26328_SHARP_,p2__26329_SHARP_){
return cljs.core.assoc.call(null,p1__26328_SHARP_,cljs.core.get.call(null,p2__26329_SHARP_,key),p2__26329_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__26330){
var map__26333 = p__26330;
var map__26333__$1 = ((((!((map__26333 == null)))?((((map__26333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26333.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26333):map__26333);
var f_data = map__26333__$1;
var file = cljs.core.get.call(null,map__26333__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__26335,files_msg){
var map__26342 = p__26335;
var map__26342__$1 = ((((!((map__26342 == null)))?((((map__26342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26342.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26342):map__26342);
var opts = map__26342__$1;
var on_cssload = cljs.core.get.call(null,map__26342__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__26344_26348 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__26345_26349 = null;
var count__26346_26350 = (0);
var i__26347_26351 = (0);
while(true){
if((i__26347_26351 < count__26346_26350)){
var f_26352 = cljs.core._nth.call(null,chunk__26345_26349,i__26347_26351);
figwheel.client.file_reloading.reload_css_file.call(null,f_26352);

var G__26353 = seq__26344_26348;
var G__26354 = chunk__26345_26349;
var G__26355 = count__26346_26350;
var G__26356 = (i__26347_26351 + (1));
seq__26344_26348 = G__26353;
chunk__26345_26349 = G__26354;
count__26346_26350 = G__26355;
i__26347_26351 = G__26356;
continue;
} else {
var temp__4657__auto___26357 = cljs.core.seq.call(null,seq__26344_26348);
if(temp__4657__auto___26357){
var seq__26344_26358__$1 = temp__4657__auto___26357;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26344_26358__$1)){
var c__21069__auto___26359 = cljs.core.chunk_first.call(null,seq__26344_26358__$1);
var G__26360 = cljs.core.chunk_rest.call(null,seq__26344_26358__$1);
var G__26361 = c__21069__auto___26359;
var G__26362 = cljs.core.count.call(null,c__21069__auto___26359);
var G__26363 = (0);
seq__26344_26348 = G__26360;
chunk__26345_26349 = G__26361;
count__26346_26350 = G__26362;
i__26347_26351 = G__26363;
continue;
} else {
var f_26364 = cljs.core.first.call(null,seq__26344_26358__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_26364);

var G__26365 = cljs.core.next.call(null,seq__26344_26358__$1);
var G__26366 = null;
var G__26367 = (0);
var G__26368 = (0);
seq__26344_26348 = G__26365;
chunk__26345_26349 = G__26366;
count__26346_26350 = G__26367;
i__26347_26351 = G__26368;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__26342,map__26342__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__26342,map__26342__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1508505829844