// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args22505 = [];
var len__21363__auto___22511 = arguments.length;
var i__21364__auto___22512 = (0);
while(true){
if((i__21364__auto___22512 < len__21363__auto___22511)){
args22505.push((arguments[i__21364__auto___22512]));

var G__22513 = (i__21364__auto___22512 + (1));
i__21364__auto___22512 = G__22513;
continue;
} else {
}
break;
}

var G__22507 = args22505.length;
switch (G__22507) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22505.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async22508 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22508 = (function (f,blockable,meta22509){
this.f = f;
this.blockable = blockable;
this.meta22509 = meta22509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22510,meta22509__$1){
var self__ = this;
var _22510__$1 = this;
return (new cljs.core.async.t_cljs$core$async22508(self__.f,self__.blockable,meta22509__$1));
});

cljs.core.async.t_cljs$core$async22508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22510){
var self__ = this;
var _22510__$1 = this;
return self__.meta22509;
});

cljs.core.async.t_cljs$core$async22508.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22508.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async22508.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async22508.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async22508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta22509","meta22509",-1250660645,null)], null);
});

cljs.core.async.t_cljs$core$async22508.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22508.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22508";

cljs.core.async.t_cljs$core$async22508.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async22508");
});

cljs.core.async.__GT_t_cljs$core$async22508 = (function cljs$core$async$__GT_t_cljs$core$async22508(f__$1,blockable__$1,meta22509){
return (new cljs.core.async.t_cljs$core$async22508(f__$1,blockable__$1,meta22509));
});

}

return (new cljs.core.async.t_cljs$core$async22508(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args22517 = [];
var len__21363__auto___22520 = arguments.length;
var i__21364__auto___22521 = (0);
while(true){
if((i__21364__auto___22521 < len__21363__auto___22520)){
args22517.push((arguments[i__21364__auto___22521]));

var G__22522 = (i__21364__auto___22521 + (1));
i__21364__auto___22521 = G__22522;
continue;
} else {
}
break;
}

var G__22519 = args22517.length;
switch (G__22519) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22517.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args22524 = [];
var len__21363__auto___22527 = arguments.length;
var i__21364__auto___22528 = (0);
while(true){
if((i__21364__auto___22528 < len__21363__auto___22527)){
args22524.push((arguments[i__21364__auto___22528]));

var G__22529 = (i__21364__auto___22528 + (1));
i__21364__auto___22528 = G__22529;
continue;
} else {
}
break;
}

var G__22526 = args22524.length;
switch (G__22526) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22524.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args22531 = [];
var len__21363__auto___22534 = arguments.length;
var i__21364__auto___22535 = (0);
while(true){
if((i__21364__auto___22535 < len__21363__auto___22534)){
args22531.push((arguments[i__21364__auto___22535]));

var G__22536 = (i__21364__auto___22535 + (1));
i__21364__auto___22535 = G__22536;
continue;
} else {
}
break;
}

var G__22533 = args22531.length;
switch (G__22533) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22531.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_22538 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_22538);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_22538,ret){
return (function (){
return fn1.call(null,val_22538);
});})(val_22538,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args22539 = [];
var len__21363__auto___22542 = arguments.length;
var i__21364__auto___22543 = (0);
while(true){
if((i__21364__auto___22543 < len__21363__auto___22542)){
args22539.push((arguments[i__21364__auto___22543]));

var G__22544 = (i__21364__auto___22543 + (1));
i__21364__auto___22543 = G__22544;
continue;
} else {
}
break;
}

var G__22541 = args22539.length;
switch (G__22541) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22539.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__21173__auto___22546 = n;
var x_22547 = (0);
while(true){
if((x_22547 < n__21173__auto___22546)){
(a[x_22547] = (0));

var G__22548 = (x_22547 + (1));
x_22547 = G__22548;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__22549 = (i + (1));
i = G__22549;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async22553 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22553 = (function (flag,meta22554){
this.flag = flag;
this.meta22554 = meta22554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_22555,meta22554__$1){
var self__ = this;
var _22555__$1 = this;
return (new cljs.core.async.t_cljs$core$async22553(self__.flag,meta22554__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async22553.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_22555){
var self__ = this;
var _22555__$1 = this;
return self__.meta22554;
});})(flag))
;

cljs.core.async.t_cljs$core$async22553.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22553.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async22553.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async22553.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async22553.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta22554","meta22554",340072855,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async22553.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22553";

cljs.core.async.t_cljs$core$async22553.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async22553");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async22553 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async22553(flag__$1,meta22554){
return (new cljs.core.async.t_cljs$core$async22553(flag__$1,meta22554));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async22553(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async22559 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22559 = (function (flag,cb,meta22560){
this.flag = flag;
this.cb = cb;
this.meta22560 = meta22560;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22559.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22561,meta22560__$1){
var self__ = this;
var _22561__$1 = this;
return (new cljs.core.async.t_cljs$core$async22559(self__.flag,self__.cb,meta22560__$1));
});

cljs.core.async.t_cljs$core$async22559.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22561){
var self__ = this;
var _22561__$1 = this;
return self__.meta22560;
});

cljs.core.async.t_cljs$core$async22559.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22559.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async22559.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async22559.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async22559.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta22560","meta22560",939630965,null)], null);
});

cljs.core.async.t_cljs$core$async22559.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22559.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22559";

cljs.core.async.t_cljs$core$async22559.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async22559");
});

cljs.core.async.__GT_t_cljs$core$async22559 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async22559(flag__$1,cb__$1,meta22560){
return (new cljs.core.async.t_cljs$core$async22559(flag__$1,cb__$1,meta22560));
});

}

return (new cljs.core.async.t_cljs$core$async22559(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22562_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22562_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22563_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22563_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__20255__auto__ = wport;
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return port;
}
})()], null));
} else {
var G__22564 = (i + (1));
i = G__22564;
continue;
}
} else {
return null;
}
break;
}
})();
var or__20255__auto__ = ret;
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__20243__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__20243__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__20243__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__21370__auto__ = [];
var len__21363__auto___22570 = arguments.length;
var i__21364__auto___22571 = (0);
while(true){
if((i__21364__auto___22571 < len__21363__auto___22570)){
args__21370__auto__.push((arguments[i__21364__auto___22571]));

var G__22572 = (i__21364__auto___22571 + (1));
i__21364__auto___22571 = G__22572;
continue;
} else {
}
break;
}

var argseq__21371__auto__ = ((((1) < args__21370__auto__.length))?(new cljs.core.IndexedSeq(args__21370__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21371__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__22567){
var map__22568 = p__22567;
var map__22568__$1 = ((((!((map__22568 == null)))?((((map__22568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22568.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22568):map__22568);
var opts = map__22568__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq22565){
var G__22566 = cljs.core.first.call(null,seq22565);
var seq22565__$1 = cljs.core.next.call(null,seq22565);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22566,seq22565__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args22573 = [];
var len__21363__auto___22623 = arguments.length;
var i__21364__auto___22624 = (0);
while(true){
if((i__21364__auto___22624 < len__21363__auto___22623)){
args22573.push((arguments[i__21364__auto___22624]));

var G__22625 = (i__21364__auto___22624 + (1));
i__21364__auto___22624 = G__22625;
continue;
} else {
}
break;
}

var G__22575 = args22573.length;
switch (G__22575) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22573.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__22460__auto___22627 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___22627){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___22627){
return (function (state_22599){
var state_val_22600 = (state_22599[(1)]);
if((state_val_22600 === (7))){
var inst_22595 = (state_22599[(2)]);
var state_22599__$1 = state_22599;
var statearr_22601_22628 = state_22599__$1;
(statearr_22601_22628[(2)] = inst_22595);

(statearr_22601_22628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (1))){
var state_22599__$1 = state_22599;
var statearr_22602_22629 = state_22599__$1;
(statearr_22602_22629[(2)] = null);

(statearr_22602_22629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (4))){
var inst_22578 = (state_22599[(7)]);
var inst_22578__$1 = (state_22599[(2)]);
var inst_22579 = (inst_22578__$1 == null);
var state_22599__$1 = (function (){var statearr_22603 = state_22599;
(statearr_22603[(7)] = inst_22578__$1);

return statearr_22603;
})();
if(cljs.core.truth_(inst_22579)){
var statearr_22604_22630 = state_22599__$1;
(statearr_22604_22630[(1)] = (5));

} else {
var statearr_22605_22631 = state_22599__$1;
(statearr_22605_22631[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (13))){
var state_22599__$1 = state_22599;
var statearr_22606_22632 = state_22599__$1;
(statearr_22606_22632[(2)] = null);

(statearr_22606_22632[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (6))){
var inst_22578 = (state_22599[(7)]);
var state_22599__$1 = state_22599;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22599__$1,(11),to,inst_22578);
} else {
if((state_val_22600 === (3))){
var inst_22597 = (state_22599[(2)]);
var state_22599__$1 = state_22599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22599__$1,inst_22597);
} else {
if((state_val_22600 === (12))){
var state_22599__$1 = state_22599;
var statearr_22607_22633 = state_22599__$1;
(statearr_22607_22633[(2)] = null);

(statearr_22607_22633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (2))){
var state_22599__$1 = state_22599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22599__$1,(4),from);
} else {
if((state_val_22600 === (11))){
var inst_22588 = (state_22599[(2)]);
var state_22599__$1 = state_22599;
if(cljs.core.truth_(inst_22588)){
var statearr_22608_22634 = state_22599__$1;
(statearr_22608_22634[(1)] = (12));

} else {
var statearr_22609_22635 = state_22599__$1;
(statearr_22609_22635[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (9))){
var state_22599__$1 = state_22599;
var statearr_22610_22636 = state_22599__$1;
(statearr_22610_22636[(2)] = null);

(statearr_22610_22636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (5))){
var state_22599__$1 = state_22599;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22611_22637 = state_22599__$1;
(statearr_22611_22637[(1)] = (8));

} else {
var statearr_22612_22638 = state_22599__$1;
(statearr_22612_22638[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (14))){
var inst_22593 = (state_22599[(2)]);
var state_22599__$1 = state_22599;
var statearr_22613_22639 = state_22599__$1;
(statearr_22613_22639[(2)] = inst_22593);

(statearr_22613_22639[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (10))){
var inst_22585 = (state_22599[(2)]);
var state_22599__$1 = state_22599;
var statearr_22614_22640 = state_22599__$1;
(statearr_22614_22640[(2)] = inst_22585);

(statearr_22614_22640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22600 === (8))){
var inst_22582 = cljs.core.async.close_BANG_.call(null,to);
var state_22599__$1 = state_22599;
var statearr_22615_22641 = state_22599__$1;
(statearr_22615_22641[(2)] = inst_22582);

(statearr_22615_22641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___22627))
;
return ((function (switch__22348__auto__,c__22460__auto___22627){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_22619 = [null,null,null,null,null,null,null,null];
(statearr_22619[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_22619[(1)] = (1));

return statearr_22619;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_22599){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_22599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e22620){if((e22620 instanceof Object)){
var ex__22352__auto__ = e22620;
var statearr_22621_22642 = state_22599;
(statearr_22621_22642[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22599);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22643 = state_22599;
state_22599 = G__22643;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_22599){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_22599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___22627))
})();
var state__22462__auto__ = (function (){var statearr_22622 = f__22461__auto__.call(null);
(statearr_22622[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___22627);

return statearr_22622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___22627))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__22831){
var vec__22832 = p__22831;
var v = cljs.core.nth.call(null,vec__22832,(0),null);
var p = cljs.core.nth.call(null,vec__22832,(1),null);
var job = vec__22832;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__22460__auto___23018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___23018,res,vec__22832,v,p,job,jobs,results){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___23018,res,vec__22832,v,p,job,jobs,results){
return (function (state_22839){
var state_val_22840 = (state_22839[(1)]);
if((state_val_22840 === (1))){
var state_22839__$1 = state_22839;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22839__$1,(2),res,v);
} else {
if((state_val_22840 === (2))){
var inst_22836 = (state_22839[(2)]);
var inst_22837 = cljs.core.async.close_BANG_.call(null,res);
var state_22839__$1 = (function (){var statearr_22841 = state_22839;
(statearr_22841[(7)] = inst_22836);

return statearr_22841;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22839__$1,inst_22837);
} else {
return null;
}
}
});})(c__22460__auto___23018,res,vec__22832,v,p,job,jobs,results))
;
return ((function (switch__22348__auto__,c__22460__auto___23018,res,vec__22832,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0 = (function (){
var statearr_22845 = [null,null,null,null,null,null,null,null];
(statearr_22845[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__);

(statearr_22845[(1)] = (1));

return statearr_22845;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1 = (function (state_22839){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_22839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e22846){if((e22846 instanceof Object)){
var ex__22352__auto__ = e22846;
var statearr_22847_23019 = state_22839;
(statearr_22847_23019[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22839);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22846;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23020 = state_22839;
state_22839 = G__23020;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = function(state_22839){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1.call(this,state_22839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___23018,res,vec__22832,v,p,job,jobs,results))
})();
var state__22462__auto__ = (function (){var statearr_22848 = f__22461__auto__.call(null);
(statearr_22848[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___23018);

return statearr_22848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___23018,res,vec__22832,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__22849){
var vec__22850 = p__22849;
var v = cljs.core.nth.call(null,vec__22850,(0),null);
var p = cljs.core.nth.call(null,vec__22850,(1),null);
var job = vec__22850;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__21173__auto___23021 = n;
var __23022 = (0);
while(true){
if((__23022 < n__21173__auto___23021)){
var G__22853_23023 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22853_23023) {
case "compute":
var c__22460__auto___23025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23022,c__22460__auto___23025,G__22853_23023,n__21173__auto___23021,jobs,results,process,async){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (__23022,c__22460__auto___23025,G__22853_23023,n__21173__auto___23021,jobs,results,process,async){
return (function (state_22866){
var state_val_22867 = (state_22866[(1)]);
if((state_val_22867 === (1))){
var state_22866__$1 = state_22866;
var statearr_22868_23026 = state_22866__$1;
(statearr_22868_23026[(2)] = null);

(statearr_22868_23026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22867 === (2))){
var state_22866__$1 = state_22866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22866__$1,(4),jobs);
} else {
if((state_val_22867 === (3))){
var inst_22864 = (state_22866[(2)]);
var state_22866__$1 = state_22866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22866__$1,inst_22864);
} else {
if((state_val_22867 === (4))){
var inst_22856 = (state_22866[(2)]);
var inst_22857 = process.call(null,inst_22856);
var state_22866__$1 = state_22866;
if(cljs.core.truth_(inst_22857)){
var statearr_22869_23027 = state_22866__$1;
(statearr_22869_23027[(1)] = (5));

} else {
var statearr_22870_23028 = state_22866__$1;
(statearr_22870_23028[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22867 === (5))){
var state_22866__$1 = state_22866;
var statearr_22871_23029 = state_22866__$1;
(statearr_22871_23029[(2)] = null);

(statearr_22871_23029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22867 === (6))){
var state_22866__$1 = state_22866;
var statearr_22872_23030 = state_22866__$1;
(statearr_22872_23030[(2)] = null);

(statearr_22872_23030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22867 === (7))){
var inst_22862 = (state_22866[(2)]);
var state_22866__$1 = state_22866;
var statearr_22873_23031 = state_22866__$1;
(statearr_22873_23031[(2)] = inst_22862);

(statearr_22873_23031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23022,c__22460__auto___23025,G__22853_23023,n__21173__auto___23021,jobs,results,process,async))
;
return ((function (__23022,switch__22348__auto__,c__22460__auto___23025,G__22853_23023,n__21173__auto___23021,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0 = (function (){
var statearr_22877 = [null,null,null,null,null,null,null];
(statearr_22877[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__);

(statearr_22877[(1)] = (1));

return statearr_22877;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1 = (function (state_22866){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_22866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e22878){if((e22878 instanceof Object)){
var ex__22352__auto__ = e22878;
var statearr_22879_23032 = state_22866;
(statearr_22879_23032[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22866);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22878;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23033 = state_22866;
state_22866 = G__23033;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = function(state_22866){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1.call(this,state_22866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__;
})()
;})(__23022,switch__22348__auto__,c__22460__auto___23025,G__22853_23023,n__21173__auto___23021,jobs,results,process,async))
})();
var state__22462__auto__ = (function (){var statearr_22880 = f__22461__auto__.call(null);
(statearr_22880[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___23025);

return statearr_22880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(__23022,c__22460__auto___23025,G__22853_23023,n__21173__auto___23021,jobs,results,process,async))
);


break;
case "async":
var c__22460__auto___23034 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23022,c__22460__auto___23034,G__22853_23023,n__21173__auto___23021,jobs,results,process,async){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (__23022,c__22460__auto___23034,G__22853_23023,n__21173__auto___23021,jobs,results,process,async){
return (function (state_22893){
var state_val_22894 = (state_22893[(1)]);
if((state_val_22894 === (1))){
var state_22893__$1 = state_22893;
var statearr_22895_23035 = state_22893__$1;
(statearr_22895_23035[(2)] = null);

(statearr_22895_23035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22894 === (2))){
var state_22893__$1 = state_22893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22893__$1,(4),jobs);
} else {
if((state_val_22894 === (3))){
var inst_22891 = (state_22893[(2)]);
var state_22893__$1 = state_22893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22893__$1,inst_22891);
} else {
if((state_val_22894 === (4))){
var inst_22883 = (state_22893[(2)]);
var inst_22884 = async.call(null,inst_22883);
var state_22893__$1 = state_22893;
if(cljs.core.truth_(inst_22884)){
var statearr_22896_23036 = state_22893__$1;
(statearr_22896_23036[(1)] = (5));

} else {
var statearr_22897_23037 = state_22893__$1;
(statearr_22897_23037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22894 === (5))){
var state_22893__$1 = state_22893;
var statearr_22898_23038 = state_22893__$1;
(statearr_22898_23038[(2)] = null);

(statearr_22898_23038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22894 === (6))){
var state_22893__$1 = state_22893;
var statearr_22899_23039 = state_22893__$1;
(statearr_22899_23039[(2)] = null);

(statearr_22899_23039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22894 === (7))){
var inst_22889 = (state_22893[(2)]);
var state_22893__$1 = state_22893;
var statearr_22900_23040 = state_22893__$1;
(statearr_22900_23040[(2)] = inst_22889);

(statearr_22900_23040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23022,c__22460__auto___23034,G__22853_23023,n__21173__auto___23021,jobs,results,process,async))
;
return ((function (__23022,switch__22348__auto__,c__22460__auto___23034,G__22853_23023,n__21173__auto___23021,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0 = (function (){
var statearr_22904 = [null,null,null,null,null,null,null];
(statearr_22904[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__);

(statearr_22904[(1)] = (1));

return statearr_22904;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1 = (function (state_22893){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_22893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e22905){if((e22905 instanceof Object)){
var ex__22352__auto__ = e22905;
var statearr_22906_23041 = state_22893;
(statearr_22906_23041[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22893);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22905;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23042 = state_22893;
state_22893 = G__23042;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = function(state_22893){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1.call(this,state_22893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__;
})()
;})(__23022,switch__22348__auto__,c__22460__auto___23034,G__22853_23023,n__21173__auto___23021,jobs,results,process,async))
})();
var state__22462__auto__ = (function (){var statearr_22907 = f__22461__auto__.call(null);
(statearr_22907[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___23034);

return statearr_22907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(__23022,c__22460__auto___23034,G__22853_23023,n__21173__auto___23021,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__23043 = (__23022 + (1));
__23022 = G__23043;
continue;
} else {
}
break;
}

var c__22460__auto___23044 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___23044,jobs,results,process,async){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___23044,jobs,results,process,async){
return (function (state_22929){
var state_val_22930 = (state_22929[(1)]);
if((state_val_22930 === (1))){
var state_22929__$1 = state_22929;
var statearr_22931_23045 = state_22929__$1;
(statearr_22931_23045[(2)] = null);

(statearr_22931_23045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (2))){
var state_22929__$1 = state_22929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22929__$1,(4),from);
} else {
if((state_val_22930 === (3))){
var inst_22927 = (state_22929[(2)]);
var state_22929__$1 = state_22929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22929__$1,inst_22927);
} else {
if((state_val_22930 === (4))){
var inst_22910 = (state_22929[(7)]);
var inst_22910__$1 = (state_22929[(2)]);
var inst_22911 = (inst_22910__$1 == null);
var state_22929__$1 = (function (){var statearr_22932 = state_22929;
(statearr_22932[(7)] = inst_22910__$1);

return statearr_22932;
})();
if(cljs.core.truth_(inst_22911)){
var statearr_22933_23046 = state_22929__$1;
(statearr_22933_23046[(1)] = (5));

} else {
var statearr_22934_23047 = state_22929__$1;
(statearr_22934_23047[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (5))){
var inst_22913 = cljs.core.async.close_BANG_.call(null,jobs);
var state_22929__$1 = state_22929;
var statearr_22935_23048 = state_22929__$1;
(statearr_22935_23048[(2)] = inst_22913);

(statearr_22935_23048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (6))){
var inst_22910 = (state_22929[(7)]);
var inst_22915 = (state_22929[(8)]);
var inst_22915__$1 = cljs.core.async.chan.call(null,(1));
var inst_22916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22917 = [inst_22910,inst_22915__$1];
var inst_22918 = (new cljs.core.PersistentVector(null,2,(5),inst_22916,inst_22917,null));
var state_22929__$1 = (function (){var statearr_22936 = state_22929;
(statearr_22936[(8)] = inst_22915__$1);

return statearr_22936;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22929__$1,(8),jobs,inst_22918);
} else {
if((state_val_22930 === (7))){
var inst_22925 = (state_22929[(2)]);
var state_22929__$1 = state_22929;
var statearr_22937_23049 = state_22929__$1;
(statearr_22937_23049[(2)] = inst_22925);

(statearr_22937_23049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (8))){
var inst_22915 = (state_22929[(8)]);
var inst_22920 = (state_22929[(2)]);
var state_22929__$1 = (function (){var statearr_22938 = state_22929;
(statearr_22938[(9)] = inst_22920);

return statearr_22938;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22929__$1,(9),results,inst_22915);
} else {
if((state_val_22930 === (9))){
var inst_22922 = (state_22929[(2)]);
var state_22929__$1 = (function (){var statearr_22939 = state_22929;
(statearr_22939[(10)] = inst_22922);

return statearr_22939;
})();
var statearr_22940_23050 = state_22929__$1;
(statearr_22940_23050[(2)] = null);

(statearr_22940_23050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___23044,jobs,results,process,async))
;
return ((function (switch__22348__auto__,c__22460__auto___23044,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0 = (function (){
var statearr_22944 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22944[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__);

(statearr_22944[(1)] = (1));

return statearr_22944;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1 = (function (state_22929){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_22929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e22945){if((e22945 instanceof Object)){
var ex__22352__auto__ = e22945;
var statearr_22946_23051 = state_22929;
(statearr_22946_23051[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22929);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22945;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23052 = state_22929;
state_22929 = G__23052;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = function(state_22929){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1.call(this,state_22929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___23044,jobs,results,process,async))
})();
var state__22462__auto__ = (function (){var statearr_22947 = f__22461__auto__.call(null);
(statearr_22947[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___23044);

return statearr_22947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___23044,jobs,results,process,async))
);


var c__22460__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto__,jobs,results,process,async){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto__,jobs,results,process,async){
return (function (state_22985){
var state_val_22986 = (state_22985[(1)]);
if((state_val_22986 === (7))){
var inst_22981 = (state_22985[(2)]);
var state_22985__$1 = state_22985;
var statearr_22987_23053 = state_22985__$1;
(statearr_22987_23053[(2)] = inst_22981);

(statearr_22987_23053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (20))){
var state_22985__$1 = state_22985;
var statearr_22988_23054 = state_22985__$1;
(statearr_22988_23054[(2)] = null);

(statearr_22988_23054[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (1))){
var state_22985__$1 = state_22985;
var statearr_22989_23055 = state_22985__$1;
(statearr_22989_23055[(2)] = null);

(statearr_22989_23055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (4))){
var inst_22950 = (state_22985[(7)]);
var inst_22950__$1 = (state_22985[(2)]);
var inst_22951 = (inst_22950__$1 == null);
var state_22985__$1 = (function (){var statearr_22990 = state_22985;
(statearr_22990[(7)] = inst_22950__$1);

return statearr_22990;
})();
if(cljs.core.truth_(inst_22951)){
var statearr_22991_23056 = state_22985__$1;
(statearr_22991_23056[(1)] = (5));

} else {
var statearr_22992_23057 = state_22985__$1;
(statearr_22992_23057[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (15))){
var inst_22963 = (state_22985[(8)]);
var state_22985__$1 = state_22985;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22985__$1,(18),to,inst_22963);
} else {
if((state_val_22986 === (21))){
var inst_22976 = (state_22985[(2)]);
var state_22985__$1 = state_22985;
var statearr_22993_23058 = state_22985__$1;
(statearr_22993_23058[(2)] = inst_22976);

(statearr_22993_23058[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (13))){
var inst_22978 = (state_22985[(2)]);
var state_22985__$1 = (function (){var statearr_22994 = state_22985;
(statearr_22994[(9)] = inst_22978);

return statearr_22994;
})();
var statearr_22995_23059 = state_22985__$1;
(statearr_22995_23059[(2)] = null);

(statearr_22995_23059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (6))){
var inst_22950 = (state_22985[(7)]);
var state_22985__$1 = state_22985;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22985__$1,(11),inst_22950);
} else {
if((state_val_22986 === (17))){
var inst_22971 = (state_22985[(2)]);
var state_22985__$1 = state_22985;
if(cljs.core.truth_(inst_22971)){
var statearr_22996_23060 = state_22985__$1;
(statearr_22996_23060[(1)] = (19));

} else {
var statearr_22997_23061 = state_22985__$1;
(statearr_22997_23061[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (3))){
var inst_22983 = (state_22985[(2)]);
var state_22985__$1 = state_22985;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22985__$1,inst_22983);
} else {
if((state_val_22986 === (12))){
var inst_22960 = (state_22985[(10)]);
var state_22985__$1 = state_22985;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22985__$1,(14),inst_22960);
} else {
if((state_val_22986 === (2))){
var state_22985__$1 = state_22985;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22985__$1,(4),results);
} else {
if((state_val_22986 === (19))){
var state_22985__$1 = state_22985;
var statearr_22998_23062 = state_22985__$1;
(statearr_22998_23062[(2)] = null);

(statearr_22998_23062[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (11))){
var inst_22960 = (state_22985[(2)]);
var state_22985__$1 = (function (){var statearr_22999 = state_22985;
(statearr_22999[(10)] = inst_22960);

return statearr_22999;
})();
var statearr_23000_23063 = state_22985__$1;
(statearr_23000_23063[(2)] = null);

(statearr_23000_23063[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (9))){
var state_22985__$1 = state_22985;
var statearr_23001_23064 = state_22985__$1;
(statearr_23001_23064[(2)] = null);

(statearr_23001_23064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (5))){
var state_22985__$1 = state_22985;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23002_23065 = state_22985__$1;
(statearr_23002_23065[(1)] = (8));

} else {
var statearr_23003_23066 = state_22985__$1;
(statearr_23003_23066[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (14))){
var inst_22965 = (state_22985[(11)]);
var inst_22963 = (state_22985[(8)]);
var inst_22963__$1 = (state_22985[(2)]);
var inst_22964 = (inst_22963__$1 == null);
var inst_22965__$1 = cljs.core.not.call(null,inst_22964);
var state_22985__$1 = (function (){var statearr_23004 = state_22985;
(statearr_23004[(11)] = inst_22965__$1);

(statearr_23004[(8)] = inst_22963__$1);

return statearr_23004;
})();
if(inst_22965__$1){
var statearr_23005_23067 = state_22985__$1;
(statearr_23005_23067[(1)] = (15));

} else {
var statearr_23006_23068 = state_22985__$1;
(statearr_23006_23068[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (16))){
var inst_22965 = (state_22985[(11)]);
var state_22985__$1 = state_22985;
var statearr_23007_23069 = state_22985__$1;
(statearr_23007_23069[(2)] = inst_22965);

(statearr_23007_23069[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (10))){
var inst_22957 = (state_22985[(2)]);
var state_22985__$1 = state_22985;
var statearr_23008_23070 = state_22985__$1;
(statearr_23008_23070[(2)] = inst_22957);

(statearr_23008_23070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (18))){
var inst_22968 = (state_22985[(2)]);
var state_22985__$1 = state_22985;
var statearr_23009_23071 = state_22985__$1;
(statearr_23009_23071[(2)] = inst_22968);

(statearr_23009_23071[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22986 === (8))){
var inst_22954 = cljs.core.async.close_BANG_.call(null,to);
var state_22985__$1 = state_22985;
var statearr_23010_23072 = state_22985__$1;
(statearr_23010_23072[(2)] = inst_22954);

(statearr_23010_23072[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto__,jobs,results,process,async))
;
return ((function (switch__22348__auto__,c__22460__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0 = (function (){
var statearr_23014 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23014[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__);

(statearr_23014[(1)] = (1));

return statearr_23014;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1 = (function (state_22985){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_22985);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e23015){if((e23015 instanceof Object)){
var ex__22352__auto__ = e23015;
var statearr_23016_23073 = state_22985;
(statearr_23016_23073[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22985);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23074 = state_22985;
state_22985 = G__23074;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__ = function(state_22985){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1.call(this,state_22985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22349__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto__,jobs,results,process,async))
})();
var state__22462__auto__ = (function (){var statearr_23017 = f__22461__auto__.call(null);
(statearr_23017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto__);

return statearr_23017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto__,jobs,results,process,async))
);

return c__22460__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args23075 = [];
var len__21363__auto___23078 = arguments.length;
var i__21364__auto___23079 = (0);
while(true){
if((i__21364__auto___23079 < len__21363__auto___23078)){
args23075.push((arguments[i__21364__auto___23079]));

var G__23080 = (i__21364__auto___23079 + (1));
i__21364__auto___23079 = G__23080;
continue;
} else {
}
break;
}

var G__23077 = args23075.length;
switch (G__23077) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23075.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args23082 = [];
var len__21363__auto___23085 = arguments.length;
var i__21364__auto___23086 = (0);
while(true){
if((i__21364__auto___23086 < len__21363__auto___23085)){
args23082.push((arguments[i__21364__auto___23086]));

var G__23087 = (i__21364__auto___23086 + (1));
i__21364__auto___23086 = G__23087;
continue;
} else {
}
break;
}

var G__23084 = args23082.length;
switch (G__23084) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23082.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args23089 = [];
var len__21363__auto___23142 = arguments.length;
var i__21364__auto___23143 = (0);
while(true){
if((i__21364__auto___23143 < len__21363__auto___23142)){
args23089.push((arguments[i__21364__auto___23143]));

var G__23144 = (i__21364__auto___23143 + (1));
i__21364__auto___23143 = G__23144;
continue;
} else {
}
break;
}

var G__23091 = args23089.length;
switch (G__23091) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23089.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__22460__auto___23146 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___23146,tc,fc){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___23146,tc,fc){
return (function (state_23117){
var state_val_23118 = (state_23117[(1)]);
if((state_val_23118 === (7))){
var inst_23113 = (state_23117[(2)]);
var state_23117__$1 = state_23117;
var statearr_23119_23147 = state_23117__$1;
(statearr_23119_23147[(2)] = inst_23113);

(statearr_23119_23147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (1))){
var state_23117__$1 = state_23117;
var statearr_23120_23148 = state_23117__$1;
(statearr_23120_23148[(2)] = null);

(statearr_23120_23148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (4))){
var inst_23094 = (state_23117[(7)]);
var inst_23094__$1 = (state_23117[(2)]);
var inst_23095 = (inst_23094__$1 == null);
var state_23117__$1 = (function (){var statearr_23121 = state_23117;
(statearr_23121[(7)] = inst_23094__$1);

return statearr_23121;
})();
if(cljs.core.truth_(inst_23095)){
var statearr_23122_23149 = state_23117__$1;
(statearr_23122_23149[(1)] = (5));

} else {
var statearr_23123_23150 = state_23117__$1;
(statearr_23123_23150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (13))){
var state_23117__$1 = state_23117;
var statearr_23124_23151 = state_23117__$1;
(statearr_23124_23151[(2)] = null);

(statearr_23124_23151[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (6))){
var inst_23094 = (state_23117[(7)]);
var inst_23100 = p.call(null,inst_23094);
var state_23117__$1 = state_23117;
if(cljs.core.truth_(inst_23100)){
var statearr_23125_23152 = state_23117__$1;
(statearr_23125_23152[(1)] = (9));

} else {
var statearr_23126_23153 = state_23117__$1;
(statearr_23126_23153[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (3))){
var inst_23115 = (state_23117[(2)]);
var state_23117__$1 = state_23117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23117__$1,inst_23115);
} else {
if((state_val_23118 === (12))){
var state_23117__$1 = state_23117;
var statearr_23127_23154 = state_23117__$1;
(statearr_23127_23154[(2)] = null);

(statearr_23127_23154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (2))){
var state_23117__$1 = state_23117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23117__$1,(4),ch);
} else {
if((state_val_23118 === (11))){
var inst_23094 = (state_23117[(7)]);
var inst_23104 = (state_23117[(2)]);
var state_23117__$1 = state_23117;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23117__$1,(8),inst_23104,inst_23094);
} else {
if((state_val_23118 === (9))){
var state_23117__$1 = state_23117;
var statearr_23128_23155 = state_23117__$1;
(statearr_23128_23155[(2)] = tc);

(statearr_23128_23155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (5))){
var inst_23097 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23098 = cljs.core.async.close_BANG_.call(null,fc);
var state_23117__$1 = (function (){var statearr_23129 = state_23117;
(statearr_23129[(8)] = inst_23097);

return statearr_23129;
})();
var statearr_23130_23156 = state_23117__$1;
(statearr_23130_23156[(2)] = inst_23098);

(statearr_23130_23156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (14))){
var inst_23111 = (state_23117[(2)]);
var state_23117__$1 = state_23117;
var statearr_23131_23157 = state_23117__$1;
(statearr_23131_23157[(2)] = inst_23111);

(statearr_23131_23157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (10))){
var state_23117__$1 = state_23117;
var statearr_23132_23158 = state_23117__$1;
(statearr_23132_23158[(2)] = fc);

(statearr_23132_23158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23118 === (8))){
var inst_23106 = (state_23117[(2)]);
var state_23117__$1 = state_23117;
if(cljs.core.truth_(inst_23106)){
var statearr_23133_23159 = state_23117__$1;
(statearr_23133_23159[(1)] = (12));

} else {
var statearr_23134_23160 = state_23117__$1;
(statearr_23134_23160[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___23146,tc,fc))
;
return ((function (switch__22348__auto__,c__22460__auto___23146,tc,fc){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_23138 = [null,null,null,null,null,null,null,null,null];
(statearr_23138[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_23138[(1)] = (1));

return statearr_23138;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_23117){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_23117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e23139){if((e23139 instanceof Object)){
var ex__22352__auto__ = e23139;
var statearr_23140_23161 = state_23117;
(statearr_23140_23161[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23117);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23139;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23162 = state_23117;
state_23117 = G__23162;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_23117){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_23117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___23146,tc,fc))
})();
var state__22462__auto__ = (function (){var statearr_23141 = f__22461__auto__.call(null);
(statearr_23141[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___23146);

return statearr_23141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___23146,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__22460__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto__){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto__){
return (function (state_23226){
var state_val_23227 = (state_23226[(1)]);
if((state_val_23227 === (7))){
var inst_23222 = (state_23226[(2)]);
var state_23226__$1 = state_23226;
var statearr_23228_23249 = state_23226__$1;
(statearr_23228_23249[(2)] = inst_23222);

(statearr_23228_23249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (1))){
var inst_23206 = init;
var state_23226__$1 = (function (){var statearr_23229 = state_23226;
(statearr_23229[(7)] = inst_23206);

return statearr_23229;
})();
var statearr_23230_23250 = state_23226__$1;
(statearr_23230_23250[(2)] = null);

(statearr_23230_23250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (4))){
var inst_23209 = (state_23226[(8)]);
var inst_23209__$1 = (state_23226[(2)]);
var inst_23210 = (inst_23209__$1 == null);
var state_23226__$1 = (function (){var statearr_23231 = state_23226;
(statearr_23231[(8)] = inst_23209__$1);

return statearr_23231;
})();
if(cljs.core.truth_(inst_23210)){
var statearr_23232_23251 = state_23226__$1;
(statearr_23232_23251[(1)] = (5));

} else {
var statearr_23233_23252 = state_23226__$1;
(statearr_23233_23252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (6))){
var inst_23213 = (state_23226[(9)]);
var inst_23206 = (state_23226[(7)]);
var inst_23209 = (state_23226[(8)]);
var inst_23213__$1 = f.call(null,inst_23206,inst_23209);
var inst_23214 = cljs.core.reduced_QMARK_.call(null,inst_23213__$1);
var state_23226__$1 = (function (){var statearr_23234 = state_23226;
(statearr_23234[(9)] = inst_23213__$1);

return statearr_23234;
})();
if(inst_23214){
var statearr_23235_23253 = state_23226__$1;
(statearr_23235_23253[(1)] = (8));

} else {
var statearr_23236_23254 = state_23226__$1;
(statearr_23236_23254[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (3))){
var inst_23224 = (state_23226[(2)]);
var state_23226__$1 = state_23226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23226__$1,inst_23224);
} else {
if((state_val_23227 === (2))){
var state_23226__$1 = state_23226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23226__$1,(4),ch);
} else {
if((state_val_23227 === (9))){
var inst_23213 = (state_23226[(9)]);
var inst_23206 = inst_23213;
var state_23226__$1 = (function (){var statearr_23237 = state_23226;
(statearr_23237[(7)] = inst_23206);

return statearr_23237;
})();
var statearr_23238_23255 = state_23226__$1;
(statearr_23238_23255[(2)] = null);

(statearr_23238_23255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (5))){
var inst_23206 = (state_23226[(7)]);
var state_23226__$1 = state_23226;
var statearr_23239_23256 = state_23226__$1;
(statearr_23239_23256[(2)] = inst_23206);

(statearr_23239_23256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (10))){
var inst_23220 = (state_23226[(2)]);
var state_23226__$1 = state_23226;
var statearr_23240_23257 = state_23226__$1;
(statearr_23240_23257[(2)] = inst_23220);

(statearr_23240_23257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23227 === (8))){
var inst_23213 = (state_23226[(9)]);
var inst_23216 = cljs.core.deref.call(null,inst_23213);
var state_23226__$1 = state_23226;
var statearr_23241_23258 = state_23226__$1;
(statearr_23241_23258[(2)] = inst_23216);

(statearr_23241_23258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto__))
;
return ((function (switch__22348__auto__,c__22460__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__22349__auto__ = null;
var cljs$core$async$reduce_$_state_machine__22349__auto____0 = (function (){
var statearr_23245 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23245[(0)] = cljs$core$async$reduce_$_state_machine__22349__auto__);

(statearr_23245[(1)] = (1));

return statearr_23245;
});
var cljs$core$async$reduce_$_state_machine__22349__auto____1 = (function (state_23226){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_23226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e23246){if((e23246 instanceof Object)){
var ex__22352__auto__ = e23246;
var statearr_23247_23259 = state_23226;
(statearr_23247_23259[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23226);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23260 = state_23226;
state_23226 = G__23260;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__22349__auto__ = function(state_23226){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__22349__auto____1.call(this,state_23226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__22349__auto____0;
cljs$core$async$reduce_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__22349__auto____1;
return cljs$core$async$reduce_$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto__))
})();
var state__22462__auto__ = (function (){var statearr_23248 = f__22461__auto__.call(null);
(statearr_23248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto__);

return statearr_23248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto__))
);

return c__22460__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args23261 = [];
var len__21363__auto___23313 = arguments.length;
var i__21364__auto___23314 = (0);
while(true){
if((i__21364__auto___23314 < len__21363__auto___23313)){
args23261.push((arguments[i__21364__auto___23314]));

var G__23315 = (i__21364__auto___23314 + (1));
i__21364__auto___23314 = G__23315;
continue;
} else {
}
break;
}

var G__23263 = args23261.length;
switch (G__23263) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23261.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__22460__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto__){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto__){
return (function (state_23288){
var state_val_23289 = (state_23288[(1)]);
if((state_val_23289 === (7))){
var inst_23270 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
var statearr_23290_23317 = state_23288__$1;
(statearr_23290_23317[(2)] = inst_23270);

(statearr_23290_23317[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (1))){
var inst_23264 = cljs.core.seq.call(null,coll);
var inst_23265 = inst_23264;
var state_23288__$1 = (function (){var statearr_23291 = state_23288;
(statearr_23291[(7)] = inst_23265);

return statearr_23291;
})();
var statearr_23292_23318 = state_23288__$1;
(statearr_23292_23318[(2)] = null);

(statearr_23292_23318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (4))){
var inst_23265 = (state_23288[(7)]);
var inst_23268 = cljs.core.first.call(null,inst_23265);
var state_23288__$1 = state_23288;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23288__$1,(7),ch,inst_23268);
} else {
if((state_val_23289 === (13))){
var inst_23282 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
var statearr_23293_23319 = state_23288__$1;
(statearr_23293_23319[(2)] = inst_23282);

(statearr_23293_23319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (6))){
var inst_23273 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
if(cljs.core.truth_(inst_23273)){
var statearr_23294_23320 = state_23288__$1;
(statearr_23294_23320[(1)] = (8));

} else {
var statearr_23295_23321 = state_23288__$1;
(statearr_23295_23321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (3))){
var inst_23286 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23288__$1,inst_23286);
} else {
if((state_val_23289 === (12))){
var state_23288__$1 = state_23288;
var statearr_23296_23322 = state_23288__$1;
(statearr_23296_23322[(2)] = null);

(statearr_23296_23322[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (2))){
var inst_23265 = (state_23288[(7)]);
var state_23288__$1 = state_23288;
if(cljs.core.truth_(inst_23265)){
var statearr_23297_23323 = state_23288__$1;
(statearr_23297_23323[(1)] = (4));

} else {
var statearr_23298_23324 = state_23288__$1;
(statearr_23298_23324[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (11))){
var inst_23279 = cljs.core.async.close_BANG_.call(null,ch);
var state_23288__$1 = state_23288;
var statearr_23299_23325 = state_23288__$1;
(statearr_23299_23325[(2)] = inst_23279);

(statearr_23299_23325[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (9))){
var state_23288__$1 = state_23288;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23300_23326 = state_23288__$1;
(statearr_23300_23326[(1)] = (11));

} else {
var statearr_23301_23327 = state_23288__$1;
(statearr_23301_23327[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (5))){
var inst_23265 = (state_23288[(7)]);
var state_23288__$1 = state_23288;
var statearr_23302_23328 = state_23288__$1;
(statearr_23302_23328[(2)] = inst_23265);

(statearr_23302_23328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (10))){
var inst_23284 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
var statearr_23303_23329 = state_23288__$1;
(statearr_23303_23329[(2)] = inst_23284);

(statearr_23303_23329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (8))){
var inst_23265 = (state_23288[(7)]);
var inst_23275 = cljs.core.next.call(null,inst_23265);
var inst_23265__$1 = inst_23275;
var state_23288__$1 = (function (){var statearr_23304 = state_23288;
(statearr_23304[(7)] = inst_23265__$1);

return statearr_23304;
})();
var statearr_23305_23330 = state_23288__$1;
(statearr_23305_23330[(2)] = null);

(statearr_23305_23330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto__))
;
return ((function (switch__22348__auto__,c__22460__auto__){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_23309 = [null,null,null,null,null,null,null,null];
(statearr_23309[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_23309[(1)] = (1));

return statearr_23309;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_23288){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_23288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e23310){if((e23310 instanceof Object)){
var ex__22352__auto__ = e23310;
var statearr_23311_23331 = state_23288;
(statearr_23311_23331[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23288);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23332 = state_23288;
state_23288 = G__23332;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_23288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_23288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto__))
})();
var state__22462__auto__ = (function (){var statearr_23312 = f__22461__auto__.call(null);
(statearr_23312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto__);

return statearr_23312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto__))
);

return c__22460__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__20918__auto__ = (((_ == null))?null:_);
var m__20919__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,_);
} else {
var m__20919__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__20919__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m);
} else {
var m__20919__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async23558 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23558 = (function (ch,cs,meta23559){
this.ch = ch;
this.cs = cs;
this.meta23559 = meta23559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_23560,meta23559__$1){
var self__ = this;
var _23560__$1 = this;
return (new cljs.core.async.t_cljs$core$async23558(self__.ch,self__.cs,meta23559__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_23560){
var self__ = this;
var _23560__$1 = this;
return self__.meta23559;
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta23559","meta23559",984879125,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async23558.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23558.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23558";

cljs.core.async.t_cljs$core$async23558.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async23558");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async23558 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async23558(ch__$1,cs__$1,meta23559){
return (new cljs.core.async.t_cljs$core$async23558(ch__$1,cs__$1,meta23559));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async23558(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__22460__auto___23783 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___23783,cs,m,dchan,dctr,done){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___23783,cs,m,dchan,dctr,done){
return (function (state_23695){
var state_val_23696 = (state_23695[(1)]);
if((state_val_23696 === (7))){
var inst_23691 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23697_23784 = state_23695__$1;
(statearr_23697_23784[(2)] = inst_23691);

(statearr_23697_23784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (20))){
var inst_23594 = (state_23695[(7)]);
var inst_23606 = cljs.core.first.call(null,inst_23594);
var inst_23607 = cljs.core.nth.call(null,inst_23606,(0),null);
var inst_23608 = cljs.core.nth.call(null,inst_23606,(1),null);
var state_23695__$1 = (function (){var statearr_23698 = state_23695;
(statearr_23698[(8)] = inst_23607);

return statearr_23698;
})();
if(cljs.core.truth_(inst_23608)){
var statearr_23699_23785 = state_23695__$1;
(statearr_23699_23785[(1)] = (22));

} else {
var statearr_23700_23786 = state_23695__$1;
(statearr_23700_23786[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (27))){
var inst_23638 = (state_23695[(9)]);
var inst_23563 = (state_23695[(10)]);
var inst_23643 = (state_23695[(11)]);
var inst_23636 = (state_23695[(12)]);
var inst_23643__$1 = cljs.core._nth.call(null,inst_23636,inst_23638);
var inst_23644 = cljs.core.async.put_BANG_.call(null,inst_23643__$1,inst_23563,done);
var state_23695__$1 = (function (){var statearr_23701 = state_23695;
(statearr_23701[(11)] = inst_23643__$1);

return statearr_23701;
})();
if(cljs.core.truth_(inst_23644)){
var statearr_23702_23787 = state_23695__$1;
(statearr_23702_23787[(1)] = (30));

} else {
var statearr_23703_23788 = state_23695__$1;
(statearr_23703_23788[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (1))){
var state_23695__$1 = state_23695;
var statearr_23704_23789 = state_23695__$1;
(statearr_23704_23789[(2)] = null);

(statearr_23704_23789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (24))){
var inst_23594 = (state_23695[(7)]);
var inst_23613 = (state_23695[(2)]);
var inst_23614 = cljs.core.next.call(null,inst_23594);
var inst_23572 = inst_23614;
var inst_23573 = null;
var inst_23574 = (0);
var inst_23575 = (0);
var state_23695__$1 = (function (){var statearr_23705 = state_23695;
(statearr_23705[(13)] = inst_23613);

(statearr_23705[(14)] = inst_23573);

(statearr_23705[(15)] = inst_23574);

(statearr_23705[(16)] = inst_23575);

(statearr_23705[(17)] = inst_23572);

return statearr_23705;
})();
var statearr_23706_23790 = state_23695__$1;
(statearr_23706_23790[(2)] = null);

(statearr_23706_23790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (39))){
var state_23695__$1 = state_23695;
var statearr_23710_23791 = state_23695__$1;
(statearr_23710_23791[(2)] = null);

(statearr_23710_23791[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (4))){
var inst_23563 = (state_23695[(10)]);
var inst_23563__$1 = (state_23695[(2)]);
var inst_23564 = (inst_23563__$1 == null);
var state_23695__$1 = (function (){var statearr_23711 = state_23695;
(statearr_23711[(10)] = inst_23563__$1);

return statearr_23711;
})();
if(cljs.core.truth_(inst_23564)){
var statearr_23712_23792 = state_23695__$1;
(statearr_23712_23792[(1)] = (5));

} else {
var statearr_23713_23793 = state_23695__$1;
(statearr_23713_23793[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (15))){
var inst_23573 = (state_23695[(14)]);
var inst_23574 = (state_23695[(15)]);
var inst_23575 = (state_23695[(16)]);
var inst_23572 = (state_23695[(17)]);
var inst_23590 = (state_23695[(2)]);
var inst_23591 = (inst_23575 + (1));
var tmp23707 = inst_23573;
var tmp23708 = inst_23574;
var tmp23709 = inst_23572;
var inst_23572__$1 = tmp23709;
var inst_23573__$1 = tmp23707;
var inst_23574__$1 = tmp23708;
var inst_23575__$1 = inst_23591;
var state_23695__$1 = (function (){var statearr_23714 = state_23695;
(statearr_23714[(18)] = inst_23590);

(statearr_23714[(14)] = inst_23573__$1);

(statearr_23714[(15)] = inst_23574__$1);

(statearr_23714[(16)] = inst_23575__$1);

(statearr_23714[(17)] = inst_23572__$1);

return statearr_23714;
})();
var statearr_23715_23794 = state_23695__$1;
(statearr_23715_23794[(2)] = null);

(statearr_23715_23794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (21))){
var inst_23617 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23719_23795 = state_23695__$1;
(statearr_23719_23795[(2)] = inst_23617);

(statearr_23719_23795[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (31))){
var inst_23643 = (state_23695[(11)]);
var inst_23647 = done.call(null,null);
var inst_23648 = cljs.core.async.untap_STAR_.call(null,m,inst_23643);
var state_23695__$1 = (function (){var statearr_23720 = state_23695;
(statearr_23720[(19)] = inst_23647);

return statearr_23720;
})();
var statearr_23721_23796 = state_23695__$1;
(statearr_23721_23796[(2)] = inst_23648);

(statearr_23721_23796[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (32))){
var inst_23638 = (state_23695[(9)]);
var inst_23637 = (state_23695[(20)]);
var inst_23636 = (state_23695[(12)]);
var inst_23635 = (state_23695[(21)]);
var inst_23650 = (state_23695[(2)]);
var inst_23651 = (inst_23638 + (1));
var tmp23716 = inst_23637;
var tmp23717 = inst_23636;
var tmp23718 = inst_23635;
var inst_23635__$1 = tmp23718;
var inst_23636__$1 = tmp23717;
var inst_23637__$1 = tmp23716;
var inst_23638__$1 = inst_23651;
var state_23695__$1 = (function (){var statearr_23722 = state_23695;
(statearr_23722[(9)] = inst_23638__$1);

(statearr_23722[(20)] = inst_23637__$1);

(statearr_23722[(22)] = inst_23650);

(statearr_23722[(12)] = inst_23636__$1);

(statearr_23722[(21)] = inst_23635__$1);

return statearr_23722;
})();
var statearr_23723_23797 = state_23695__$1;
(statearr_23723_23797[(2)] = null);

(statearr_23723_23797[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (40))){
var inst_23663 = (state_23695[(23)]);
var inst_23667 = done.call(null,null);
var inst_23668 = cljs.core.async.untap_STAR_.call(null,m,inst_23663);
var state_23695__$1 = (function (){var statearr_23724 = state_23695;
(statearr_23724[(24)] = inst_23667);

return statearr_23724;
})();
var statearr_23725_23798 = state_23695__$1;
(statearr_23725_23798[(2)] = inst_23668);

(statearr_23725_23798[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (33))){
var inst_23654 = (state_23695[(25)]);
var inst_23656 = cljs.core.chunked_seq_QMARK_.call(null,inst_23654);
var state_23695__$1 = state_23695;
if(inst_23656){
var statearr_23726_23799 = state_23695__$1;
(statearr_23726_23799[(1)] = (36));

} else {
var statearr_23727_23800 = state_23695__$1;
(statearr_23727_23800[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (13))){
var inst_23584 = (state_23695[(26)]);
var inst_23587 = cljs.core.async.close_BANG_.call(null,inst_23584);
var state_23695__$1 = state_23695;
var statearr_23728_23801 = state_23695__$1;
(statearr_23728_23801[(2)] = inst_23587);

(statearr_23728_23801[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (22))){
var inst_23607 = (state_23695[(8)]);
var inst_23610 = cljs.core.async.close_BANG_.call(null,inst_23607);
var state_23695__$1 = state_23695;
var statearr_23729_23802 = state_23695__$1;
(statearr_23729_23802[(2)] = inst_23610);

(statearr_23729_23802[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (36))){
var inst_23654 = (state_23695[(25)]);
var inst_23658 = cljs.core.chunk_first.call(null,inst_23654);
var inst_23659 = cljs.core.chunk_rest.call(null,inst_23654);
var inst_23660 = cljs.core.count.call(null,inst_23658);
var inst_23635 = inst_23659;
var inst_23636 = inst_23658;
var inst_23637 = inst_23660;
var inst_23638 = (0);
var state_23695__$1 = (function (){var statearr_23730 = state_23695;
(statearr_23730[(9)] = inst_23638);

(statearr_23730[(20)] = inst_23637);

(statearr_23730[(12)] = inst_23636);

(statearr_23730[(21)] = inst_23635);

return statearr_23730;
})();
var statearr_23731_23803 = state_23695__$1;
(statearr_23731_23803[(2)] = null);

(statearr_23731_23803[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (41))){
var inst_23654 = (state_23695[(25)]);
var inst_23670 = (state_23695[(2)]);
var inst_23671 = cljs.core.next.call(null,inst_23654);
var inst_23635 = inst_23671;
var inst_23636 = null;
var inst_23637 = (0);
var inst_23638 = (0);
var state_23695__$1 = (function (){var statearr_23732 = state_23695;
(statearr_23732[(9)] = inst_23638);

(statearr_23732[(20)] = inst_23637);

(statearr_23732[(27)] = inst_23670);

(statearr_23732[(12)] = inst_23636);

(statearr_23732[(21)] = inst_23635);

return statearr_23732;
})();
var statearr_23733_23804 = state_23695__$1;
(statearr_23733_23804[(2)] = null);

(statearr_23733_23804[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (43))){
var state_23695__$1 = state_23695;
var statearr_23734_23805 = state_23695__$1;
(statearr_23734_23805[(2)] = null);

(statearr_23734_23805[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (29))){
var inst_23679 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23735_23806 = state_23695__$1;
(statearr_23735_23806[(2)] = inst_23679);

(statearr_23735_23806[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (44))){
var inst_23688 = (state_23695[(2)]);
var state_23695__$1 = (function (){var statearr_23736 = state_23695;
(statearr_23736[(28)] = inst_23688);

return statearr_23736;
})();
var statearr_23737_23807 = state_23695__$1;
(statearr_23737_23807[(2)] = null);

(statearr_23737_23807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (6))){
var inst_23627 = (state_23695[(29)]);
var inst_23626 = cljs.core.deref.call(null,cs);
var inst_23627__$1 = cljs.core.keys.call(null,inst_23626);
var inst_23628 = cljs.core.count.call(null,inst_23627__$1);
var inst_23629 = cljs.core.reset_BANG_.call(null,dctr,inst_23628);
var inst_23634 = cljs.core.seq.call(null,inst_23627__$1);
var inst_23635 = inst_23634;
var inst_23636 = null;
var inst_23637 = (0);
var inst_23638 = (0);
var state_23695__$1 = (function (){var statearr_23738 = state_23695;
(statearr_23738[(9)] = inst_23638);

(statearr_23738[(20)] = inst_23637);

(statearr_23738[(29)] = inst_23627__$1);

(statearr_23738[(12)] = inst_23636);

(statearr_23738[(21)] = inst_23635);

(statearr_23738[(30)] = inst_23629);

return statearr_23738;
})();
var statearr_23739_23808 = state_23695__$1;
(statearr_23739_23808[(2)] = null);

(statearr_23739_23808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (28))){
var inst_23654 = (state_23695[(25)]);
var inst_23635 = (state_23695[(21)]);
var inst_23654__$1 = cljs.core.seq.call(null,inst_23635);
var state_23695__$1 = (function (){var statearr_23740 = state_23695;
(statearr_23740[(25)] = inst_23654__$1);

return statearr_23740;
})();
if(inst_23654__$1){
var statearr_23741_23809 = state_23695__$1;
(statearr_23741_23809[(1)] = (33));

} else {
var statearr_23742_23810 = state_23695__$1;
(statearr_23742_23810[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (25))){
var inst_23638 = (state_23695[(9)]);
var inst_23637 = (state_23695[(20)]);
var inst_23640 = (inst_23638 < inst_23637);
var inst_23641 = inst_23640;
var state_23695__$1 = state_23695;
if(cljs.core.truth_(inst_23641)){
var statearr_23743_23811 = state_23695__$1;
(statearr_23743_23811[(1)] = (27));

} else {
var statearr_23744_23812 = state_23695__$1;
(statearr_23744_23812[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (34))){
var state_23695__$1 = state_23695;
var statearr_23745_23813 = state_23695__$1;
(statearr_23745_23813[(2)] = null);

(statearr_23745_23813[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (17))){
var state_23695__$1 = state_23695;
var statearr_23746_23814 = state_23695__$1;
(statearr_23746_23814[(2)] = null);

(statearr_23746_23814[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (3))){
var inst_23693 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23695__$1,inst_23693);
} else {
if((state_val_23696 === (12))){
var inst_23622 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23747_23815 = state_23695__$1;
(statearr_23747_23815[(2)] = inst_23622);

(statearr_23747_23815[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (2))){
var state_23695__$1 = state_23695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23695__$1,(4),ch);
} else {
if((state_val_23696 === (23))){
var state_23695__$1 = state_23695;
var statearr_23748_23816 = state_23695__$1;
(statearr_23748_23816[(2)] = null);

(statearr_23748_23816[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (35))){
var inst_23677 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23749_23817 = state_23695__$1;
(statearr_23749_23817[(2)] = inst_23677);

(statearr_23749_23817[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (19))){
var inst_23594 = (state_23695[(7)]);
var inst_23598 = cljs.core.chunk_first.call(null,inst_23594);
var inst_23599 = cljs.core.chunk_rest.call(null,inst_23594);
var inst_23600 = cljs.core.count.call(null,inst_23598);
var inst_23572 = inst_23599;
var inst_23573 = inst_23598;
var inst_23574 = inst_23600;
var inst_23575 = (0);
var state_23695__$1 = (function (){var statearr_23750 = state_23695;
(statearr_23750[(14)] = inst_23573);

(statearr_23750[(15)] = inst_23574);

(statearr_23750[(16)] = inst_23575);

(statearr_23750[(17)] = inst_23572);

return statearr_23750;
})();
var statearr_23751_23818 = state_23695__$1;
(statearr_23751_23818[(2)] = null);

(statearr_23751_23818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (11))){
var inst_23594 = (state_23695[(7)]);
var inst_23572 = (state_23695[(17)]);
var inst_23594__$1 = cljs.core.seq.call(null,inst_23572);
var state_23695__$1 = (function (){var statearr_23752 = state_23695;
(statearr_23752[(7)] = inst_23594__$1);

return statearr_23752;
})();
if(inst_23594__$1){
var statearr_23753_23819 = state_23695__$1;
(statearr_23753_23819[(1)] = (16));

} else {
var statearr_23754_23820 = state_23695__$1;
(statearr_23754_23820[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (9))){
var inst_23624 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23755_23821 = state_23695__$1;
(statearr_23755_23821[(2)] = inst_23624);

(statearr_23755_23821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (5))){
var inst_23570 = cljs.core.deref.call(null,cs);
var inst_23571 = cljs.core.seq.call(null,inst_23570);
var inst_23572 = inst_23571;
var inst_23573 = null;
var inst_23574 = (0);
var inst_23575 = (0);
var state_23695__$1 = (function (){var statearr_23756 = state_23695;
(statearr_23756[(14)] = inst_23573);

(statearr_23756[(15)] = inst_23574);

(statearr_23756[(16)] = inst_23575);

(statearr_23756[(17)] = inst_23572);

return statearr_23756;
})();
var statearr_23757_23822 = state_23695__$1;
(statearr_23757_23822[(2)] = null);

(statearr_23757_23822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (14))){
var state_23695__$1 = state_23695;
var statearr_23758_23823 = state_23695__$1;
(statearr_23758_23823[(2)] = null);

(statearr_23758_23823[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (45))){
var inst_23685 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23759_23824 = state_23695__$1;
(statearr_23759_23824[(2)] = inst_23685);

(statearr_23759_23824[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (26))){
var inst_23627 = (state_23695[(29)]);
var inst_23681 = (state_23695[(2)]);
var inst_23682 = cljs.core.seq.call(null,inst_23627);
var state_23695__$1 = (function (){var statearr_23760 = state_23695;
(statearr_23760[(31)] = inst_23681);

return statearr_23760;
})();
if(inst_23682){
var statearr_23761_23825 = state_23695__$1;
(statearr_23761_23825[(1)] = (42));

} else {
var statearr_23762_23826 = state_23695__$1;
(statearr_23762_23826[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (16))){
var inst_23594 = (state_23695[(7)]);
var inst_23596 = cljs.core.chunked_seq_QMARK_.call(null,inst_23594);
var state_23695__$1 = state_23695;
if(inst_23596){
var statearr_23763_23827 = state_23695__$1;
(statearr_23763_23827[(1)] = (19));

} else {
var statearr_23764_23828 = state_23695__$1;
(statearr_23764_23828[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (38))){
var inst_23674 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23765_23829 = state_23695__$1;
(statearr_23765_23829[(2)] = inst_23674);

(statearr_23765_23829[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (30))){
var state_23695__$1 = state_23695;
var statearr_23766_23830 = state_23695__$1;
(statearr_23766_23830[(2)] = null);

(statearr_23766_23830[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (10))){
var inst_23573 = (state_23695[(14)]);
var inst_23575 = (state_23695[(16)]);
var inst_23583 = cljs.core._nth.call(null,inst_23573,inst_23575);
var inst_23584 = cljs.core.nth.call(null,inst_23583,(0),null);
var inst_23585 = cljs.core.nth.call(null,inst_23583,(1),null);
var state_23695__$1 = (function (){var statearr_23767 = state_23695;
(statearr_23767[(26)] = inst_23584);

return statearr_23767;
})();
if(cljs.core.truth_(inst_23585)){
var statearr_23768_23831 = state_23695__$1;
(statearr_23768_23831[(1)] = (13));

} else {
var statearr_23769_23832 = state_23695__$1;
(statearr_23769_23832[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (18))){
var inst_23620 = (state_23695[(2)]);
var state_23695__$1 = state_23695;
var statearr_23770_23833 = state_23695__$1;
(statearr_23770_23833[(2)] = inst_23620);

(statearr_23770_23833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (42))){
var state_23695__$1 = state_23695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23695__$1,(45),dchan);
} else {
if((state_val_23696 === (37))){
var inst_23563 = (state_23695[(10)]);
var inst_23663 = (state_23695[(23)]);
var inst_23654 = (state_23695[(25)]);
var inst_23663__$1 = cljs.core.first.call(null,inst_23654);
var inst_23664 = cljs.core.async.put_BANG_.call(null,inst_23663__$1,inst_23563,done);
var state_23695__$1 = (function (){var statearr_23771 = state_23695;
(statearr_23771[(23)] = inst_23663__$1);

return statearr_23771;
})();
if(cljs.core.truth_(inst_23664)){
var statearr_23772_23834 = state_23695__$1;
(statearr_23772_23834[(1)] = (39));

} else {
var statearr_23773_23835 = state_23695__$1;
(statearr_23773_23835[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23696 === (8))){
var inst_23574 = (state_23695[(15)]);
var inst_23575 = (state_23695[(16)]);
var inst_23577 = (inst_23575 < inst_23574);
var inst_23578 = inst_23577;
var state_23695__$1 = state_23695;
if(cljs.core.truth_(inst_23578)){
var statearr_23774_23836 = state_23695__$1;
(statearr_23774_23836[(1)] = (10));

} else {
var statearr_23775_23837 = state_23695__$1;
(statearr_23775_23837[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___23783,cs,m,dchan,dctr,done))
;
return ((function (switch__22348__auto__,c__22460__auto___23783,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__22349__auto__ = null;
var cljs$core$async$mult_$_state_machine__22349__auto____0 = (function (){
var statearr_23779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23779[(0)] = cljs$core$async$mult_$_state_machine__22349__auto__);

(statearr_23779[(1)] = (1));

return statearr_23779;
});
var cljs$core$async$mult_$_state_machine__22349__auto____1 = (function (state_23695){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_23695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e23780){if((e23780 instanceof Object)){
var ex__22352__auto__ = e23780;
var statearr_23781_23838 = state_23695;
(statearr_23781_23838[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23780;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23839 = state_23695;
state_23695 = G__23839;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__22349__auto__ = function(state_23695){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__22349__auto____1.call(this,state_23695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__22349__auto____0;
cljs$core$async$mult_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__22349__auto____1;
return cljs$core$async$mult_$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___23783,cs,m,dchan,dctr,done))
})();
var state__22462__auto__ = (function (){var statearr_23782 = f__22461__auto__.call(null);
(statearr_23782[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___23783);

return statearr_23782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___23783,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args23840 = [];
var len__21363__auto___23843 = arguments.length;
var i__21364__auto___23844 = (0);
while(true){
if((i__21364__auto___23844 < len__21363__auto___23843)){
args23840.push((arguments[i__21364__auto___23844]));

var G__23845 = (i__21364__auto___23844 + (1));
i__21364__auto___23844 = G__23845;
continue;
} else {
}
break;
}

var G__23842 = args23840.length;
switch (G__23842) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23840.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m);
} else {
var m__20919__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,state_map);
} else {
var m__20919__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,mode);
} else {
var m__20919__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__21370__auto__ = [];
var len__21363__auto___23857 = arguments.length;
var i__21364__auto___23858 = (0);
while(true){
if((i__21364__auto___23858 < len__21363__auto___23857)){
args__21370__auto__.push((arguments[i__21364__auto___23858]));

var G__23859 = (i__21364__auto___23858 + (1));
i__21364__auto___23858 = G__23859;
continue;
} else {
}
break;
}

var argseq__21371__auto__ = ((((3) < args__21370__auto__.length))?(new cljs.core.IndexedSeq(args__21370__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21371__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__23851){
var map__23852 = p__23851;
var map__23852__$1 = ((((!((map__23852 == null)))?((((map__23852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23852.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23852):map__23852);
var opts = map__23852__$1;
var statearr_23854_23860 = state;
(statearr_23854_23860[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__23852,map__23852__$1,opts){
return (function (val){
var statearr_23855_23861 = state;
(statearr_23855_23861[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__23852,map__23852__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_23856_23862 = state;
(statearr_23856_23862[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq23847){
var G__23848 = cljs.core.first.call(null,seq23847);
var seq23847__$1 = cljs.core.next.call(null,seq23847);
var G__23849 = cljs.core.first.call(null,seq23847__$1);
var seq23847__$2 = cljs.core.next.call(null,seq23847__$1);
var G__23850 = cljs.core.first.call(null,seq23847__$2);
var seq23847__$3 = cljs.core.next.call(null,seq23847__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23848,G__23849,G__23850,seq23847__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24030 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta24031){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta24031 = meta24031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24032,meta24031__$1){
var self__ = this;
var _24032__$1 = this;
return (new cljs.core.async.t_cljs$core$async24030(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta24031__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24032){
var self__ = this;
var _24032__$1 = this;
return self__.meta24031;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta24031","meta24031",151439468,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24030.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24030.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24030";

cljs.core.async.t_cljs$core$async24030.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24030");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async24030 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async24030(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24031){
return (new cljs.core.async.t_cljs$core$async24030(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24031));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async24030(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22460__auto___24197 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___24197,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___24197,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_24134){
var state_val_24135 = (state_24134[(1)]);
if((state_val_24135 === (7))){
var inst_24049 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
var statearr_24136_24198 = state_24134__$1;
(statearr_24136_24198[(2)] = inst_24049);

(statearr_24136_24198[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (20))){
var inst_24061 = (state_24134[(7)]);
var state_24134__$1 = state_24134;
var statearr_24137_24199 = state_24134__$1;
(statearr_24137_24199[(2)] = inst_24061);

(statearr_24137_24199[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (27))){
var state_24134__$1 = state_24134;
var statearr_24138_24200 = state_24134__$1;
(statearr_24138_24200[(2)] = null);

(statearr_24138_24200[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (1))){
var inst_24036 = (state_24134[(8)]);
var inst_24036__$1 = calc_state.call(null);
var inst_24038 = (inst_24036__$1 == null);
var inst_24039 = cljs.core.not.call(null,inst_24038);
var state_24134__$1 = (function (){var statearr_24139 = state_24134;
(statearr_24139[(8)] = inst_24036__$1);

return statearr_24139;
})();
if(inst_24039){
var statearr_24140_24201 = state_24134__$1;
(statearr_24140_24201[(1)] = (2));

} else {
var statearr_24141_24202 = state_24134__$1;
(statearr_24141_24202[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (24))){
var inst_24108 = (state_24134[(9)]);
var inst_24094 = (state_24134[(10)]);
var inst_24085 = (state_24134[(11)]);
var inst_24108__$1 = inst_24085.call(null,inst_24094);
var state_24134__$1 = (function (){var statearr_24142 = state_24134;
(statearr_24142[(9)] = inst_24108__$1);

return statearr_24142;
})();
if(cljs.core.truth_(inst_24108__$1)){
var statearr_24143_24203 = state_24134__$1;
(statearr_24143_24203[(1)] = (29));

} else {
var statearr_24144_24204 = state_24134__$1;
(statearr_24144_24204[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (4))){
var inst_24052 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24052)){
var statearr_24145_24205 = state_24134__$1;
(statearr_24145_24205[(1)] = (8));

} else {
var statearr_24146_24206 = state_24134__$1;
(statearr_24146_24206[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (15))){
var inst_24079 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24079)){
var statearr_24147_24207 = state_24134__$1;
(statearr_24147_24207[(1)] = (19));

} else {
var statearr_24148_24208 = state_24134__$1;
(statearr_24148_24208[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (21))){
var inst_24084 = (state_24134[(12)]);
var inst_24084__$1 = (state_24134[(2)]);
var inst_24085 = cljs.core.get.call(null,inst_24084__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24086 = cljs.core.get.call(null,inst_24084__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24087 = cljs.core.get.call(null,inst_24084__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24134__$1 = (function (){var statearr_24149 = state_24134;
(statearr_24149[(12)] = inst_24084__$1);

(statearr_24149[(13)] = inst_24086);

(statearr_24149[(11)] = inst_24085);

return statearr_24149;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24134__$1,(22),inst_24087);
} else {
if((state_val_24135 === (31))){
var inst_24116 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24116)){
var statearr_24150_24209 = state_24134__$1;
(statearr_24150_24209[(1)] = (32));

} else {
var statearr_24151_24210 = state_24134__$1;
(statearr_24151_24210[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (32))){
var inst_24093 = (state_24134[(14)]);
var state_24134__$1 = state_24134;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24134__$1,(35),out,inst_24093);
} else {
if((state_val_24135 === (33))){
var inst_24084 = (state_24134[(12)]);
var inst_24061 = inst_24084;
var state_24134__$1 = (function (){var statearr_24152 = state_24134;
(statearr_24152[(7)] = inst_24061);

return statearr_24152;
})();
var statearr_24153_24211 = state_24134__$1;
(statearr_24153_24211[(2)] = null);

(statearr_24153_24211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (13))){
var inst_24061 = (state_24134[(7)]);
var inst_24068 = inst_24061.cljs$lang$protocol_mask$partition0$;
var inst_24069 = (inst_24068 & (64));
var inst_24070 = inst_24061.cljs$core$ISeq$;
var inst_24071 = (cljs.core.PROTOCOL_SENTINEL === inst_24070);
var inst_24072 = (inst_24069) || (inst_24071);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24072)){
var statearr_24154_24212 = state_24134__$1;
(statearr_24154_24212[(1)] = (16));

} else {
var statearr_24155_24213 = state_24134__$1;
(statearr_24155_24213[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (22))){
var inst_24093 = (state_24134[(14)]);
var inst_24094 = (state_24134[(10)]);
var inst_24092 = (state_24134[(2)]);
var inst_24093__$1 = cljs.core.nth.call(null,inst_24092,(0),null);
var inst_24094__$1 = cljs.core.nth.call(null,inst_24092,(1),null);
var inst_24095 = (inst_24093__$1 == null);
var inst_24096 = cljs.core._EQ_.call(null,inst_24094__$1,change);
var inst_24097 = (inst_24095) || (inst_24096);
var state_24134__$1 = (function (){var statearr_24156 = state_24134;
(statearr_24156[(14)] = inst_24093__$1);

(statearr_24156[(10)] = inst_24094__$1);

return statearr_24156;
})();
if(cljs.core.truth_(inst_24097)){
var statearr_24157_24214 = state_24134__$1;
(statearr_24157_24214[(1)] = (23));

} else {
var statearr_24158_24215 = state_24134__$1;
(statearr_24158_24215[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (36))){
var inst_24084 = (state_24134[(12)]);
var inst_24061 = inst_24084;
var state_24134__$1 = (function (){var statearr_24159 = state_24134;
(statearr_24159[(7)] = inst_24061);

return statearr_24159;
})();
var statearr_24160_24216 = state_24134__$1;
(statearr_24160_24216[(2)] = null);

(statearr_24160_24216[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (29))){
var inst_24108 = (state_24134[(9)]);
var state_24134__$1 = state_24134;
var statearr_24161_24217 = state_24134__$1;
(statearr_24161_24217[(2)] = inst_24108);

(statearr_24161_24217[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (6))){
var state_24134__$1 = state_24134;
var statearr_24162_24218 = state_24134__$1;
(statearr_24162_24218[(2)] = false);

(statearr_24162_24218[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (28))){
var inst_24104 = (state_24134[(2)]);
var inst_24105 = calc_state.call(null);
var inst_24061 = inst_24105;
var state_24134__$1 = (function (){var statearr_24163 = state_24134;
(statearr_24163[(7)] = inst_24061);

(statearr_24163[(15)] = inst_24104);

return statearr_24163;
})();
var statearr_24164_24219 = state_24134__$1;
(statearr_24164_24219[(2)] = null);

(statearr_24164_24219[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (25))){
var inst_24130 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
var statearr_24165_24220 = state_24134__$1;
(statearr_24165_24220[(2)] = inst_24130);

(statearr_24165_24220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (34))){
var inst_24128 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
var statearr_24166_24221 = state_24134__$1;
(statearr_24166_24221[(2)] = inst_24128);

(statearr_24166_24221[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (17))){
var state_24134__$1 = state_24134;
var statearr_24167_24222 = state_24134__$1;
(statearr_24167_24222[(2)] = false);

(statearr_24167_24222[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (3))){
var state_24134__$1 = state_24134;
var statearr_24168_24223 = state_24134__$1;
(statearr_24168_24223[(2)] = false);

(statearr_24168_24223[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (12))){
var inst_24132 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24134__$1,inst_24132);
} else {
if((state_val_24135 === (2))){
var inst_24036 = (state_24134[(8)]);
var inst_24041 = inst_24036.cljs$lang$protocol_mask$partition0$;
var inst_24042 = (inst_24041 & (64));
var inst_24043 = inst_24036.cljs$core$ISeq$;
var inst_24044 = (cljs.core.PROTOCOL_SENTINEL === inst_24043);
var inst_24045 = (inst_24042) || (inst_24044);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24045)){
var statearr_24169_24224 = state_24134__$1;
(statearr_24169_24224[(1)] = (5));

} else {
var statearr_24170_24225 = state_24134__$1;
(statearr_24170_24225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (23))){
var inst_24093 = (state_24134[(14)]);
var inst_24099 = (inst_24093 == null);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24099)){
var statearr_24171_24226 = state_24134__$1;
(statearr_24171_24226[(1)] = (26));

} else {
var statearr_24172_24227 = state_24134__$1;
(statearr_24172_24227[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (35))){
var inst_24119 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
if(cljs.core.truth_(inst_24119)){
var statearr_24173_24228 = state_24134__$1;
(statearr_24173_24228[(1)] = (36));

} else {
var statearr_24174_24229 = state_24134__$1;
(statearr_24174_24229[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (19))){
var inst_24061 = (state_24134[(7)]);
var inst_24081 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24061);
var state_24134__$1 = state_24134;
var statearr_24175_24230 = state_24134__$1;
(statearr_24175_24230[(2)] = inst_24081);

(statearr_24175_24230[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (11))){
var inst_24061 = (state_24134[(7)]);
var inst_24065 = (inst_24061 == null);
var inst_24066 = cljs.core.not.call(null,inst_24065);
var state_24134__$1 = state_24134;
if(inst_24066){
var statearr_24176_24231 = state_24134__$1;
(statearr_24176_24231[(1)] = (13));

} else {
var statearr_24177_24232 = state_24134__$1;
(statearr_24177_24232[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (9))){
var inst_24036 = (state_24134[(8)]);
var state_24134__$1 = state_24134;
var statearr_24178_24233 = state_24134__$1;
(statearr_24178_24233[(2)] = inst_24036);

(statearr_24178_24233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (5))){
var state_24134__$1 = state_24134;
var statearr_24179_24234 = state_24134__$1;
(statearr_24179_24234[(2)] = true);

(statearr_24179_24234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (14))){
var state_24134__$1 = state_24134;
var statearr_24180_24235 = state_24134__$1;
(statearr_24180_24235[(2)] = false);

(statearr_24180_24235[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (26))){
var inst_24094 = (state_24134[(10)]);
var inst_24101 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24094);
var state_24134__$1 = state_24134;
var statearr_24181_24236 = state_24134__$1;
(statearr_24181_24236[(2)] = inst_24101);

(statearr_24181_24236[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (16))){
var state_24134__$1 = state_24134;
var statearr_24182_24237 = state_24134__$1;
(statearr_24182_24237[(2)] = true);

(statearr_24182_24237[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (38))){
var inst_24124 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
var statearr_24183_24238 = state_24134__$1;
(statearr_24183_24238[(2)] = inst_24124);

(statearr_24183_24238[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (30))){
var inst_24094 = (state_24134[(10)]);
var inst_24086 = (state_24134[(13)]);
var inst_24085 = (state_24134[(11)]);
var inst_24111 = cljs.core.empty_QMARK_.call(null,inst_24085);
var inst_24112 = inst_24086.call(null,inst_24094);
var inst_24113 = cljs.core.not.call(null,inst_24112);
var inst_24114 = (inst_24111) && (inst_24113);
var state_24134__$1 = state_24134;
var statearr_24184_24239 = state_24134__$1;
(statearr_24184_24239[(2)] = inst_24114);

(statearr_24184_24239[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (10))){
var inst_24036 = (state_24134[(8)]);
var inst_24057 = (state_24134[(2)]);
var inst_24058 = cljs.core.get.call(null,inst_24057,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24059 = cljs.core.get.call(null,inst_24057,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24060 = cljs.core.get.call(null,inst_24057,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24061 = inst_24036;
var state_24134__$1 = (function (){var statearr_24185 = state_24134;
(statearr_24185[(16)] = inst_24058);

(statearr_24185[(17)] = inst_24060);

(statearr_24185[(18)] = inst_24059);

(statearr_24185[(7)] = inst_24061);

return statearr_24185;
})();
var statearr_24186_24240 = state_24134__$1;
(statearr_24186_24240[(2)] = null);

(statearr_24186_24240[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (18))){
var inst_24076 = (state_24134[(2)]);
var state_24134__$1 = state_24134;
var statearr_24187_24241 = state_24134__$1;
(statearr_24187_24241[(2)] = inst_24076);

(statearr_24187_24241[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (37))){
var state_24134__$1 = state_24134;
var statearr_24188_24242 = state_24134__$1;
(statearr_24188_24242[(2)] = null);

(statearr_24188_24242[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24135 === (8))){
var inst_24036 = (state_24134[(8)]);
var inst_24054 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24036);
var state_24134__$1 = state_24134;
var statearr_24189_24243 = state_24134__$1;
(statearr_24189_24243[(2)] = inst_24054);

(statearr_24189_24243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___24197,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__22348__auto__,c__22460__auto___24197,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__22349__auto__ = null;
var cljs$core$async$mix_$_state_machine__22349__auto____0 = (function (){
var statearr_24193 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24193[(0)] = cljs$core$async$mix_$_state_machine__22349__auto__);

(statearr_24193[(1)] = (1));

return statearr_24193;
});
var cljs$core$async$mix_$_state_machine__22349__auto____1 = (function (state_24134){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24194){if((e24194 instanceof Object)){
var ex__22352__auto__ = e24194;
var statearr_24195_24244 = state_24134;
(statearr_24195_24244[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24134);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24245 = state_24134;
state_24134 = G__24245;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__22349__auto__ = function(state_24134){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__22349__auto____1.call(this,state_24134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__22349__auto____0;
cljs$core$async$mix_$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__22349__auto____1;
return cljs$core$async$mix_$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___24197,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__22462__auto__ = (function (){var statearr_24196 = f__22461__auto__.call(null);
(statearr_24196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___24197);

return statearr_24196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___24197,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__20919__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p,v,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args24246 = [];
var len__21363__auto___24249 = arguments.length;
var i__21364__auto___24250 = (0);
while(true){
if((i__21364__auto___24250 < len__21363__auto___24249)){
args24246.push((arguments[i__21364__auto___24250]));

var G__24251 = (i__21364__auto___24250 + (1));
i__21364__auto___24250 = G__24251;
continue;
} else {
}
break;
}

var G__24248 = args24246.length;
switch (G__24248) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24246.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p);
} else {
var m__20919__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p,v);
} else {
var m__20919__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args24254 = [];
var len__21363__auto___24379 = arguments.length;
var i__21364__auto___24380 = (0);
while(true){
if((i__21364__auto___24380 < len__21363__auto___24379)){
args24254.push((arguments[i__21364__auto___24380]));

var G__24381 = (i__21364__auto___24380 + (1));
i__21364__auto___24380 = G__24381;
continue;
} else {
}
break;
}

var G__24256 = args24254.length;
switch (G__24256) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24254.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__20255__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__20255__auto__,mults){
return (function (p1__24253_SHARP_){
if(cljs.core.truth_(p1__24253_SHARP_.call(null,topic))){
return p1__24253_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__24253_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__20255__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async24257 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24257 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta24258){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta24258 = meta24258;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_24259,meta24258__$1){
var self__ = this;
var _24259__$1 = this;
return (new cljs.core.async.t_cljs$core$async24257(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta24258__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_24259){
var self__ = this;
var _24259__$1 = this;
return self__.meta24258;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta24258","meta24258",-1332409135,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24257.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24257.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24257";

cljs.core.async.t_cljs$core$async24257.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24257");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async24257 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async24257(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta24258){
return (new cljs.core.async.t_cljs$core$async24257(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta24258));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async24257(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22460__auto___24383 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___24383,mults,ensure_mult,p){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___24383,mults,ensure_mult,p){
return (function (state_24331){
var state_val_24332 = (state_24331[(1)]);
if((state_val_24332 === (7))){
var inst_24327 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24333_24384 = state_24331__$1;
(statearr_24333_24384[(2)] = inst_24327);

(statearr_24333_24384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (20))){
var state_24331__$1 = state_24331;
var statearr_24334_24385 = state_24331__$1;
(statearr_24334_24385[(2)] = null);

(statearr_24334_24385[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (1))){
var state_24331__$1 = state_24331;
var statearr_24335_24386 = state_24331__$1;
(statearr_24335_24386[(2)] = null);

(statearr_24335_24386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (24))){
var inst_24310 = (state_24331[(7)]);
var inst_24319 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_24310);
var state_24331__$1 = state_24331;
var statearr_24336_24387 = state_24331__$1;
(statearr_24336_24387[(2)] = inst_24319);

(statearr_24336_24387[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (4))){
var inst_24262 = (state_24331[(8)]);
var inst_24262__$1 = (state_24331[(2)]);
var inst_24263 = (inst_24262__$1 == null);
var state_24331__$1 = (function (){var statearr_24337 = state_24331;
(statearr_24337[(8)] = inst_24262__$1);

return statearr_24337;
})();
if(cljs.core.truth_(inst_24263)){
var statearr_24338_24388 = state_24331__$1;
(statearr_24338_24388[(1)] = (5));

} else {
var statearr_24339_24389 = state_24331__$1;
(statearr_24339_24389[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (15))){
var inst_24304 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24340_24390 = state_24331__$1;
(statearr_24340_24390[(2)] = inst_24304);

(statearr_24340_24390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (21))){
var inst_24324 = (state_24331[(2)]);
var state_24331__$1 = (function (){var statearr_24341 = state_24331;
(statearr_24341[(9)] = inst_24324);

return statearr_24341;
})();
var statearr_24342_24391 = state_24331__$1;
(statearr_24342_24391[(2)] = null);

(statearr_24342_24391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (13))){
var inst_24286 = (state_24331[(10)]);
var inst_24288 = cljs.core.chunked_seq_QMARK_.call(null,inst_24286);
var state_24331__$1 = state_24331;
if(inst_24288){
var statearr_24343_24392 = state_24331__$1;
(statearr_24343_24392[(1)] = (16));

} else {
var statearr_24344_24393 = state_24331__$1;
(statearr_24344_24393[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (22))){
var inst_24316 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
if(cljs.core.truth_(inst_24316)){
var statearr_24345_24394 = state_24331__$1;
(statearr_24345_24394[(1)] = (23));

} else {
var statearr_24346_24395 = state_24331__$1;
(statearr_24346_24395[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (6))){
var inst_24262 = (state_24331[(8)]);
var inst_24312 = (state_24331[(11)]);
var inst_24310 = (state_24331[(7)]);
var inst_24310__$1 = topic_fn.call(null,inst_24262);
var inst_24311 = cljs.core.deref.call(null,mults);
var inst_24312__$1 = cljs.core.get.call(null,inst_24311,inst_24310__$1);
var state_24331__$1 = (function (){var statearr_24347 = state_24331;
(statearr_24347[(11)] = inst_24312__$1);

(statearr_24347[(7)] = inst_24310__$1);

return statearr_24347;
})();
if(cljs.core.truth_(inst_24312__$1)){
var statearr_24348_24396 = state_24331__$1;
(statearr_24348_24396[(1)] = (19));

} else {
var statearr_24349_24397 = state_24331__$1;
(statearr_24349_24397[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (25))){
var inst_24321 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24350_24398 = state_24331__$1;
(statearr_24350_24398[(2)] = inst_24321);

(statearr_24350_24398[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (17))){
var inst_24286 = (state_24331[(10)]);
var inst_24295 = cljs.core.first.call(null,inst_24286);
var inst_24296 = cljs.core.async.muxch_STAR_.call(null,inst_24295);
var inst_24297 = cljs.core.async.close_BANG_.call(null,inst_24296);
var inst_24298 = cljs.core.next.call(null,inst_24286);
var inst_24272 = inst_24298;
var inst_24273 = null;
var inst_24274 = (0);
var inst_24275 = (0);
var state_24331__$1 = (function (){var statearr_24351 = state_24331;
(statearr_24351[(12)] = inst_24275);

(statearr_24351[(13)] = inst_24274);

(statearr_24351[(14)] = inst_24297);

(statearr_24351[(15)] = inst_24272);

(statearr_24351[(16)] = inst_24273);

return statearr_24351;
})();
var statearr_24352_24399 = state_24331__$1;
(statearr_24352_24399[(2)] = null);

(statearr_24352_24399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (3))){
var inst_24329 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24331__$1,inst_24329);
} else {
if((state_val_24332 === (12))){
var inst_24306 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24353_24400 = state_24331__$1;
(statearr_24353_24400[(2)] = inst_24306);

(statearr_24353_24400[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (2))){
var state_24331__$1 = state_24331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24331__$1,(4),ch);
} else {
if((state_val_24332 === (23))){
var state_24331__$1 = state_24331;
var statearr_24354_24401 = state_24331__$1;
(statearr_24354_24401[(2)] = null);

(statearr_24354_24401[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (19))){
var inst_24262 = (state_24331[(8)]);
var inst_24312 = (state_24331[(11)]);
var inst_24314 = cljs.core.async.muxch_STAR_.call(null,inst_24312);
var state_24331__$1 = state_24331;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24331__$1,(22),inst_24314,inst_24262);
} else {
if((state_val_24332 === (11))){
var inst_24286 = (state_24331[(10)]);
var inst_24272 = (state_24331[(15)]);
var inst_24286__$1 = cljs.core.seq.call(null,inst_24272);
var state_24331__$1 = (function (){var statearr_24355 = state_24331;
(statearr_24355[(10)] = inst_24286__$1);

return statearr_24355;
})();
if(inst_24286__$1){
var statearr_24356_24402 = state_24331__$1;
(statearr_24356_24402[(1)] = (13));

} else {
var statearr_24357_24403 = state_24331__$1;
(statearr_24357_24403[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (9))){
var inst_24308 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24358_24404 = state_24331__$1;
(statearr_24358_24404[(2)] = inst_24308);

(statearr_24358_24404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (5))){
var inst_24269 = cljs.core.deref.call(null,mults);
var inst_24270 = cljs.core.vals.call(null,inst_24269);
var inst_24271 = cljs.core.seq.call(null,inst_24270);
var inst_24272 = inst_24271;
var inst_24273 = null;
var inst_24274 = (0);
var inst_24275 = (0);
var state_24331__$1 = (function (){var statearr_24359 = state_24331;
(statearr_24359[(12)] = inst_24275);

(statearr_24359[(13)] = inst_24274);

(statearr_24359[(15)] = inst_24272);

(statearr_24359[(16)] = inst_24273);

return statearr_24359;
})();
var statearr_24360_24405 = state_24331__$1;
(statearr_24360_24405[(2)] = null);

(statearr_24360_24405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (14))){
var state_24331__$1 = state_24331;
var statearr_24364_24406 = state_24331__$1;
(statearr_24364_24406[(2)] = null);

(statearr_24364_24406[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (16))){
var inst_24286 = (state_24331[(10)]);
var inst_24290 = cljs.core.chunk_first.call(null,inst_24286);
var inst_24291 = cljs.core.chunk_rest.call(null,inst_24286);
var inst_24292 = cljs.core.count.call(null,inst_24290);
var inst_24272 = inst_24291;
var inst_24273 = inst_24290;
var inst_24274 = inst_24292;
var inst_24275 = (0);
var state_24331__$1 = (function (){var statearr_24365 = state_24331;
(statearr_24365[(12)] = inst_24275);

(statearr_24365[(13)] = inst_24274);

(statearr_24365[(15)] = inst_24272);

(statearr_24365[(16)] = inst_24273);

return statearr_24365;
})();
var statearr_24366_24407 = state_24331__$1;
(statearr_24366_24407[(2)] = null);

(statearr_24366_24407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (10))){
var inst_24275 = (state_24331[(12)]);
var inst_24274 = (state_24331[(13)]);
var inst_24272 = (state_24331[(15)]);
var inst_24273 = (state_24331[(16)]);
var inst_24280 = cljs.core._nth.call(null,inst_24273,inst_24275);
var inst_24281 = cljs.core.async.muxch_STAR_.call(null,inst_24280);
var inst_24282 = cljs.core.async.close_BANG_.call(null,inst_24281);
var inst_24283 = (inst_24275 + (1));
var tmp24361 = inst_24274;
var tmp24362 = inst_24272;
var tmp24363 = inst_24273;
var inst_24272__$1 = tmp24362;
var inst_24273__$1 = tmp24363;
var inst_24274__$1 = tmp24361;
var inst_24275__$1 = inst_24283;
var state_24331__$1 = (function (){var statearr_24367 = state_24331;
(statearr_24367[(12)] = inst_24275__$1);

(statearr_24367[(13)] = inst_24274__$1);

(statearr_24367[(17)] = inst_24282);

(statearr_24367[(15)] = inst_24272__$1);

(statearr_24367[(16)] = inst_24273__$1);

return statearr_24367;
})();
var statearr_24368_24408 = state_24331__$1;
(statearr_24368_24408[(2)] = null);

(statearr_24368_24408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (18))){
var inst_24301 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24369_24409 = state_24331__$1;
(statearr_24369_24409[(2)] = inst_24301);

(statearr_24369_24409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (8))){
var inst_24275 = (state_24331[(12)]);
var inst_24274 = (state_24331[(13)]);
var inst_24277 = (inst_24275 < inst_24274);
var inst_24278 = inst_24277;
var state_24331__$1 = state_24331;
if(cljs.core.truth_(inst_24278)){
var statearr_24370_24410 = state_24331__$1;
(statearr_24370_24410[(1)] = (10));

} else {
var statearr_24371_24411 = state_24331__$1;
(statearr_24371_24411[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___24383,mults,ensure_mult,p))
;
return ((function (switch__22348__auto__,c__22460__auto___24383,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_24375 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24375[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_24375[(1)] = (1));

return statearr_24375;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_24331){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24376){if((e24376 instanceof Object)){
var ex__22352__auto__ = e24376;
var statearr_24377_24412 = state_24331;
(statearr_24377_24412[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24331);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24376;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24413 = state_24331;
state_24331 = G__24413;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_24331){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_24331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___24383,mults,ensure_mult,p))
})();
var state__22462__auto__ = (function (){var statearr_24378 = f__22461__auto__.call(null);
(statearr_24378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___24383);

return statearr_24378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___24383,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args24414 = [];
var len__21363__auto___24417 = arguments.length;
var i__21364__auto___24418 = (0);
while(true){
if((i__21364__auto___24418 < len__21363__auto___24417)){
args24414.push((arguments[i__21364__auto___24418]));

var G__24419 = (i__21364__auto___24418 + (1));
i__21364__auto___24418 = G__24419;
continue;
} else {
}
break;
}

var G__24416 = args24414.length;
switch (G__24416) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24414.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args24421 = [];
var len__21363__auto___24424 = arguments.length;
var i__21364__auto___24425 = (0);
while(true){
if((i__21364__auto___24425 < len__21363__auto___24424)){
args24421.push((arguments[i__21364__auto___24425]));

var G__24426 = (i__21364__auto___24425 + (1));
i__21364__auto___24425 = G__24426;
continue;
} else {
}
break;
}

var G__24423 = args24421.length;
switch (G__24423) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24421.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args24428 = [];
var len__21363__auto___24499 = arguments.length;
var i__21364__auto___24500 = (0);
while(true){
if((i__21364__auto___24500 < len__21363__auto___24499)){
args24428.push((arguments[i__21364__auto___24500]));

var G__24501 = (i__21364__auto___24500 + (1));
i__21364__auto___24500 = G__24501;
continue;
} else {
}
break;
}

var G__24430 = args24428.length;
switch (G__24430) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24428.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__22460__auto___24503 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___24503,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___24503,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_24469){
var state_val_24470 = (state_24469[(1)]);
if((state_val_24470 === (7))){
var state_24469__$1 = state_24469;
var statearr_24471_24504 = state_24469__$1;
(statearr_24471_24504[(2)] = null);

(statearr_24471_24504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (1))){
var state_24469__$1 = state_24469;
var statearr_24472_24505 = state_24469__$1;
(statearr_24472_24505[(2)] = null);

(statearr_24472_24505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (4))){
var inst_24433 = (state_24469[(7)]);
var inst_24435 = (inst_24433 < cnt);
var state_24469__$1 = state_24469;
if(cljs.core.truth_(inst_24435)){
var statearr_24473_24506 = state_24469__$1;
(statearr_24473_24506[(1)] = (6));

} else {
var statearr_24474_24507 = state_24469__$1;
(statearr_24474_24507[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (15))){
var inst_24465 = (state_24469[(2)]);
var state_24469__$1 = state_24469;
var statearr_24475_24508 = state_24469__$1;
(statearr_24475_24508[(2)] = inst_24465);

(statearr_24475_24508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (13))){
var inst_24458 = cljs.core.async.close_BANG_.call(null,out);
var state_24469__$1 = state_24469;
var statearr_24476_24509 = state_24469__$1;
(statearr_24476_24509[(2)] = inst_24458);

(statearr_24476_24509[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (6))){
var state_24469__$1 = state_24469;
var statearr_24477_24510 = state_24469__$1;
(statearr_24477_24510[(2)] = null);

(statearr_24477_24510[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (3))){
var inst_24467 = (state_24469[(2)]);
var state_24469__$1 = state_24469;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24469__$1,inst_24467);
} else {
if((state_val_24470 === (12))){
var inst_24455 = (state_24469[(8)]);
var inst_24455__$1 = (state_24469[(2)]);
var inst_24456 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_24455__$1);
var state_24469__$1 = (function (){var statearr_24478 = state_24469;
(statearr_24478[(8)] = inst_24455__$1);

return statearr_24478;
})();
if(cljs.core.truth_(inst_24456)){
var statearr_24479_24511 = state_24469__$1;
(statearr_24479_24511[(1)] = (13));

} else {
var statearr_24480_24512 = state_24469__$1;
(statearr_24480_24512[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (2))){
var inst_24432 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_24433 = (0);
var state_24469__$1 = (function (){var statearr_24481 = state_24469;
(statearr_24481[(9)] = inst_24432);

(statearr_24481[(7)] = inst_24433);

return statearr_24481;
})();
var statearr_24482_24513 = state_24469__$1;
(statearr_24482_24513[(2)] = null);

(statearr_24482_24513[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (11))){
var inst_24433 = (state_24469[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_24469,(10),Object,null,(9));
var inst_24442 = chs__$1.call(null,inst_24433);
var inst_24443 = done.call(null,inst_24433);
var inst_24444 = cljs.core.async.take_BANG_.call(null,inst_24442,inst_24443);
var state_24469__$1 = state_24469;
var statearr_24483_24514 = state_24469__$1;
(statearr_24483_24514[(2)] = inst_24444);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24469__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (9))){
var inst_24433 = (state_24469[(7)]);
var inst_24446 = (state_24469[(2)]);
var inst_24447 = (inst_24433 + (1));
var inst_24433__$1 = inst_24447;
var state_24469__$1 = (function (){var statearr_24484 = state_24469;
(statearr_24484[(7)] = inst_24433__$1);

(statearr_24484[(10)] = inst_24446);

return statearr_24484;
})();
var statearr_24485_24515 = state_24469__$1;
(statearr_24485_24515[(2)] = null);

(statearr_24485_24515[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (5))){
var inst_24453 = (state_24469[(2)]);
var state_24469__$1 = (function (){var statearr_24486 = state_24469;
(statearr_24486[(11)] = inst_24453);

return statearr_24486;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24469__$1,(12),dchan);
} else {
if((state_val_24470 === (14))){
var inst_24455 = (state_24469[(8)]);
var inst_24460 = cljs.core.apply.call(null,f,inst_24455);
var state_24469__$1 = state_24469;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24469__$1,(16),out,inst_24460);
} else {
if((state_val_24470 === (16))){
var inst_24462 = (state_24469[(2)]);
var state_24469__$1 = (function (){var statearr_24487 = state_24469;
(statearr_24487[(12)] = inst_24462);

return statearr_24487;
})();
var statearr_24488_24516 = state_24469__$1;
(statearr_24488_24516[(2)] = null);

(statearr_24488_24516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (10))){
var inst_24437 = (state_24469[(2)]);
var inst_24438 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_24469__$1 = (function (){var statearr_24489 = state_24469;
(statearr_24489[(13)] = inst_24437);

return statearr_24489;
})();
var statearr_24490_24517 = state_24469__$1;
(statearr_24490_24517[(2)] = inst_24438);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24469__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24470 === (8))){
var inst_24451 = (state_24469[(2)]);
var state_24469__$1 = state_24469;
var statearr_24491_24518 = state_24469__$1;
(statearr_24491_24518[(2)] = inst_24451);

(statearr_24491_24518[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___24503,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__22348__auto__,c__22460__auto___24503,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_24495 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24495[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_24495[(1)] = (1));

return statearr_24495;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_24469){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24496){if((e24496 instanceof Object)){
var ex__22352__auto__ = e24496;
var statearr_24497_24519 = state_24469;
(statearr_24497_24519[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24469);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24496;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24520 = state_24469;
state_24469 = G__24520;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_24469){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_24469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___24503,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__22462__auto__ = (function (){var statearr_24498 = f__22461__auto__.call(null);
(statearr_24498[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___24503);

return statearr_24498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___24503,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args24522 = [];
var len__21363__auto___24580 = arguments.length;
var i__21364__auto___24581 = (0);
while(true){
if((i__21364__auto___24581 < len__21363__auto___24580)){
args24522.push((arguments[i__21364__auto___24581]));

var G__24582 = (i__21364__auto___24581 + (1));
i__21364__auto___24581 = G__24582;
continue;
} else {
}
break;
}

var G__24524 = args24522.length;
switch (G__24524) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24522.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22460__auto___24584 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___24584,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___24584,out){
return (function (state_24556){
var state_val_24557 = (state_24556[(1)]);
if((state_val_24557 === (7))){
var inst_24536 = (state_24556[(7)]);
var inst_24535 = (state_24556[(8)]);
var inst_24535__$1 = (state_24556[(2)]);
var inst_24536__$1 = cljs.core.nth.call(null,inst_24535__$1,(0),null);
var inst_24537 = cljs.core.nth.call(null,inst_24535__$1,(1),null);
var inst_24538 = (inst_24536__$1 == null);
var state_24556__$1 = (function (){var statearr_24558 = state_24556;
(statearr_24558[(7)] = inst_24536__$1);

(statearr_24558[(8)] = inst_24535__$1);

(statearr_24558[(9)] = inst_24537);

return statearr_24558;
})();
if(cljs.core.truth_(inst_24538)){
var statearr_24559_24585 = state_24556__$1;
(statearr_24559_24585[(1)] = (8));

} else {
var statearr_24560_24586 = state_24556__$1;
(statearr_24560_24586[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (1))){
var inst_24525 = cljs.core.vec.call(null,chs);
var inst_24526 = inst_24525;
var state_24556__$1 = (function (){var statearr_24561 = state_24556;
(statearr_24561[(10)] = inst_24526);

return statearr_24561;
})();
var statearr_24562_24587 = state_24556__$1;
(statearr_24562_24587[(2)] = null);

(statearr_24562_24587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (4))){
var inst_24526 = (state_24556[(10)]);
var state_24556__$1 = state_24556;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24556__$1,(7),inst_24526);
} else {
if((state_val_24557 === (6))){
var inst_24552 = (state_24556[(2)]);
var state_24556__$1 = state_24556;
var statearr_24563_24588 = state_24556__$1;
(statearr_24563_24588[(2)] = inst_24552);

(statearr_24563_24588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (3))){
var inst_24554 = (state_24556[(2)]);
var state_24556__$1 = state_24556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24556__$1,inst_24554);
} else {
if((state_val_24557 === (2))){
var inst_24526 = (state_24556[(10)]);
var inst_24528 = cljs.core.count.call(null,inst_24526);
var inst_24529 = (inst_24528 > (0));
var state_24556__$1 = state_24556;
if(cljs.core.truth_(inst_24529)){
var statearr_24565_24589 = state_24556__$1;
(statearr_24565_24589[(1)] = (4));

} else {
var statearr_24566_24590 = state_24556__$1;
(statearr_24566_24590[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (11))){
var inst_24526 = (state_24556[(10)]);
var inst_24545 = (state_24556[(2)]);
var tmp24564 = inst_24526;
var inst_24526__$1 = tmp24564;
var state_24556__$1 = (function (){var statearr_24567 = state_24556;
(statearr_24567[(11)] = inst_24545);

(statearr_24567[(10)] = inst_24526__$1);

return statearr_24567;
})();
var statearr_24568_24591 = state_24556__$1;
(statearr_24568_24591[(2)] = null);

(statearr_24568_24591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (9))){
var inst_24536 = (state_24556[(7)]);
var state_24556__$1 = state_24556;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24556__$1,(11),out,inst_24536);
} else {
if((state_val_24557 === (5))){
var inst_24550 = cljs.core.async.close_BANG_.call(null,out);
var state_24556__$1 = state_24556;
var statearr_24569_24592 = state_24556__$1;
(statearr_24569_24592[(2)] = inst_24550);

(statearr_24569_24592[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (10))){
var inst_24548 = (state_24556[(2)]);
var state_24556__$1 = state_24556;
var statearr_24570_24593 = state_24556__$1;
(statearr_24570_24593[(2)] = inst_24548);

(statearr_24570_24593[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24557 === (8))){
var inst_24536 = (state_24556[(7)]);
var inst_24535 = (state_24556[(8)]);
var inst_24537 = (state_24556[(9)]);
var inst_24526 = (state_24556[(10)]);
var inst_24540 = (function (){var cs = inst_24526;
var vec__24531 = inst_24535;
var v = inst_24536;
var c = inst_24537;
return ((function (cs,vec__24531,v,c,inst_24536,inst_24535,inst_24537,inst_24526,state_val_24557,c__22460__auto___24584,out){
return (function (p1__24521_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__24521_SHARP_);
});
;})(cs,vec__24531,v,c,inst_24536,inst_24535,inst_24537,inst_24526,state_val_24557,c__22460__auto___24584,out))
})();
var inst_24541 = cljs.core.filterv.call(null,inst_24540,inst_24526);
var inst_24526__$1 = inst_24541;
var state_24556__$1 = (function (){var statearr_24571 = state_24556;
(statearr_24571[(10)] = inst_24526__$1);

return statearr_24571;
})();
var statearr_24572_24594 = state_24556__$1;
(statearr_24572_24594[(2)] = null);

(statearr_24572_24594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___24584,out))
;
return ((function (switch__22348__auto__,c__22460__auto___24584,out){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_24576 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24576[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_24576[(1)] = (1));

return statearr_24576;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_24556){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24577){if((e24577 instanceof Object)){
var ex__22352__auto__ = e24577;
var statearr_24578_24595 = state_24556;
(statearr_24578_24595[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24556);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24577;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24596 = state_24556;
state_24556 = G__24596;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_24556){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_24556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___24584,out))
})();
var state__22462__auto__ = (function (){var statearr_24579 = f__22461__auto__.call(null);
(statearr_24579[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___24584);

return statearr_24579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___24584,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args24597 = [];
var len__21363__auto___24646 = arguments.length;
var i__21364__auto___24647 = (0);
while(true){
if((i__21364__auto___24647 < len__21363__auto___24646)){
args24597.push((arguments[i__21364__auto___24647]));

var G__24648 = (i__21364__auto___24647 + (1));
i__21364__auto___24647 = G__24648;
continue;
} else {
}
break;
}

var G__24599 = args24597.length;
switch (G__24599) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24597.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22460__auto___24650 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___24650,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___24650,out){
return (function (state_24623){
var state_val_24624 = (state_24623[(1)]);
if((state_val_24624 === (7))){
var inst_24605 = (state_24623[(7)]);
var inst_24605__$1 = (state_24623[(2)]);
var inst_24606 = (inst_24605__$1 == null);
var inst_24607 = cljs.core.not.call(null,inst_24606);
var state_24623__$1 = (function (){var statearr_24625 = state_24623;
(statearr_24625[(7)] = inst_24605__$1);

return statearr_24625;
})();
if(inst_24607){
var statearr_24626_24651 = state_24623__$1;
(statearr_24626_24651[(1)] = (8));

} else {
var statearr_24627_24652 = state_24623__$1;
(statearr_24627_24652[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (1))){
var inst_24600 = (0);
var state_24623__$1 = (function (){var statearr_24628 = state_24623;
(statearr_24628[(8)] = inst_24600);

return statearr_24628;
})();
var statearr_24629_24653 = state_24623__$1;
(statearr_24629_24653[(2)] = null);

(statearr_24629_24653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (4))){
var state_24623__$1 = state_24623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24623__$1,(7),ch);
} else {
if((state_val_24624 === (6))){
var inst_24618 = (state_24623[(2)]);
var state_24623__$1 = state_24623;
var statearr_24630_24654 = state_24623__$1;
(statearr_24630_24654[(2)] = inst_24618);

(statearr_24630_24654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (3))){
var inst_24620 = (state_24623[(2)]);
var inst_24621 = cljs.core.async.close_BANG_.call(null,out);
var state_24623__$1 = (function (){var statearr_24631 = state_24623;
(statearr_24631[(9)] = inst_24620);

return statearr_24631;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24623__$1,inst_24621);
} else {
if((state_val_24624 === (2))){
var inst_24600 = (state_24623[(8)]);
var inst_24602 = (inst_24600 < n);
var state_24623__$1 = state_24623;
if(cljs.core.truth_(inst_24602)){
var statearr_24632_24655 = state_24623__$1;
(statearr_24632_24655[(1)] = (4));

} else {
var statearr_24633_24656 = state_24623__$1;
(statearr_24633_24656[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (11))){
var inst_24600 = (state_24623[(8)]);
var inst_24610 = (state_24623[(2)]);
var inst_24611 = (inst_24600 + (1));
var inst_24600__$1 = inst_24611;
var state_24623__$1 = (function (){var statearr_24634 = state_24623;
(statearr_24634[(8)] = inst_24600__$1);

(statearr_24634[(10)] = inst_24610);

return statearr_24634;
})();
var statearr_24635_24657 = state_24623__$1;
(statearr_24635_24657[(2)] = null);

(statearr_24635_24657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (9))){
var state_24623__$1 = state_24623;
var statearr_24636_24658 = state_24623__$1;
(statearr_24636_24658[(2)] = null);

(statearr_24636_24658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (5))){
var state_24623__$1 = state_24623;
var statearr_24637_24659 = state_24623__$1;
(statearr_24637_24659[(2)] = null);

(statearr_24637_24659[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (10))){
var inst_24615 = (state_24623[(2)]);
var state_24623__$1 = state_24623;
var statearr_24638_24660 = state_24623__$1;
(statearr_24638_24660[(2)] = inst_24615);

(statearr_24638_24660[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24624 === (8))){
var inst_24605 = (state_24623[(7)]);
var state_24623__$1 = state_24623;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24623__$1,(11),out,inst_24605);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___24650,out))
;
return ((function (switch__22348__auto__,c__22460__auto___24650,out){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_24642 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24642[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_24642[(1)] = (1));

return statearr_24642;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_24623){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24623);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24643){if((e24643 instanceof Object)){
var ex__22352__auto__ = e24643;
var statearr_24644_24661 = state_24623;
(statearr_24644_24661[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24623);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24643;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24662 = state_24623;
state_24623 = G__24662;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_24623){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_24623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___24650,out))
})();
var state__22462__auto__ = (function (){var statearr_24645 = f__22461__auto__.call(null);
(statearr_24645[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___24650);

return statearr_24645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___24650,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async24670 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24670 = (function (f,ch,meta24671){
this.f = f;
this.ch = ch;
this.meta24671 = meta24671;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24672,meta24671__$1){
var self__ = this;
var _24672__$1 = this;
return (new cljs.core.async.t_cljs$core$async24670(self__.f,self__.ch,meta24671__$1));
});

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24672){
var self__ = this;
var _24672__$1 = this;
return self__.meta24671;
});

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async24673 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24673 = (function (f,ch,meta24671,_,fn1,meta24674){
this.f = f;
this.ch = ch;
this.meta24671 = meta24671;
this._ = _;
this.fn1 = fn1;
this.meta24674 = meta24674;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24673.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_24675,meta24674__$1){
var self__ = this;
var _24675__$1 = this;
return (new cljs.core.async.t_cljs$core$async24673(self__.f,self__.ch,self__.meta24671,self__._,self__.fn1,meta24674__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async24673.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_24675){
var self__ = this;
var _24675__$1 = this;
return self__.meta24674;
});})(___$1))
;

cljs.core.async.t_cljs$core$async24673.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24673.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async24673.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async24673.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__24663_SHARP_){
return f1.call(null,(((p1__24663_SHARP_ == null))?null:self__.f.call(null,p1__24663_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async24673.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24671","meta24671",882284595,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async24670","cljs.core.async/t_cljs$core$async24670",-1473462428,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta24674","meta24674",125115761,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async24673.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24673.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24673";

cljs.core.async.t_cljs$core$async24673.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24673");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async24673 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24673(f__$1,ch__$1,meta24671__$1,___$2,fn1__$1,meta24674){
return (new cljs.core.async.t_cljs$core$async24673(f__$1,ch__$1,meta24671__$1,___$2,fn1__$1,meta24674));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async24673(self__.f,self__.ch,self__.meta24671,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__20243__auto__ = ret;
if(cljs.core.truth_(and__20243__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__20243__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24670.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async24670.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24671","meta24671",882284595,null)], null);
});

cljs.core.async.t_cljs$core$async24670.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24670.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24670";

cljs.core.async.t_cljs$core$async24670.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24670");
});

cljs.core.async.__GT_t_cljs$core$async24670 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24670(f__$1,ch__$1,meta24671){
return (new cljs.core.async.t_cljs$core$async24670(f__$1,ch__$1,meta24671));
});

}

return (new cljs.core.async.t_cljs$core$async24670(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async24679 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24679 = (function (f,ch,meta24680){
this.f = f;
this.ch = ch;
this.meta24680 = meta24680;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24681,meta24680__$1){
var self__ = this;
var _24681__$1 = this;
return (new cljs.core.async.t_cljs$core$async24679(self__.f,self__.ch,meta24680__$1));
});

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24681){
var self__ = this;
var _24681__$1 = this;
return self__.meta24680;
});

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24679.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async24679.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24680","meta24680",-1995128141,null)], null);
});

cljs.core.async.t_cljs$core$async24679.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24679.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24679";

cljs.core.async.t_cljs$core$async24679.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24679");
});

cljs.core.async.__GT_t_cljs$core$async24679 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async24679(f__$1,ch__$1,meta24680){
return (new cljs.core.async.t_cljs$core$async24679(f__$1,ch__$1,meta24680));
});

}

return (new cljs.core.async.t_cljs$core$async24679(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async24685 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24685 = (function (p,ch,meta24686){
this.p = p;
this.ch = ch;
this.meta24686 = meta24686;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24687,meta24686__$1){
var self__ = this;
var _24687__$1 = this;
return (new cljs.core.async.t_cljs$core$async24685(self__.p,self__.ch,meta24686__$1));
});

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24687){
var self__ = this;
var _24687__$1 = this;
return self__.meta24686;
});

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24685.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async24685.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24686","meta24686",-17171085,null)], null);
});

cljs.core.async.t_cljs$core$async24685.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24685.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24685";

cljs.core.async.t_cljs$core$async24685.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24685");
});

cljs.core.async.__GT_t_cljs$core$async24685 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async24685(p__$1,ch__$1,meta24686){
return (new cljs.core.async.t_cljs$core$async24685(p__$1,ch__$1,meta24686));
});

}

return (new cljs.core.async.t_cljs$core$async24685(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args24688 = [];
var len__21363__auto___24732 = arguments.length;
var i__21364__auto___24733 = (0);
while(true){
if((i__21364__auto___24733 < len__21363__auto___24732)){
args24688.push((arguments[i__21364__auto___24733]));

var G__24734 = (i__21364__auto___24733 + (1));
i__21364__auto___24733 = G__24734;
continue;
} else {
}
break;
}

var G__24690 = args24688.length;
switch (G__24690) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24688.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22460__auto___24736 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___24736,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___24736,out){
return (function (state_24711){
var state_val_24712 = (state_24711[(1)]);
if((state_val_24712 === (7))){
var inst_24707 = (state_24711[(2)]);
var state_24711__$1 = state_24711;
var statearr_24713_24737 = state_24711__$1;
(statearr_24713_24737[(2)] = inst_24707);

(statearr_24713_24737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (1))){
var state_24711__$1 = state_24711;
var statearr_24714_24738 = state_24711__$1;
(statearr_24714_24738[(2)] = null);

(statearr_24714_24738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (4))){
var inst_24693 = (state_24711[(7)]);
var inst_24693__$1 = (state_24711[(2)]);
var inst_24694 = (inst_24693__$1 == null);
var state_24711__$1 = (function (){var statearr_24715 = state_24711;
(statearr_24715[(7)] = inst_24693__$1);

return statearr_24715;
})();
if(cljs.core.truth_(inst_24694)){
var statearr_24716_24739 = state_24711__$1;
(statearr_24716_24739[(1)] = (5));

} else {
var statearr_24717_24740 = state_24711__$1;
(statearr_24717_24740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (6))){
var inst_24693 = (state_24711[(7)]);
var inst_24698 = p.call(null,inst_24693);
var state_24711__$1 = state_24711;
if(cljs.core.truth_(inst_24698)){
var statearr_24718_24741 = state_24711__$1;
(statearr_24718_24741[(1)] = (8));

} else {
var statearr_24719_24742 = state_24711__$1;
(statearr_24719_24742[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (3))){
var inst_24709 = (state_24711[(2)]);
var state_24711__$1 = state_24711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24711__$1,inst_24709);
} else {
if((state_val_24712 === (2))){
var state_24711__$1 = state_24711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24711__$1,(4),ch);
} else {
if((state_val_24712 === (11))){
var inst_24701 = (state_24711[(2)]);
var state_24711__$1 = state_24711;
var statearr_24720_24743 = state_24711__$1;
(statearr_24720_24743[(2)] = inst_24701);

(statearr_24720_24743[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (9))){
var state_24711__$1 = state_24711;
var statearr_24721_24744 = state_24711__$1;
(statearr_24721_24744[(2)] = null);

(statearr_24721_24744[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (5))){
var inst_24696 = cljs.core.async.close_BANG_.call(null,out);
var state_24711__$1 = state_24711;
var statearr_24722_24745 = state_24711__$1;
(statearr_24722_24745[(2)] = inst_24696);

(statearr_24722_24745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (10))){
var inst_24704 = (state_24711[(2)]);
var state_24711__$1 = (function (){var statearr_24723 = state_24711;
(statearr_24723[(8)] = inst_24704);

return statearr_24723;
})();
var statearr_24724_24746 = state_24711__$1;
(statearr_24724_24746[(2)] = null);

(statearr_24724_24746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24712 === (8))){
var inst_24693 = (state_24711[(7)]);
var state_24711__$1 = state_24711;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24711__$1,(11),out,inst_24693);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___24736,out))
;
return ((function (switch__22348__auto__,c__22460__auto___24736,out){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_24728 = [null,null,null,null,null,null,null,null,null];
(statearr_24728[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_24728[(1)] = (1));

return statearr_24728;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_24711){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24729){if((e24729 instanceof Object)){
var ex__22352__auto__ = e24729;
var statearr_24730_24747 = state_24711;
(statearr_24730_24747[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24711);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24729;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24748 = state_24711;
state_24711 = G__24748;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_24711){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_24711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___24736,out))
})();
var state__22462__auto__ = (function (){var statearr_24731 = f__22461__auto__.call(null);
(statearr_24731[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___24736);

return statearr_24731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___24736,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args24749 = [];
var len__21363__auto___24752 = arguments.length;
var i__21364__auto___24753 = (0);
while(true){
if((i__21364__auto___24753 < len__21363__auto___24752)){
args24749.push((arguments[i__21364__auto___24753]));

var G__24754 = (i__21364__auto___24753 + (1));
i__21364__auto___24753 = G__24754;
continue;
} else {
}
break;
}

var G__24751 = args24749.length;
switch (G__24751) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24749.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__22460__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto__){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto__){
return (function (state_24921){
var state_val_24922 = (state_24921[(1)]);
if((state_val_24922 === (7))){
var inst_24917 = (state_24921[(2)]);
var state_24921__$1 = state_24921;
var statearr_24923_24964 = state_24921__$1;
(statearr_24923_24964[(2)] = inst_24917);

(statearr_24923_24964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (20))){
var inst_24887 = (state_24921[(7)]);
var inst_24898 = (state_24921[(2)]);
var inst_24899 = cljs.core.next.call(null,inst_24887);
var inst_24873 = inst_24899;
var inst_24874 = null;
var inst_24875 = (0);
var inst_24876 = (0);
var state_24921__$1 = (function (){var statearr_24924 = state_24921;
(statearr_24924[(8)] = inst_24873);

(statearr_24924[(9)] = inst_24876);

(statearr_24924[(10)] = inst_24874);

(statearr_24924[(11)] = inst_24875);

(statearr_24924[(12)] = inst_24898);

return statearr_24924;
})();
var statearr_24925_24965 = state_24921__$1;
(statearr_24925_24965[(2)] = null);

(statearr_24925_24965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (1))){
var state_24921__$1 = state_24921;
var statearr_24926_24966 = state_24921__$1;
(statearr_24926_24966[(2)] = null);

(statearr_24926_24966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (4))){
var inst_24862 = (state_24921[(13)]);
var inst_24862__$1 = (state_24921[(2)]);
var inst_24863 = (inst_24862__$1 == null);
var state_24921__$1 = (function (){var statearr_24927 = state_24921;
(statearr_24927[(13)] = inst_24862__$1);

return statearr_24927;
})();
if(cljs.core.truth_(inst_24863)){
var statearr_24928_24967 = state_24921__$1;
(statearr_24928_24967[(1)] = (5));

} else {
var statearr_24929_24968 = state_24921__$1;
(statearr_24929_24968[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (15))){
var state_24921__$1 = state_24921;
var statearr_24933_24969 = state_24921__$1;
(statearr_24933_24969[(2)] = null);

(statearr_24933_24969[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (21))){
var state_24921__$1 = state_24921;
var statearr_24934_24970 = state_24921__$1;
(statearr_24934_24970[(2)] = null);

(statearr_24934_24970[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (13))){
var inst_24873 = (state_24921[(8)]);
var inst_24876 = (state_24921[(9)]);
var inst_24874 = (state_24921[(10)]);
var inst_24875 = (state_24921[(11)]);
var inst_24883 = (state_24921[(2)]);
var inst_24884 = (inst_24876 + (1));
var tmp24930 = inst_24873;
var tmp24931 = inst_24874;
var tmp24932 = inst_24875;
var inst_24873__$1 = tmp24930;
var inst_24874__$1 = tmp24931;
var inst_24875__$1 = tmp24932;
var inst_24876__$1 = inst_24884;
var state_24921__$1 = (function (){var statearr_24935 = state_24921;
(statearr_24935[(8)] = inst_24873__$1);

(statearr_24935[(9)] = inst_24876__$1);

(statearr_24935[(10)] = inst_24874__$1);

(statearr_24935[(11)] = inst_24875__$1);

(statearr_24935[(14)] = inst_24883);

return statearr_24935;
})();
var statearr_24936_24971 = state_24921__$1;
(statearr_24936_24971[(2)] = null);

(statearr_24936_24971[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (22))){
var state_24921__$1 = state_24921;
var statearr_24937_24972 = state_24921__$1;
(statearr_24937_24972[(2)] = null);

(statearr_24937_24972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (6))){
var inst_24862 = (state_24921[(13)]);
var inst_24871 = f.call(null,inst_24862);
var inst_24872 = cljs.core.seq.call(null,inst_24871);
var inst_24873 = inst_24872;
var inst_24874 = null;
var inst_24875 = (0);
var inst_24876 = (0);
var state_24921__$1 = (function (){var statearr_24938 = state_24921;
(statearr_24938[(8)] = inst_24873);

(statearr_24938[(9)] = inst_24876);

(statearr_24938[(10)] = inst_24874);

(statearr_24938[(11)] = inst_24875);

return statearr_24938;
})();
var statearr_24939_24973 = state_24921__$1;
(statearr_24939_24973[(2)] = null);

(statearr_24939_24973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (17))){
var inst_24887 = (state_24921[(7)]);
var inst_24891 = cljs.core.chunk_first.call(null,inst_24887);
var inst_24892 = cljs.core.chunk_rest.call(null,inst_24887);
var inst_24893 = cljs.core.count.call(null,inst_24891);
var inst_24873 = inst_24892;
var inst_24874 = inst_24891;
var inst_24875 = inst_24893;
var inst_24876 = (0);
var state_24921__$1 = (function (){var statearr_24940 = state_24921;
(statearr_24940[(8)] = inst_24873);

(statearr_24940[(9)] = inst_24876);

(statearr_24940[(10)] = inst_24874);

(statearr_24940[(11)] = inst_24875);

return statearr_24940;
})();
var statearr_24941_24974 = state_24921__$1;
(statearr_24941_24974[(2)] = null);

(statearr_24941_24974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (3))){
var inst_24919 = (state_24921[(2)]);
var state_24921__$1 = state_24921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24921__$1,inst_24919);
} else {
if((state_val_24922 === (12))){
var inst_24907 = (state_24921[(2)]);
var state_24921__$1 = state_24921;
var statearr_24942_24975 = state_24921__$1;
(statearr_24942_24975[(2)] = inst_24907);

(statearr_24942_24975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (2))){
var state_24921__$1 = state_24921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24921__$1,(4),in$);
} else {
if((state_val_24922 === (23))){
var inst_24915 = (state_24921[(2)]);
var state_24921__$1 = state_24921;
var statearr_24943_24976 = state_24921__$1;
(statearr_24943_24976[(2)] = inst_24915);

(statearr_24943_24976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (19))){
var inst_24902 = (state_24921[(2)]);
var state_24921__$1 = state_24921;
var statearr_24944_24977 = state_24921__$1;
(statearr_24944_24977[(2)] = inst_24902);

(statearr_24944_24977[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (11))){
var inst_24887 = (state_24921[(7)]);
var inst_24873 = (state_24921[(8)]);
var inst_24887__$1 = cljs.core.seq.call(null,inst_24873);
var state_24921__$1 = (function (){var statearr_24945 = state_24921;
(statearr_24945[(7)] = inst_24887__$1);

return statearr_24945;
})();
if(inst_24887__$1){
var statearr_24946_24978 = state_24921__$1;
(statearr_24946_24978[(1)] = (14));

} else {
var statearr_24947_24979 = state_24921__$1;
(statearr_24947_24979[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (9))){
var inst_24909 = (state_24921[(2)]);
var inst_24910 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_24921__$1 = (function (){var statearr_24948 = state_24921;
(statearr_24948[(15)] = inst_24909);

return statearr_24948;
})();
if(cljs.core.truth_(inst_24910)){
var statearr_24949_24980 = state_24921__$1;
(statearr_24949_24980[(1)] = (21));

} else {
var statearr_24950_24981 = state_24921__$1;
(statearr_24950_24981[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (5))){
var inst_24865 = cljs.core.async.close_BANG_.call(null,out);
var state_24921__$1 = state_24921;
var statearr_24951_24982 = state_24921__$1;
(statearr_24951_24982[(2)] = inst_24865);

(statearr_24951_24982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (14))){
var inst_24887 = (state_24921[(7)]);
var inst_24889 = cljs.core.chunked_seq_QMARK_.call(null,inst_24887);
var state_24921__$1 = state_24921;
if(inst_24889){
var statearr_24952_24983 = state_24921__$1;
(statearr_24952_24983[(1)] = (17));

} else {
var statearr_24953_24984 = state_24921__$1;
(statearr_24953_24984[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (16))){
var inst_24905 = (state_24921[(2)]);
var state_24921__$1 = state_24921;
var statearr_24954_24985 = state_24921__$1;
(statearr_24954_24985[(2)] = inst_24905);

(statearr_24954_24985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24922 === (10))){
var inst_24876 = (state_24921[(9)]);
var inst_24874 = (state_24921[(10)]);
var inst_24881 = cljs.core._nth.call(null,inst_24874,inst_24876);
var state_24921__$1 = state_24921;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24921__$1,(13),out,inst_24881);
} else {
if((state_val_24922 === (18))){
var inst_24887 = (state_24921[(7)]);
var inst_24896 = cljs.core.first.call(null,inst_24887);
var state_24921__$1 = state_24921;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24921__$1,(20),out,inst_24896);
} else {
if((state_val_24922 === (8))){
var inst_24876 = (state_24921[(9)]);
var inst_24875 = (state_24921[(11)]);
var inst_24878 = (inst_24876 < inst_24875);
var inst_24879 = inst_24878;
var state_24921__$1 = state_24921;
if(cljs.core.truth_(inst_24879)){
var statearr_24955_24986 = state_24921__$1;
(statearr_24955_24986[(1)] = (10));

} else {
var statearr_24956_24987 = state_24921__$1;
(statearr_24956_24987[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto__))
;
return ((function (switch__22348__auto__,c__22460__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__22349__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__22349__auto____0 = (function (){
var statearr_24960 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24960[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__22349__auto__);

(statearr_24960[(1)] = (1));

return statearr_24960;
});
var cljs$core$async$mapcat_STAR__$_state_machine__22349__auto____1 = (function (state_24921){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_24921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e24961){if((e24961 instanceof Object)){
var ex__22352__auto__ = e24961;
var statearr_24962_24988 = state_24921;
(statearr_24962_24988[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24921);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24961;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24989 = state_24921;
state_24921 = G__24989;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__22349__auto__ = function(state_24921){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__22349__auto____1.call(this,state_24921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__22349__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__22349__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto__))
})();
var state__22462__auto__ = (function (){var statearr_24963 = f__22461__auto__.call(null);
(statearr_24963[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto__);

return statearr_24963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto__))
);

return c__22460__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args24990 = [];
var len__21363__auto___24993 = arguments.length;
var i__21364__auto___24994 = (0);
while(true){
if((i__21364__auto___24994 < len__21363__auto___24993)){
args24990.push((arguments[i__21364__auto___24994]));

var G__24995 = (i__21364__auto___24994 + (1));
i__21364__auto___24994 = G__24995;
continue;
} else {
}
break;
}

var G__24992 = args24990.length;
switch (G__24992) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24990.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args24997 = [];
var len__21363__auto___25000 = arguments.length;
var i__21364__auto___25001 = (0);
while(true){
if((i__21364__auto___25001 < len__21363__auto___25000)){
args24997.push((arguments[i__21364__auto___25001]));

var G__25002 = (i__21364__auto___25001 + (1));
i__21364__auto___25001 = G__25002;
continue;
} else {
}
break;
}

var G__24999 = args24997.length;
switch (G__24999) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24997.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args25004 = [];
var len__21363__auto___25055 = arguments.length;
var i__21364__auto___25056 = (0);
while(true){
if((i__21364__auto___25056 < len__21363__auto___25055)){
args25004.push((arguments[i__21364__auto___25056]));

var G__25057 = (i__21364__auto___25056 + (1));
i__21364__auto___25056 = G__25057;
continue;
} else {
}
break;
}

var G__25006 = args25004.length;
switch (G__25006) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25004.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22460__auto___25059 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___25059,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___25059,out){
return (function (state_25030){
var state_val_25031 = (state_25030[(1)]);
if((state_val_25031 === (7))){
var inst_25025 = (state_25030[(2)]);
var state_25030__$1 = state_25030;
var statearr_25032_25060 = state_25030__$1;
(statearr_25032_25060[(2)] = inst_25025);

(statearr_25032_25060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (1))){
var inst_25007 = null;
var state_25030__$1 = (function (){var statearr_25033 = state_25030;
(statearr_25033[(7)] = inst_25007);

return statearr_25033;
})();
var statearr_25034_25061 = state_25030__$1;
(statearr_25034_25061[(2)] = null);

(statearr_25034_25061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (4))){
var inst_25010 = (state_25030[(8)]);
var inst_25010__$1 = (state_25030[(2)]);
var inst_25011 = (inst_25010__$1 == null);
var inst_25012 = cljs.core.not.call(null,inst_25011);
var state_25030__$1 = (function (){var statearr_25035 = state_25030;
(statearr_25035[(8)] = inst_25010__$1);

return statearr_25035;
})();
if(inst_25012){
var statearr_25036_25062 = state_25030__$1;
(statearr_25036_25062[(1)] = (5));

} else {
var statearr_25037_25063 = state_25030__$1;
(statearr_25037_25063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (6))){
var state_25030__$1 = state_25030;
var statearr_25038_25064 = state_25030__$1;
(statearr_25038_25064[(2)] = null);

(statearr_25038_25064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (3))){
var inst_25027 = (state_25030[(2)]);
var inst_25028 = cljs.core.async.close_BANG_.call(null,out);
var state_25030__$1 = (function (){var statearr_25039 = state_25030;
(statearr_25039[(9)] = inst_25027);

return statearr_25039;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25030__$1,inst_25028);
} else {
if((state_val_25031 === (2))){
var state_25030__$1 = state_25030;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25030__$1,(4),ch);
} else {
if((state_val_25031 === (11))){
var inst_25010 = (state_25030[(8)]);
var inst_25019 = (state_25030[(2)]);
var inst_25007 = inst_25010;
var state_25030__$1 = (function (){var statearr_25040 = state_25030;
(statearr_25040[(10)] = inst_25019);

(statearr_25040[(7)] = inst_25007);

return statearr_25040;
})();
var statearr_25041_25065 = state_25030__$1;
(statearr_25041_25065[(2)] = null);

(statearr_25041_25065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (9))){
var inst_25010 = (state_25030[(8)]);
var state_25030__$1 = state_25030;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25030__$1,(11),out,inst_25010);
} else {
if((state_val_25031 === (5))){
var inst_25010 = (state_25030[(8)]);
var inst_25007 = (state_25030[(7)]);
var inst_25014 = cljs.core._EQ_.call(null,inst_25010,inst_25007);
var state_25030__$1 = state_25030;
if(inst_25014){
var statearr_25043_25066 = state_25030__$1;
(statearr_25043_25066[(1)] = (8));

} else {
var statearr_25044_25067 = state_25030__$1;
(statearr_25044_25067[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (10))){
var inst_25022 = (state_25030[(2)]);
var state_25030__$1 = state_25030;
var statearr_25045_25068 = state_25030__$1;
(statearr_25045_25068[(2)] = inst_25022);

(statearr_25045_25068[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25031 === (8))){
var inst_25007 = (state_25030[(7)]);
var tmp25042 = inst_25007;
var inst_25007__$1 = tmp25042;
var state_25030__$1 = (function (){var statearr_25046 = state_25030;
(statearr_25046[(7)] = inst_25007__$1);

return statearr_25046;
})();
var statearr_25047_25069 = state_25030__$1;
(statearr_25047_25069[(2)] = null);

(statearr_25047_25069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___25059,out))
;
return ((function (switch__22348__auto__,c__22460__auto___25059,out){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_25051 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25051[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_25051[(1)] = (1));

return statearr_25051;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_25030){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_25030);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e25052){if((e25052 instanceof Object)){
var ex__22352__auto__ = e25052;
var statearr_25053_25070 = state_25030;
(statearr_25053_25070[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25030);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25052;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25071 = state_25030;
state_25030 = G__25071;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_25030){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_25030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___25059,out))
})();
var state__22462__auto__ = (function (){var statearr_25054 = f__22461__auto__.call(null);
(statearr_25054[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___25059);

return statearr_25054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___25059,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args25072 = [];
var len__21363__auto___25142 = arguments.length;
var i__21364__auto___25143 = (0);
while(true){
if((i__21364__auto___25143 < len__21363__auto___25142)){
args25072.push((arguments[i__21364__auto___25143]));

var G__25144 = (i__21364__auto___25143 + (1));
i__21364__auto___25143 = G__25144;
continue;
} else {
}
break;
}

var G__25074 = args25072.length;
switch (G__25074) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25072.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22460__auto___25146 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___25146,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___25146,out){
return (function (state_25112){
var state_val_25113 = (state_25112[(1)]);
if((state_val_25113 === (7))){
var inst_25108 = (state_25112[(2)]);
var state_25112__$1 = state_25112;
var statearr_25114_25147 = state_25112__$1;
(statearr_25114_25147[(2)] = inst_25108);

(statearr_25114_25147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (1))){
var inst_25075 = (new Array(n));
var inst_25076 = inst_25075;
var inst_25077 = (0);
var state_25112__$1 = (function (){var statearr_25115 = state_25112;
(statearr_25115[(7)] = inst_25076);

(statearr_25115[(8)] = inst_25077);

return statearr_25115;
})();
var statearr_25116_25148 = state_25112__$1;
(statearr_25116_25148[(2)] = null);

(statearr_25116_25148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (4))){
var inst_25080 = (state_25112[(9)]);
var inst_25080__$1 = (state_25112[(2)]);
var inst_25081 = (inst_25080__$1 == null);
var inst_25082 = cljs.core.not.call(null,inst_25081);
var state_25112__$1 = (function (){var statearr_25117 = state_25112;
(statearr_25117[(9)] = inst_25080__$1);

return statearr_25117;
})();
if(inst_25082){
var statearr_25118_25149 = state_25112__$1;
(statearr_25118_25149[(1)] = (5));

} else {
var statearr_25119_25150 = state_25112__$1;
(statearr_25119_25150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (15))){
var inst_25102 = (state_25112[(2)]);
var state_25112__$1 = state_25112;
var statearr_25120_25151 = state_25112__$1;
(statearr_25120_25151[(2)] = inst_25102);

(statearr_25120_25151[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (13))){
var state_25112__$1 = state_25112;
var statearr_25121_25152 = state_25112__$1;
(statearr_25121_25152[(2)] = null);

(statearr_25121_25152[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (6))){
var inst_25077 = (state_25112[(8)]);
var inst_25098 = (inst_25077 > (0));
var state_25112__$1 = state_25112;
if(cljs.core.truth_(inst_25098)){
var statearr_25122_25153 = state_25112__$1;
(statearr_25122_25153[(1)] = (12));

} else {
var statearr_25123_25154 = state_25112__$1;
(statearr_25123_25154[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (3))){
var inst_25110 = (state_25112[(2)]);
var state_25112__$1 = state_25112;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25112__$1,inst_25110);
} else {
if((state_val_25113 === (12))){
var inst_25076 = (state_25112[(7)]);
var inst_25100 = cljs.core.vec.call(null,inst_25076);
var state_25112__$1 = state_25112;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25112__$1,(15),out,inst_25100);
} else {
if((state_val_25113 === (2))){
var state_25112__$1 = state_25112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25112__$1,(4),ch);
} else {
if((state_val_25113 === (11))){
var inst_25092 = (state_25112[(2)]);
var inst_25093 = (new Array(n));
var inst_25076 = inst_25093;
var inst_25077 = (0);
var state_25112__$1 = (function (){var statearr_25124 = state_25112;
(statearr_25124[(10)] = inst_25092);

(statearr_25124[(7)] = inst_25076);

(statearr_25124[(8)] = inst_25077);

return statearr_25124;
})();
var statearr_25125_25155 = state_25112__$1;
(statearr_25125_25155[(2)] = null);

(statearr_25125_25155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (9))){
var inst_25076 = (state_25112[(7)]);
var inst_25090 = cljs.core.vec.call(null,inst_25076);
var state_25112__$1 = state_25112;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25112__$1,(11),out,inst_25090);
} else {
if((state_val_25113 === (5))){
var inst_25076 = (state_25112[(7)]);
var inst_25085 = (state_25112[(11)]);
var inst_25077 = (state_25112[(8)]);
var inst_25080 = (state_25112[(9)]);
var inst_25084 = (inst_25076[inst_25077] = inst_25080);
var inst_25085__$1 = (inst_25077 + (1));
var inst_25086 = (inst_25085__$1 < n);
var state_25112__$1 = (function (){var statearr_25126 = state_25112;
(statearr_25126[(12)] = inst_25084);

(statearr_25126[(11)] = inst_25085__$1);

return statearr_25126;
})();
if(cljs.core.truth_(inst_25086)){
var statearr_25127_25156 = state_25112__$1;
(statearr_25127_25156[(1)] = (8));

} else {
var statearr_25128_25157 = state_25112__$1;
(statearr_25128_25157[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (14))){
var inst_25105 = (state_25112[(2)]);
var inst_25106 = cljs.core.async.close_BANG_.call(null,out);
var state_25112__$1 = (function (){var statearr_25130 = state_25112;
(statearr_25130[(13)] = inst_25105);

return statearr_25130;
})();
var statearr_25131_25158 = state_25112__$1;
(statearr_25131_25158[(2)] = inst_25106);

(statearr_25131_25158[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (10))){
var inst_25096 = (state_25112[(2)]);
var state_25112__$1 = state_25112;
var statearr_25132_25159 = state_25112__$1;
(statearr_25132_25159[(2)] = inst_25096);

(statearr_25132_25159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25113 === (8))){
var inst_25076 = (state_25112[(7)]);
var inst_25085 = (state_25112[(11)]);
var tmp25129 = inst_25076;
var inst_25076__$1 = tmp25129;
var inst_25077 = inst_25085;
var state_25112__$1 = (function (){var statearr_25133 = state_25112;
(statearr_25133[(7)] = inst_25076__$1);

(statearr_25133[(8)] = inst_25077);

return statearr_25133;
})();
var statearr_25134_25160 = state_25112__$1;
(statearr_25134_25160[(2)] = null);

(statearr_25134_25160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___25146,out))
;
return ((function (switch__22348__auto__,c__22460__auto___25146,out){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_25138 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25138[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_25138[(1)] = (1));

return statearr_25138;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_25112){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_25112);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e25139){if((e25139 instanceof Object)){
var ex__22352__auto__ = e25139;
var statearr_25140_25161 = state_25112;
(statearr_25140_25161[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25112);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25139;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25162 = state_25112;
state_25112 = G__25162;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_25112){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_25112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___25146,out))
})();
var state__22462__auto__ = (function (){var statearr_25141 = f__22461__auto__.call(null);
(statearr_25141[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___25146);

return statearr_25141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___25146,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args25163 = [];
var len__21363__auto___25237 = arguments.length;
var i__21364__auto___25238 = (0);
while(true){
if((i__21364__auto___25238 < len__21363__auto___25237)){
args25163.push((arguments[i__21364__auto___25238]));

var G__25239 = (i__21364__auto___25238 + (1));
i__21364__auto___25238 = G__25239;
continue;
} else {
}
break;
}

var G__25165 = args25163.length;
switch (G__25165) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25163.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22460__auto___25241 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22460__auto___25241,out){
return (function (){
var f__22461__auto__ = (function (){var switch__22348__auto__ = ((function (c__22460__auto___25241,out){
return (function (state_25207){
var state_val_25208 = (state_25207[(1)]);
if((state_val_25208 === (7))){
var inst_25203 = (state_25207[(2)]);
var state_25207__$1 = state_25207;
var statearr_25209_25242 = state_25207__$1;
(statearr_25209_25242[(2)] = inst_25203);

(statearr_25209_25242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (1))){
var inst_25166 = [];
var inst_25167 = inst_25166;
var inst_25168 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25207__$1 = (function (){var statearr_25210 = state_25207;
(statearr_25210[(7)] = inst_25168);

(statearr_25210[(8)] = inst_25167);

return statearr_25210;
})();
var statearr_25211_25243 = state_25207__$1;
(statearr_25211_25243[(2)] = null);

(statearr_25211_25243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (4))){
var inst_25171 = (state_25207[(9)]);
var inst_25171__$1 = (state_25207[(2)]);
var inst_25172 = (inst_25171__$1 == null);
var inst_25173 = cljs.core.not.call(null,inst_25172);
var state_25207__$1 = (function (){var statearr_25212 = state_25207;
(statearr_25212[(9)] = inst_25171__$1);

return statearr_25212;
})();
if(inst_25173){
var statearr_25213_25244 = state_25207__$1;
(statearr_25213_25244[(1)] = (5));

} else {
var statearr_25214_25245 = state_25207__$1;
(statearr_25214_25245[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (15))){
var inst_25197 = (state_25207[(2)]);
var state_25207__$1 = state_25207;
var statearr_25215_25246 = state_25207__$1;
(statearr_25215_25246[(2)] = inst_25197);

(statearr_25215_25246[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (13))){
var state_25207__$1 = state_25207;
var statearr_25216_25247 = state_25207__$1;
(statearr_25216_25247[(2)] = null);

(statearr_25216_25247[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (6))){
var inst_25167 = (state_25207[(8)]);
var inst_25192 = inst_25167.length;
var inst_25193 = (inst_25192 > (0));
var state_25207__$1 = state_25207;
if(cljs.core.truth_(inst_25193)){
var statearr_25217_25248 = state_25207__$1;
(statearr_25217_25248[(1)] = (12));

} else {
var statearr_25218_25249 = state_25207__$1;
(statearr_25218_25249[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (3))){
var inst_25205 = (state_25207[(2)]);
var state_25207__$1 = state_25207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25207__$1,inst_25205);
} else {
if((state_val_25208 === (12))){
var inst_25167 = (state_25207[(8)]);
var inst_25195 = cljs.core.vec.call(null,inst_25167);
var state_25207__$1 = state_25207;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25207__$1,(15),out,inst_25195);
} else {
if((state_val_25208 === (2))){
var state_25207__$1 = state_25207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25207__$1,(4),ch);
} else {
if((state_val_25208 === (11))){
var inst_25171 = (state_25207[(9)]);
var inst_25175 = (state_25207[(10)]);
var inst_25185 = (state_25207[(2)]);
var inst_25186 = [];
var inst_25187 = inst_25186.push(inst_25171);
var inst_25167 = inst_25186;
var inst_25168 = inst_25175;
var state_25207__$1 = (function (){var statearr_25219 = state_25207;
(statearr_25219[(7)] = inst_25168);

(statearr_25219[(11)] = inst_25185);

(statearr_25219[(8)] = inst_25167);

(statearr_25219[(12)] = inst_25187);

return statearr_25219;
})();
var statearr_25220_25250 = state_25207__$1;
(statearr_25220_25250[(2)] = null);

(statearr_25220_25250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (9))){
var inst_25167 = (state_25207[(8)]);
var inst_25183 = cljs.core.vec.call(null,inst_25167);
var state_25207__$1 = state_25207;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25207__$1,(11),out,inst_25183);
} else {
if((state_val_25208 === (5))){
var inst_25171 = (state_25207[(9)]);
var inst_25168 = (state_25207[(7)]);
var inst_25175 = (state_25207[(10)]);
var inst_25175__$1 = f.call(null,inst_25171);
var inst_25176 = cljs.core._EQ_.call(null,inst_25175__$1,inst_25168);
var inst_25177 = cljs.core.keyword_identical_QMARK_.call(null,inst_25168,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_25178 = (inst_25176) || (inst_25177);
var state_25207__$1 = (function (){var statearr_25221 = state_25207;
(statearr_25221[(10)] = inst_25175__$1);

return statearr_25221;
})();
if(cljs.core.truth_(inst_25178)){
var statearr_25222_25251 = state_25207__$1;
(statearr_25222_25251[(1)] = (8));

} else {
var statearr_25223_25252 = state_25207__$1;
(statearr_25223_25252[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (14))){
var inst_25200 = (state_25207[(2)]);
var inst_25201 = cljs.core.async.close_BANG_.call(null,out);
var state_25207__$1 = (function (){var statearr_25225 = state_25207;
(statearr_25225[(13)] = inst_25200);

return statearr_25225;
})();
var statearr_25226_25253 = state_25207__$1;
(statearr_25226_25253[(2)] = inst_25201);

(statearr_25226_25253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (10))){
var inst_25190 = (state_25207[(2)]);
var state_25207__$1 = state_25207;
var statearr_25227_25254 = state_25207__$1;
(statearr_25227_25254[(2)] = inst_25190);

(statearr_25227_25254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25208 === (8))){
var inst_25171 = (state_25207[(9)]);
var inst_25175 = (state_25207[(10)]);
var inst_25167 = (state_25207[(8)]);
var inst_25180 = inst_25167.push(inst_25171);
var tmp25224 = inst_25167;
var inst_25167__$1 = tmp25224;
var inst_25168 = inst_25175;
var state_25207__$1 = (function (){var statearr_25228 = state_25207;
(statearr_25228[(7)] = inst_25168);

(statearr_25228[(8)] = inst_25167__$1);

(statearr_25228[(14)] = inst_25180);

return statearr_25228;
})();
var statearr_25229_25255 = state_25207__$1;
(statearr_25229_25255[(2)] = null);

(statearr_25229_25255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22460__auto___25241,out))
;
return ((function (switch__22348__auto__,c__22460__auto___25241,out){
return (function() {
var cljs$core$async$state_machine__22349__auto__ = null;
var cljs$core$async$state_machine__22349__auto____0 = (function (){
var statearr_25233 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25233[(0)] = cljs$core$async$state_machine__22349__auto__);

(statearr_25233[(1)] = (1));

return statearr_25233;
});
var cljs$core$async$state_machine__22349__auto____1 = (function (state_25207){
while(true){
var ret_value__22350__auto__ = (function (){try{while(true){
var result__22351__auto__ = switch__22348__auto__.call(null,state_25207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22351__auto__;
}
break;
}
}catch (e25234){if((e25234 instanceof Object)){
var ex__22352__auto__ = e25234;
var statearr_25235_25256 = state_25207;
(statearr_25235_25256[(5)] = ex__22352__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25207);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25234;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22350__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25257 = state_25207;
state_25207 = G__25257;
continue;
} else {
return ret_value__22350__auto__;
}
break;
}
});
cljs$core$async$state_machine__22349__auto__ = function(state_25207){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22349__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22349__auto____1.call(this,state_25207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22349__auto____0;
cljs$core$async$state_machine__22349__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22349__auto____1;
return cljs$core$async$state_machine__22349__auto__;
})()
;})(switch__22348__auto__,c__22460__auto___25241,out))
})();
var state__22462__auto__ = (function (){var statearr_25236 = f__22461__auto__.call(null);
(statearr_25236[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__22460__auto___25241);

return statearr_25236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22462__auto__);
});})(c__22460__auto___25241,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1508505829227