// Compiled by ClojureScript 1.9.671 {}
goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((function (){var and__26481__auto__ = typeof require !== 'undefined';
if(and__26481__auto__){
try{return require("ws");
}catch (e37389){var e = e37389;
return false;
}} else {
return and__26481__auto__;
}
})())){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js.call(null,opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__27625__auto__ = [];
var len__27618__auto___37501 = arguments.length;
var i__27619__auto___37502 = (0);
while(true){
if((i__27619__auto___37502 < len__27618__auto___37501)){
args__27625__auto__.push((arguments[i__27619__auto___37502]));

var G__37503 = (i__27619__auto___37502 + (1));
i__27619__auto___37502 = G__37503;
continue;
} else {
}
break;
}

var argseq__27626__auto__ = ((((1) < args__27625__auto__.length))?(new cljs.core.IndexedSeq(args__27625__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27626__auto__);
});

chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__37394){
var vec__37395 = p__37394;
var map__37398 = cljs.core.nth.call(null,vec__37395,(0),null);
var map__37398__$1 = ((((!((map__37398 == null)))?((((map__37398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37398.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37398):map__37398);
var opts = map__37398__$1;
var read_ch = cljs.core.get.call(null,map__37398__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.call(null,map__37398__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.call(null,map__37398__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.call(null,map__37398__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws.call(null,ws_url,ws_opts);
var map__37400 = chord.format.wrap_format.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__26493__auto__ = read_ch;
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__26493__auto__ = write_ch;
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})()], null),opts);
var map__37400__$1 = ((((!((map__37400 == null)))?((((map__37400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37400.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37400):map__37400);
var read_ch__$1 = cljs.core.get.call(null,map__37400__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.call(null,map__37400__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.call(null);
var close_ch = cljs.core.async.chan.call(null);
web_socket.binaryType = "arraybuffer";

chord.channels.read_from_ws_BANG_.call(null,web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_.call(null,web_socket,write_ch__$1);

web_socket.onopen = ((function (web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__37390_SHARP_){
return cljs.core.async.put_BANG_.call(null,open_ch,p1__37390_SHARP_);
});})(web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts))
;

web_socket.onclose = ((function (web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__37391_SHARP_){
return cljs.core.async.put_BANG_.call(null,close_ch,p1__37391_SHARP_);
});})(web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts))
;

var ws_chan = chord.channels.bidi_ch.call(null,read_ch__$1,write_ch__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
return web_socket.close();
});})(web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts))
], null));
var initial_ch = cljs.core.async.chan.call(null);
var c__32183__auto___37504 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___37504,ws_chan,initial_ch,web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___37504,ws_chan,initial_ch,web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (state_37467){
var state_val_37468 = (state_37467[(1)]);
if((state_val_37468 === (7))){
var inst_37463 = (state_37467[(2)]);
var state_37467__$1 = state_37467;
var statearr_37469_37505 = state_37467__$1;
(statearr_37469_37505[(2)] = inst_37463);

(statearr_37469_37505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (20))){
var state_37467__$1 = state_37467;
var statearr_37470_37506 = state_37467__$1;
(statearr_37470_37506[(2)] = null);

(statearr_37470_37506[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (1))){
var inst_37402 = false;
var state_37467__$1 = (function (){var statearr_37471 = state_37467;
(statearr_37471[(7)] = inst_37402);

return statearr_37471;
})();
var statearr_37472_37507 = state_37467__$1;
(statearr_37472_37507[(2)] = null);

(statearr_37472_37507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (4))){
var inst_37415 = (state_37467[(8)]);
var inst_37417 = (state_37467[(9)]);
var inst_37415__$1 = (state_37467[(2)]);
var inst_37416 = cljs.core.nth.call(null,inst_37415__$1,(0),null);
var inst_37417__$1 = cljs.core.nth.call(null,inst_37415__$1,(1),null);
var inst_37418 = cljs.core._EQ_.call(null,inst_37417__$1,open_ch);
var state_37467__$1 = (function (){var statearr_37473 = state_37467;
(statearr_37473[(8)] = inst_37415__$1);

(statearr_37473[(10)] = inst_37416);

(statearr_37473[(9)] = inst_37417__$1);

return statearr_37473;
})();
if(inst_37418){
var statearr_37474_37508 = state_37467__$1;
(statearr_37474_37508[(1)] = (5));

} else {
var statearr_37475_37509 = state_37467__$1;
(statearr_37475_37509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (15))){
var inst_37448 = (state_37467[(2)]);
var state_37467__$1 = state_37467;
var statearr_37476_37510 = state_37467__$1;
(statearr_37476_37510[(2)] = inst_37448);

(statearr_37476_37510[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (21))){
var inst_37459 = (state_37467[(2)]);
var state_37467__$1 = state_37467;
var statearr_37477_37511 = state_37467__$1;
(statearr_37477_37511[(2)] = inst_37459);

(statearr_37477_37511[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (13))){
var state_37467__$1 = state_37467;
var statearr_37478_37512 = state_37467__$1;
(statearr_37478_37512[(2)] = null);

(statearr_37478_37512[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (6))){
var inst_37417 = (state_37467[(9)]);
var inst_37432 = cljs.core._EQ_.call(null,inst_37417,close_ch);
var state_37467__$1 = state_37467;
if(inst_37432){
var statearr_37479_37513 = state_37467__$1;
(statearr_37479_37513[(1)] = (9));

} else {
var statearr_37480_37514 = state_37467__$1;
(statearr_37480_37514[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (17))){
var state_37467__$1 = state_37467;
var statearr_37481_37515 = state_37467__$1;
(statearr_37481_37515[(2)] = initial_ch);

(statearr_37481_37515[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (3))){
var inst_37465 = (state_37467[(2)]);
var state_37467__$1 = state_37467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37467__$1,inst_37465);
} else {
if((state_val_37468 === (12))){
var inst_37402 = (state_37467[(7)]);
var state_37467__$1 = state_37467;
if(cljs.core.truth_(inst_37402)){
var statearr_37482_37516 = state_37467__$1;
(statearr_37482_37516[(1)] = (16));

} else {
var statearr_37483_37517 = state_37467__$1;
(statearr_37483_37517[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (2))){
var inst_37411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37412 = [open_ch,close_ch];
var inst_37413 = (new cljs.core.PersistentVector(null,2,(5),inst_37411,inst_37412,null));
var state_37467__$1 = state_37467;
return cljs.core.async.ioc_alts_BANG_.call(null,state_37467__$1,(4),inst_37413);
} else {
if((state_val_37468 === (19))){
var inst_37416 = (state_37467[(10)]);
var state_37467__$1 = state_37467;
var statearr_37484_37518 = state_37467__$1;
(statearr_37484_37518[(2)] = inst_37416);

(statearr_37484_37518[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (11))){
var inst_37461 = (state_37467[(2)]);
var state_37467__$1 = state_37467;
var statearr_37485_37519 = state_37467__$1;
(statearr_37485_37519[(2)] = inst_37461);

(statearr_37485_37519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (9))){
var inst_37415 = (state_37467[(8)]);
var inst_37438 = (state_37467[(11)]);
var inst_37437 = cljs.core.nth.call(null,inst_37415,(0),null);
var inst_37438__$1 = chord.client.close_event__GT_maybe_error.call(null,inst_37437);
var state_37467__$1 = (function (){var statearr_37486 = state_37467;
(statearr_37486[(11)] = inst_37438__$1);

return statearr_37486;
})();
if(cljs.core.truth_(inst_37438__$1)){
var statearr_37487_37520 = state_37467__$1;
(statearr_37487_37520[(1)] = (12));

} else {
var statearr_37488_37521 = state_37467__$1;
(statearr_37488_37521[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (5))){
var inst_37415 = (state_37467[(8)]);
var inst_37423 = cljs.core.nth.call(null,inst_37415,(0),null);
var inst_37424 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_37425 = [ws_chan];
var inst_37426 = cljs.core.PersistentHashMap.fromArrays(inst_37424,inst_37425);
var state_37467__$1 = (function (){var statearr_37489 = state_37467;
(statearr_37489[(12)] = inst_37423);

return statearr_37489;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37467__$1,(8),initial_ch,inst_37426);
} else {
if((state_val_37468 === (14))){
var inst_37451 = (state_37467[(2)]);
var inst_37452 = cljs.core.async.close_BANG_.call(null,ws_chan);
var inst_37453 = cljs.core.async.close_BANG_.call(null,initial_ch);
var state_37467__$1 = (function (){var statearr_37490 = state_37467;
(statearr_37490[(13)] = inst_37451);

(statearr_37490[(14)] = inst_37452);

return statearr_37490;
})();
var statearr_37491_37522 = state_37467__$1;
(statearr_37491_37522[(2)] = inst_37453);

(statearr_37491_37522[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (16))){
var state_37467__$1 = state_37467;
var statearr_37492_37523 = state_37467__$1;
(statearr_37492_37523[(2)] = read_ch__$1);

(statearr_37492_37523[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (10))){
var inst_37417 = (state_37467[(9)]);
var inst_37455 = cljs.core._EQ_.call(null,inst_37417,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_37467__$1 = state_37467;
if(inst_37455){
var statearr_37493_37524 = state_37467__$1;
(statearr_37493_37524[(1)] = (19));

} else {
var statearr_37494_37525 = state_37467__$1;
(statearr_37494_37525[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37468 === (18))){
var inst_37438 = (state_37467[(11)]);
var inst_37443 = (state_37467[(2)]);
var inst_37444 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37445 = [inst_37438];
var inst_37446 = cljs.core.PersistentHashMap.fromArrays(inst_37444,inst_37445);
var state_37467__$1 = state_37467;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37467__$1,(15),inst_37443,inst_37446);
} else {
if((state_val_37468 === (8))){
var inst_37428 = (state_37467[(2)]);
var inst_37429 = cljs.core.async.close_BANG_.call(null,initial_ch);
var inst_37402 = true;
var state_37467__$1 = (function (){var statearr_37495 = state_37467;
(statearr_37495[(15)] = inst_37428);

(statearr_37495[(7)] = inst_37402);

(statearr_37495[(16)] = inst_37429);

return statearr_37495;
})();
var statearr_37496_37526 = state_37467__$1;
(statearr_37496_37526[(2)] = null);

(statearr_37496_37526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___37504,ws_chan,initial_ch,web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts))
;
return ((function (switch__32095__auto__,c__32183__auto___37504,ws_chan,initial_ch,web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts){
return (function() {
var chord$client$state_machine__32096__auto__ = null;
var chord$client$state_machine__32096__auto____0 = (function (){
var statearr_37497 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37497[(0)] = chord$client$state_machine__32096__auto__);

(statearr_37497[(1)] = (1));

return statearr_37497;
});
var chord$client$state_machine__32096__auto____1 = (function (state_37467){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_37467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e37498){if((e37498 instanceof Object)){
var ex__32099__auto__ = e37498;
var statearr_37499_37527 = state_37467;
(statearr_37499_37527[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37467);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37498;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37528 = state_37467;
state_37467 = G__37528;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
chord$client$state_machine__32096__auto__ = function(state_37467){
switch(arguments.length){
case 0:
return chord$client$state_machine__32096__auto____0.call(this);
case 1:
return chord$client$state_machine__32096__auto____1.call(this,state_37467);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
chord$client$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__32096__auto____0;
chord$client$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__32096__auto____1;
return chord$client$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___37504,ws_chan,initial_ch,web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts))
})();
var state__32185__auto__ = (function (){var statearr_37500 = f__32184__auto__.call(null);
(statearr_37500[(6)] = c__32183__auto___37504);

return statearr_37500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___37504,ws_chan,initial_ch,web_socket,map__37400,map__37400__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__37395,map__37398,map__37398__$1,opts,read_ch,write_ch,format,ws_opts))
);


return initial_ch;
});

chord.client.ws_ch.cljs$lang$maxFixedArity = (1);

chord.client.ws_ch.cljs$lang$applyTo = (function (seq37392){
var G__37393 = cljs.core.first.call(null,seq37392);
var seq37392__$1 = cljs.core.next.call(null,seq37392);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(G__37393,seq37392__$1);
});


//# sourceMappingURL=client.js.map?rel=1500131139578