/*
 * Decompiled with CFR 0.152.
 */
package langlab.jcore.detectors;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import langlab.jcore.characters.StringTools;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.UniversalDetector;

public final class EncodDetectorTools {
    public static final String UNKNOWN = "UNKNOWN";

    private EncodDetectorTools() {
    }

    public static List<String> getEncodAvailUnichardet() throws IllegalAccessException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Field field : Constants.class.getDeclaredFields()) {
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isFinal(n) || !Modifier.isStatic(n) || field.getType().getName() != "java.lang.String") continue;
            String string = field.get(Constants.class).toString();
            linkedList.add(string.toUpperCase());
        }
        return linkedList;
    }

    public static String detectEncodUnichardet(String string) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(string);
        UniversalDetector universalDetector = new UniversalDetector(null);
        while ((n = fileInputStream.read(byArray)) > 0 && !universalDetector.isDone()) {
            universalDetector.handleData(byArray, 0, n);
        }
        universalDetector.dataEnd();
        String string2 = universalDetector.getDetectedCharset();
        if (string2 == null) {
            string2 = UNKNOWN;
        }
        universalDetector.reset();
        return string2;
    }

    public static String detectLangICU(String string) throws UnsupportedEncodingException {
        CharsetDetector charsetDetector = new CharsetDetector();
        String string2 = StringTools.removeDiacritics(string);
        charsetDetector.setText(string2.getBytes("UTF-8"));
        charsetDetector.setDeclaredEncoding("UTF-8");
        CharsetMatch charsetMatch = charsetDetector.detect();
        String string3 = charsetMatch.getLanguage();
        if (string3 == null) {
            string3 = UNKNOWN;
        }
        return string3;
    }

    private static CharsetMatch getMatchForDetectEncodICU(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        CharsetDetector charsetDetector = new CharsetDetector();
        charsetDetector.setText((InputStream)bufferedInputStream);
        CharsetMatch charsetMatch = charsetDetector.detect();
        return charsetMatch;
    }

    public static String detectEncodICU(String string) throws IOException {
        CharsetMatch charsetMatch = EncodDetectorTools.getMatchForDetectEncodICU(string);
        String string2 = charsetMatch != null ? charsetMatch.getName().toUpperCase() : UNKNOWN;
        return string2;
    }

    public static Map<String, Double> detectEncodProbICU(String string) throws IOException {
        CharsetMatch charsetMatch = EncodDetectorTools.getMatchForDetectEncodICU(string);
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        if (charsetMatch != null) {
            String string2 = charsetMatch.getName().toUpperCase();
            double d = (double)charsetMatch.getConfidence() / 100.0;
            hashMap.put(string2, d);
        } else {
            hashMap.put(UNKNOWN, 1.0);
        }
        return hashMap;
    }

    public static Map<String, Double> detectAllEncodProbICU(String string) throws IOException {
        CharsetMatch[] charsetMatchArray;
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        CharsetDetector charsetDetector = new CharsetDetector();
        charsetDetector.setText((InputStream)bufferedInputStream);
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (CharsetMatch charsetMatch : charsetMatchArray = charsetDetector.detectAll()) {
            if (charsetMatch != null) {
                String string2 = charsetMatch.getName().toUpperCase();
                double d = (double)charsetMatch.getConfidence() / 100.0;
                hashMap.put(string2, d);
                continue;
            }
            hashMap.put(UNKNOWN, 1.0);
        }
        return hashMap;
    }
}

