/*
 * Decompiled with CFR 0.152.
 */
package langlab.jcore.characters;

import java.text.BreakIterator;
import java.text.Normalizer;
import java.util.Locale;
import langlab.jcore.characters.CharacterTools;

public final class StringTools {
    private StringTools() {
    }

    public static int countLatinVowelGroups(String string) {
        int n;
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (CharacterTools.isLatinVowel(n)) {
                if (bl) {
                    ++n2;
                }
                bl = false;
                continue;
            }
            bl = true;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public static int countLatinVowelGroupsWithoutFinal(String string) {
        int n;
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (CharacterTools.isLatinVowel(n)) {
                if (bl) {
                    ++n2;
                }
                bl = false;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public static String removeDiacritics(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replace("\u0142", "l").replace("\u0141", "L");
    }

    public static boolean containsPunct(String string) {
        int n;
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!CharacterTools.isPunctuation(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsPunctOnly(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (CharacterTools.isPunctuation(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsLetters(String string) {
        int n;
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!Character.isLetter(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsLettersOnly(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isLetter(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsDigits(String string) {
        int n;
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!Character.isDigit(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsDigitsOnly(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isDigit(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsLettersOrDigits(String string) {
        int n;
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!Character.isLetterOrDigit(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsLettersOrDigitsOnly(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isLetterOrDigit(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsWhitespace(String string) {
        int n;
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!Character.isWhitespace(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsWhitespaceOnly(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isWhitespace(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsNonBmp(String string) {
        int n;
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isBmpCodePoint(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String removeNonBmp(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!Character.isBmpCodePoint(n)) continue;
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder.toString();
    }

    public static String removeBmp(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isBmpCodePoint(n)) continue;
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder.toString();
    }

    public static int countCharactersBreakIterator(String string, Locale locale) {
        BreakIterator breakIterator = BreakIterator.getCharacterInstance(locale);
        breakIterator.setText(string);
        int n = 0;
        while (breakIterator.next() != -1) {
            ++n;
        }
        return n;
    }

    public static int countCharactersBreakIterator(String string, String string2) {
        Locale locale = new Locale(string2);
        return StringTools.countCharactersBreakIterator(string, locale);
    }

    public static int countCharactersICUBreakIterator(String string, Locale locale) {
        com.ibm.icu.text.BreakIterator breakIterator = com.ibm.icu.text.BreakIterator.getCharacterInstance((Locale)locale);
        breakIterator.setText(string);
        int n = 0;
        while (breakIterator.next() != -1) {
            ++n;
        }
        return n;
    }

    public static int countCharactersICUBreakIterator(String string, String string2) {
        Locale locale = new Locale(string2);
        return StringTools.countCharactersICUBreakIterator(string, locale);
    }
}

