(ns aws.ssm.client
  (:require [aws.auth :as auth]
            [aws.client]
            [aws.coerce.to-sdk :refer [->sdk]])
  (:import [software.amazon.awssdk.core.client.config ClientOverrideConfiguration]
           [software.amazon.awssdk.http SdkHttpClient]
           [software.amazon.awssdk.http.apache ApacheHttpClient]
           [software.amazon.awssdk.regions Region]
           [software.amazon.awssdk.services.ssm SsmClient]))

(defmethod ->sdk SsmClient [_ ssm-client]
  (let [{:keys [http-client
                credentials-provider
                endpoint-override
                override-configuration
                region]
         :or {credentials-provider (auth/default-credentials-provider)}} ssm-client]
    (.build
     (doto (SsmClient/builder)
       (.credentialsProvider credentials-provider)
       (cond-> http-client (.httpClient ^SdkHttpClient (->sdk ApacheHttpClient http-client)))
       (cond-> region (.region (->sdk Region region)))
       (cond-> endpoint-override (.endpointOverride endpoint-override))
       (cond-> override-configuration (.overrideConfiguration ^ClientOverrideConfiguration (->sdk ClientOverrideConfiguration override-configuration)))))))

(defn ^SsmClient create
  ([] (SsmClient/create))
  ([options]
   (->sdk SsmClient options)))
