(ns aws.ssm
  (:require [aws.coerce.to-clj :refer [->clj]]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.ssm.coercion]
            [aws.ssm.client :as client])
  (:import [software.amazon.awssdk.services.ssm SsmClient]
           [software.amazon.awssdk.services.ssm.model
            PutParameterRequest
            GetParametersByPathRequest
            GetParameterRequest
            GetParametersRequest]))

(defn get-parameter [^SsmClient client get-parameter-request]
  (->clj (.getParameter client ^GetParameterRequest (->sdk GetParameterRequest get-parameter-request))))

(defn get-parameters [^SsmClient client get-parameters-request]
  (->clj (.getParameters client ^GetParametersRequest (->sdk GetParametersRequest get-parameters-request))))

(defn get-parameters-by-path [^SsmClient client get-parameters-by-path-request]
  (->clj (.getParametersByPath client ^GetParametersByPathRequest (->sdk GetParametersByPathRequest get-parameters-by-path-request))))

(defn put-parameter [^SsmClient client put-parameter-request]
  (->clj (.putParameter client ^PutParameterRequest (->sdk PutParameterRequest put-parameter-request))))
