(ns aws.sdb.client
  (:require [aws.client]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.auth :as auth])
  (:import [software.amazon.awssdk.core.client.config ClientOverrideConfiguration]
           [software.amazon.awssdk.http SdkHttpClient]
           [software.amazon.awssdk.http.apache ApacheHttpClient]
           [software.amazon.awssdk.regions Region]
           [software.amazon.awssdk.services.simpledb SimpleDbClient]))

(defmethod ->sdk SimpleDbClient [_ simpledb-client]
  (let [{:keys [http-client
                credentials-provider
                endpoint-override
                override-configuration
                region]
         :or {credentials-provider (auth/default-credentials-provider)}} simpledb-client]
    (.build
     (doto (SimpleDbClient/builder)
       (.credentialsProvider credentials-provider)
       (cond-> http-client (.httpClient ^SdkHttpClient (->sdk ApacheHttpClient http-client)))
       (cond-> region (.region (->sdk Region region)))
       (cond-> endpoint-override (.endpointOverride endpoint-override))
       (cond-> override-configuration (.overrideConfiguration ^ClientOverrideConfiguration (->sdk ClientOverrideConfiguration override-configuration)))))))

(defn ^SimpleDbClient create
  ([] (SimpleDbClient/create))
  ([options]
   (->sdk SimpleDbClient options)))
