(ns aws.iam.coercion
  (:require [aws.coerce.to-clj :refer [->clj]]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.util :as u])
  (:import [software.amazon.awssdk.services.iam.model ListUsersRequest ListUsersResponse User]))

;; ----
;; to clojure
;;
;; ----

(extend-type User
  aws.coerce.to-clj/ToClojure
  (to-clj [user]
    (u/only-valid-values
     {:arn (.arn user)
      :create-date (.createDate user)
      :password-last-used (.passwordLastUsed user)
      :path (.path user)
      :user-id (.userId user)
      :user-name (.userName user)})))

(extend-type ListUsersResponse
  aws.coerce.to-clj/ToClojure
  (to-clj [response]
    (u/only-valid-values
     {:users (mapv (fn [user](->clj user)) (.users response))
      :is-truncated (.isTruncated response)
      :marker (.marker response)})))

;; ----
;; to sdk
;;
;; ---

(defmethod ->sdk ListUsersRequest [_ list-users-request]
  (let [{:keys [marker
                max-items
                path-prefix]
         :or {max-items 100}} list-users-request]
    (.build
     (doto (ListUsersRequest/builder)
       (.maxItems (int max-items))
       (cond-> marker (.marker marker)
               path-prefix (.pathPrefix path-prefix))))))
