(ns validations.example
  (:require [awohletz.validations :as v]))

(defn my-fn [args]
  (println (:hello args)))

(def validated-fn (v/with-validations my-fn
                                      (v/presence :hello)))

(v/valid? validated-fn {:hello "world"}
          (fn [valid-fn]
            (valid-fn))
          (fn [errors]
            (map (fn [{:keys [status reason]}]
                   (println status reason))
                 errors)))