# validations

Little library to do Rails-style validations on hashmaps passed to functions. It works slightly differently than the other Clojure validation libraries due to my requirement of using it with Liberator.

## Dependency Information

Add this to your dependencies in project.clj:

## Usage

    (require '[awohletz.validations :as v])
    
    ;The existing function we want to add validations to. We can only add validations
    ;to a function that accepts a single hashmap.
    (defn my-fn [args]
      (println (:hello args)))
    
    ;Make sure my-fn receives a :hello key in its map
    (def validated-fn (v/with-validations my-fn
                                          (v/presence :hello)))
    
    ;Call valid? on a function returned by with-validations to run the validations
    ;and get access to the underlying function.
    (v/valid? validated-fn {:hello "world"}
              ;Handler for success (no validation errors occurred). 
              ;Passed a function that runs the actual function with the given args, i.e. (my-fn {:hello "world"})
              (fn [valid-fn] 
                (valid-fn))
              ;Handler for validation failure. Passed the validation errors, which are ValidationResult records.
              ;ValidationResult has two fields: status and reason
              (fn [errors] 
                (map (fn [{:keys [status reason]}] 
                   (println status reason))
                 errors)))
                
    ;Prints "world"            


## License
Copyright  2015

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
