(ns clj-qobuz.track
  (:require [clj-qobuz.core :as core]
            [cheshire.core :as cheshire])
  (:refer-clojure :exclude [get]))

(defn get
  [track-id & [options]]
  (core/call-qobuz "track" "get" {:track_id track-id} options))

(defn file-url
  "Options can include `query-params` with keys:
  * `:format_id`"
  [track-id & [options]]
  (core/call-qobuz "track" "getFileUrl" {:track_id track-id} options))

(defn streaming-start
  "Notify Qobuz that a track has started streaming.
   Events must be a sequence of maps with the following keys:

   * `:user_id`
   * `:date`
   * `:duration`- must be 0
   * `:online`
   * `:intent` - streaming/import/download
   * `:sample`
   * `:device_id` - returned from the login call
   * `:track_id`
   * `:purchase`
   * `:local`
   * `:credential_id` - returned from the login call
   * `:format_id`"
  [events & [options]]
  (core/call-qobuz
   "track"
   "reportStreamingStart"
   {}
   (merge-with merge
               {:method       :post
                :form-params  events
                :content-type :json}
               options)))

(defn streaming-end
  "Notify Qobuz that a track has finished streaming.
  Events must be a sequence of maps with the following keys:

   * `:user_id`
   * `:date`
   * `:duration`
   * `:online`
   * `:intent` - streaming/import/download
   * `:sample`
   * `:device_id` - returned from the login call
   * `:track_id`
   * `:purchase`
   * `:local`
   * `:credential_id` - returned from the login call
   * `:format_id`"
  [events & [options]]
  (core/call-qobuz
   "track"
   "reportStreamingEnd"
   {}
   (merge-with merge
               {:method       :post
                :form-params  events
                :content-type :json}
               options)))
