(ns clj-qobuz.genre
  (:require [clj-qobuz.core :as core])
  (:refer-clojure :exclude [get list]))

(defn get
  "Get basic details of a genre"
  [genreid & [options]]
  (core/call-qobuz "genre" "get" {:genre_id genreid} options))

(defn list
  "List genres. By default list the root genres.
  `options` can contain `:query-params` with key `:parent_id` to get child genres of a genre."
  [& [options]]
  (core/call-qobuz "genre" "list" {} options))
