(defproject audiogum/clj-qobuz "0.1.6"
  :description "Library for interacting with Qobuz"

  :url "https://github.com/audiogum/clj-qobuz"

  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[cheshire "5.8.0"]
                 [clj-http "3.7.0"]
                 [com.cemerick/url "0.1.1" :exclusions [com.google.guava/guava
                                                        pathetic]]
                 [org.clojure/clojure "1.9.0"]
                 [org.clojure/tools.logging "0.4.0"]
                 [pathetic "0.5.1"]]

  :repositories [["releases" {:url "https://clojars.org/repo"
                              :creds :gpg}]]

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version" "patch"]
                  ["vcs" "commit"]
                  ["vcs" "push" "origin" "master"]]

  :exclusions [log4j org.clojure/clojure])
