(ns clj-qobuz.connect
  (:require [cemerick.url :as url]
            [clj-qobuz.core :as core]
            [clj-http.client :as http]))

;; See 'Qobuz Connect Specifications v1.0'

(defn authorization-url
  [redirect-url & [options]]
  (-> (url/url "https://www.qobuz.com/signin/oauth")
      (assoc :query {:ext_app_id (:app-id options core/*app-id*)
                     :redirect_url redirect-url})
      str))

(defn exchange-auth-code
  [code & [options]]
  (-> (http/get (-> (url/url (:endpoint options core/*endpoint*) "oauth" "callback")
                    (assoc :query {:code code
                                   :app_id (:app-id options core/*app-id*)
                                   :private_key (:app-private-key options core/*app-private-key*)})
                    str)
                {:as :json})
      :body))
