
(ns docker-connect.util
  (:require [clojure.java.io :as io]
            [clojure.pprint :refer [pprint]]
            [environ.core :refer [env]])
  (:import java.io.Reader
           java.util.Properties))


;; Pretty-print to a string for logging
(defn pps [form]
  (with-out-str (pprint form)))

(defn in-micros? []
  (contains? env :micros-service))

(defn in-dev? []
  (not (in-micros?)))


(defn ok? [response]
  (= 200 (response :status)))

(defn ok-or-nil [response]
  (if (ok? response)
    (response :body)
    nil))


(defn load-properties [filename]
  (with-open [^Reader reader (io/reader (io/resource filename))] 
    (let [props (Properties.)]
      (.load props reader)
      (into {} (for [[k v] props] [(keyword k) v])))))

(defonce project-meta (delay (-> (load-properties "META-INF/maven/atlassian/docker-connect/pom.properties")
                                 (#(assoc % :rev (subs (:revision %) 0 7)))))) ;; Short rev-hash
