(ns docker-connect.cache
  (:require [clojure.tools.logging :as log]
            [clj-time.format :as tf]
            [environ.core :refer [env]]
            [taoensso.carmine :as rd]
            [docker-connect.util :refer :all]))

(defonce redis-server (delay {:pool {}
                              :spec {:host (env :redis-cache-host)
                                     :port (read-string (env :redis-cache-port))}}))

(defonce default-ttl (* 60 45))

;; FIXME: Implement as clojure.cache?
(defn read-through
  ([key reader]
   (read-through key reader default-ttl))

  ([key reader ttl]
   (if-let [rtok (rd/wcar @redis-server (rd/get key))]
     (do
       (log/info "Cache hit for" key)
       rtok)

     ;; else
     (do 
       (log/info "Cache miss for" key "; fetching new value")

       (when-let [tok (reader)]
         (rd/wcar @redis-server (rd/set key tok :ex ttl))
         tok)))))
