/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.ClusterImageData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCluster
implements Comparable<PageCluster> {
    private static final int MERGE_VARIABILITY = 20;
    private static final int MAX_MERGE_PAGES = 15;
    private List<Integer> pagesToMerge;
    private final List<Integer> allPages;
    private final List<Float[]> cropRatiosList = new ArrayList<Float[]>();
    private boolean excluded = false;
    private ClusterImageData imageData;
    private final boolean evenPage;
    private final int pageWidth;
    private final int pageHeight;

    public PageCluster(boolean isEvenPage, int pageWidth, int pageHeight, boolean excluded, int pageNumber) {
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.evenPage = isEvenPage;
        this.excluded = excluded;
        this.pagesToMerge = new ArrayList<Integer>();
        this.allPages = new ArrayList<Integer>();
        this.allPages.add(pageNumber);
    }

    public final ClusterImageData getImageData() {
        if (this.imageData == null) {
            this.imageData = new ClusterImageData(this.pageWidth, this.pageHeight, this.pagesToMerge.size());
        }
        return this.imageData;
    }

    public final List<Float[]> getRatiosList() {
        return this.cropRatiosList;
    }

    public final void clearRatios() {
        this.cropRatiosList.clear();
    }

    public final void addRatios(Float[] ratios) {
        if (!this.cropRatiosList.contains(ratios)) {
            this.cropRatiosList.add(ratios);
        }
    }

    public final boolean isClusterNearlyEqual(PageCluster other) {
        if (this.evenPage != other.evenPage) {
            return false;
        }
        if (this.excluded || other.excluded) {
            return false;
        }
        if (this.getRoundedPageHeight() != other.getRoundedPageHeight()) {
            return false;
        }
        return this.getRoundedPageWidth() == other.getRoundedPageWidth();
    }

    public final void mergeClusters(PageCluster other) {
        this.allPages.addAll(other.getAllPages());
    }

    public final boolean isEvenPage() {
        return this.evenPage;
    }

    public final int getRoundedPageHeight() {
        int tmp = this.pageHeight / 20;
        return tmp * 20;
    }

    public final int getRoundedPageWidth() {
        int tmp = this.pageWidth / 20;
        return tmp * 20;
    }

    public final void choosePagesToMerge() {
        if (this.allPages.size() < 15) {
            this.pagesToMerge = this.allPages;
        } else {
            float stepWidth = (float)this.allPages.size() / 15.0f;
            float totalStepped = 0.0f;
            int i = 0;
            while (i < 15) {
                this.pagesToMerge.add(this.allPages.get(new Double(Math.floor(totalStepped)).intValue()));
                totalStepped += stepWidth;
                ++i;
            }
        }
    }

    public final List<Integer> getAllPages() {
        return this.allPages;
    }

    public final List<Integer> getPagesToMerge() {
        return this.pagesToMerge;
    }

    @Override
    public final int compareTo(PageCluster that) {
        return this.getFirstPage() - that.getFirstPage();
    }

    private int getFirstPage() {
        int small = Integer.MAX_VALUE;
        for (Integer tmp : this.allPages) {
            if (tmp >= small) continue;
            small = tmp;
        }
        return small;
    }
}

