/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.PageCluster;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class ClusterRenderWorker
extends Thread {
    public int workerUnitCounter = 1;
    private final File source;
    private final ClusterDefinition clusters;

    public ClusterRenderWorker(File source, ClusterDefinition clusters) {
        this.source = source;
        this.clusters = clusters;
    }

    @Override
    public void run() {
        PdfDecoder pdfDecoder = new PdfDecoder(true);
        try {
            pdfDecoder.openPdfFile(this.source.getAbsolutePath());
        }
        catch (PdfException e1) {
            e1.printStackTrace();
        }
        for (PageCluster cluster : this.clusters.getClusterList()) {
            for (Integer pageNumber : cluster.getPagesToMerge()) {
                try {
                    if (!cluster.getImageData().isRenderable()) continue;
                    BufferedImage renderedPage = pdfDecoder.getPageAsImage(pageNumber.intValue());
                    cluster.getImageData().addImageToPreview(renderedPage);
                    ++this.workerUnitCounter;
                }
                catch (PdfException e) {
                    e.printStackTrace();
                }
            }
        }
        pdfDecoder.closePdfFile();
    }
}

