/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.PageCluster;
import at.laborg.briss.model.PageExcludes;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.IOException;

public class ClusterCreator {
    public static ClusterDefinition clusterPages(File source, PageExcludes pageExcludes) throws IOException {
        PdfReader reader = new PdfReader(source.getAbsolutePath());
        ClusterDefinition clusters = new ClusterDefinition();
        int page = 1;
        while (page <= reader.getNumberOfPages()) {
            Rectangle layoutBox = ClusterCreator.getLayoutBox(reader, page);
            boolean excluded = ClusterCreator.checkExclusionAndGetPageNumber(pageExcludes, page);
            PageCluster tmpCluster = new PageCluster(page % 2 == 0, (int)layoutBox.getWidth(), (int)layoutBox.getHeight(), excluded, page);
            clusters.addOrMergeCluster(tmpCluster);
            ++page;
        }
        reader.close();
        clusters.selectAndSetPagesForMerging();
        return clusters;
    }

    private static Rectangle getLayoutBox(PdfReader reader, int page) {
        Rectangle layoutBox = reader.getBoxSize(page, "crop");
        if (layoutBox == null) {
            layoutBox = reader.getBoxSize(page, "media");
        }
        return layoutBox;
    }

    private static boolean checkExclusionAndGetPageNumber(PageExcludes pageExcludes, int page) {
        return pageExcludes != null && pageExcludes.containsPage(page);
    }
}

