/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.PageCluster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CropDefinition {
    private final File sourceFile;
    private final File destinationFile;
    private final Map<Integer, List<Float[]>> pageToCropRectangles;

    private CropDefinition(File source, File destination, HashMap<Integer, List<Float[]>> pageToCropRectangles) {
        this.sourceFile = source;
        this.destinationFile = destination;
        this.pageToCropRectangles = pageToCropRectangles;
    }

    public static CropDefinition createCropDefinition(File source, File destination, ClusterDefinition clusters) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Source must be provided");
        }
        if (!source.exists()) {
            throw new IllegalArgumentException("Source(" + source.getAbsolutePath() + ") file doesn't exist");
        }
        HashMap<Integer, List<Float[]>> pagesToCrops = new HashMap<Integer, List<Float[]>>();
        for (PageCluster cluster : clusters.getClusterList()) {
            for (Integer pageNumber : cluster.getAllPages()) {
                List<Float[]> cropRectangles = pagesToCrops.get(pageNumber);
                if (cropRectangles == null) {
                    cropRectangles = new ArrayList<Float[]>();
                }
                cropRectangles.addAll(cluster.getRatiosList());
                pagesToCrops.put(pageNumber, cropRectangles);
            }
        }
        CropDefinition result = new CropDefinition(source, destination, pagesToCrops);
        return result;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public List<Float[]> getRectanglesForPage(Integer page) {
        if (this.pageToCropRectangles.containsKey(page)) {
            return this.pageToCropRectangles.get(page);
        }
        return Collections.emptyList();
    }
}

