/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ClusterImageData {
    private static final int MAX_PAGE_HEIGHT = 900;
    private static final int MAX_IMAGE_RENDER_SIZE = 4000000;
    private final boolean renderable;
    private BufferedImage outputImage = null;
    private int outputImageHeight = -1;
    private int outputImageWidth = -1;
    private short[][][] imgdata;
    private int imageCnt = 0;
    private final int totalImages;

    public ClusterImageData(int pageWidth, int pageHeight, int nrOfImages) {
        this.renderable = pageWidth * pageHeight < 4000000;
        this.totalImages = nrOfImages;
    }

    public boolean isRenderable() {
        return this.renderable;
    }

    public void addImageToPreview(BufferedImage imageToAdd) {
        if (!this.renderable) {
            return;
        }
        if (this.outputImageHeight == -1) {
            this.initializeOutputImage(imageToAdd);
        }
        this.add(ClusterImageData.scaleImage(imageToAdd, this.outputImageWidth, this.outputImageHeight));
    }

    private void initializeOutputImage(BufferedImage imageToAdd) {
        this.outputImageHeight = imageToAdd.getHeight() > 900 ? 900 : imageToAdd.getHeight();
        float scaleFactor = (float)this.outputImageHeight / (float)imageToAdd.getHeight();
        this.outputImageWidth = (int)((float)imageToAdd.getWidth() * scaleFactor);
        this.imgdata = new short[this.outputImageWidth][this.outputImageHeight][this.totalImages];
    }

    private void add(BufferedImage image) {
        int[] tmp = null;
        int height = image.getHeight();
        int width = image.getWidth();
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                this.imgdata[i][j][this.imageCnt] = (short)image.getRaster().getPixel(i, j, tmp)[0];
                ++j;
            }
            ++i;
        }
        ++this.imageCnt;
    }

    public BufferedImage getPreviewImage() {
        if (!this.renderable) {
            return ClusterImageData.getUnrenderableImage();
        }
        if (this.outputImage == null) {
            this.outputImage = this.renderOutputImage();
            this.imgdata = null;
        }
        return this.outputImage;
    }

    private BufferedImage renderOutputImage() {
        BufferedImage outputImage = new BufferedImage(this.outputImageWidth, this.outputImageHeight, 10);
        WritableRaster raster = outputImage.getRaster().createCompatibleWritableRaster();
        if (this.totalImages == 1) {
            int i = 0;
            while (i < outputImage.getWidth()) {
                int j = 0;
                while (j < outputImage.getHeight()) {
                    raster.setSample(i, j, 0, this.imgdata[i][j][0]);
                    ++j;
                }
                ++i;
            }
            outputImage.setData(raster);
            return outputImage;
        }
        int[][] sdvalue = ClusterImageData.calculateSdOfImages(this.imgdata, this.imageCnt);
        int i = 0;
        while (i < outputImage.getWidth()) {
            int j = 0;
            while (j < outputImage.getHeight()) {
                raster.setSample(i, j, 0, sdvalue[i][j]);
                ++j;
            }
            ++i;
        }
        outputImage.setData(raster);
        return outputImage;
    }

    private static BufferedImage scaleImage(BufferedImage bsrc, int width, int height) {
        BufferedImage bdest = new BufferedImage(width, height, 10);
        Graphics2D g = bdest.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance((double)bdest.getWidth() / (double)bsrc.getWidth(), (double)bdest.getHeight() / (double)bsrc.getHeight());
        g.drawRenderedImage(bsrc, at);
        g.dispose();
        return bdest;
    }

    private static BufferedImage getUnrenderableImage() {
        int width = 200;
        int height = 200;
        BufferedImage bimage = new BufferedImage(width, height, 1);
        Graphics2D g2d = bimage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.drawRect(5, 5, 190, 190);
        Font font = new Font("Sansserif", 1, 22);
        g2d.setFont(font);
        g2d.setColor(Color.WHITE);
        g2d.drawString("Image to Big!", 10, 110);
        g2d.dispose();
        return bimage;
    }

    private static int[][] calculateSdOfImages(short[][][] imgdata, int imageCnt) {
        int k;
        int j;
        int width = imgdata.length;
        int height = imgdata[0].length;
        int[][] sum = new int[width][height];
        int[][] mean = new int[width][height];
        int[][] sd = new int[width][height];
        int i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                k = 0;
                while (k < imageCnt) {
                    int[] nArray = sum[i];
                    int n = j;
                    nArray[n] = nArray[n] + imgdata[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                mean[i][j] = sum[i][j] / imageCnt;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                sum[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                k = 0;
                while (k < imageCnt) {
                    int[] nArray = sum[i];
                    int n = j;
                    nArray[n] = nArray[n] + (imgdata[i][j][k] - mean[i][j]) * (imgdata[i][j][k] - mean[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                sd[i][j] = 255 - (int)Math.sqrt(sum[i][j] / imageCnt);
                ++j;
            }
            ++i;
        }
        return sd;
    }
}

