/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.PageCluster;
import java.util.ArrayList;
import java.util.List;

public class ClusterDefinition {
    private final List<PageCluster> clusters = new ArrayList<PageCluster>();

    public PageCluster getSingleCluster(int pageNumber) {
        for (PageCluster cluster : this.clusters) {
            if (!cluster.getAllPages().contains(pageNumber)) continue;
            return cluster;
        }
        return null;
    }

    public List<PageCluster> getClusterList() {
        return this.clusters;
    }

    public void addOrMergeCluster(PageCluster tmpCluster) {
        PageCluster existingCluster = this.findNearlyEqualCluster(tmpCluster);
        if (existingCluster != null) {
            existingCluster.mergeClusters(tmpCluster);
        } else {
            this.clusters.add(tmpCluster);
        }
    }

    private PageCluster findNearlyEqualCluster(PageCluster clusterToCheck) {
        for (PageCluster cluster : this.clusters) {
            if (!cluster.isClusterNearlyEqual(clusterToCheck)) continue;
            return cluster;
        }
        return null;
    }

    public void selectAndSetPagesForMerging() {
        for (PageCluster cluster : this.clusters) {
            cluster.choosePagesToMerge();
        }
    }

    public int getNrOfPagesToRender() {
        int size = 0;
        for (PageCluster cluster : this.clusters) {
            size += cluster.getPagesToMerge().size();
        }
        return size;
    }
}

