/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.postgresql;

import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlQueryBuilder;

public class PgSqlQueryBuilder
extends SqlQueryBuilder {
    public PgSqlQueryBuilder(QueryBuilderFactory factory) {
        super(factory);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        if (this.select.isEmpty()) {
            sb.append("*");
        } else {
            sb.append(this.select.toSql());
        }
        if (this.from != null) {
            sb.append("\nFROM ").append(this.from.getFromClause());
            if (!this.from.on().isEmpty()) {
                sb.append("\nWHERE ");
                sb.append(this.from.on().toSql());
            }
        }
        sb.append((CharSequence)this.group);
        if (this.union != null && !this.union.isEmpty()) {
            sb.append("\nUNION ALL ");
            sb.append(this.union.toString());
        }
        if (!this.order.isEmpty()) {
            sb.append("\nORDER BY ").append(this.order.toSql());
        }
        if (this.limit != null) {
            if (Long.MAX_VALUE == this.limit) {
                sb.append("\nLIMIT ALL");
            } else {
                sb.append("\nLIMIT ").append(this.limit);
            }
        }
        if (this.offset != null) {
            sb.append("\nOFFSET ").append(this.offset);
        }
        return sb.toString();
    }
}

