/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.BNode;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.BNodeColumn;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

public class BNodeExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    protected SqlExpr result;

    public SqlExpr createBNodeExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit(this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    @Override
    public void meet(Datatype node) {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(Lang node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(MathExpr node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(Str node) {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(ValueConstant vc) {
        this.result = this.valueOf(vc.getValue());
    }

    @Override
    public void meet(Var var) {
        this.result = var.getValue() == null ? new BNodeColumn(var) : this.valueOf(var.getValue());
    }

    @Override
    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        throw SqlExprSupport.unsupported(arg);
    }

    private SqlExpr valueOf(Value value) {
        if (value instanceof BNode) {
            return SqlExprSupport.str(((BNode)value).stringValue());
        }
        return SqlExprSupport.sqlNull();
    }
}

