/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import org.openrdf.query.algebra.Compare;
import org.openrdf.sail.rdbms.algebra.base.BinarySqlOperator;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

public class SqlCompare
extends BinarySqlOperator {
    private Operator op;

    public SqlCompare(SqlExpr leftArg, Compare.CompareOp op, SqlExpr rightArg) {
        super(leftArg, rightArg);
        switch (op) {
            case GT: {
                this.op = Operator.GT;
                break;
            }
            case LT: {
                this.op = Operator.LT;
                break;
            }
            case GE: {
                this.op = Operator.GE;
                break;
            }
            case LE: {
                this.op = Operator.LE;
                break;
            }
            default: {
                throw new AssertionError((Object)op);
            }
        }
    }

    public Operator getOperator() {
        return this.op;
    }

    @Override
    public String getSignature() {
        return super.getSignature() + " (" + (Object)((Object)this.op) + ")";
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlCompare other = (SqlCompare)obj;
        return !(this.op == null ? other.op != null : !this.op.equals((Object)other.op));
    }

    public static enum Operator {
        GT,
        LT,
        GE,
        LE;

    }
}

