/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.builder;

import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.queryrender.builder.Group;
import org.openrdf.queryrender.builder.GroupBuilder;
import org.openrdf.queryrender.builder.SupportsGroups;

public class UnionBuilder<T extends ParsedQuery, E extends SupportsGroups>
implements SupportsGroups<UnionBuilder<T, E>>,
Group {
    private Group mLeft;
    private Group mRight;
    private GroupBuilder<T, E> mParent;

    public UnionBuilder(GroupBuilder<T, E> theParent) {
        this.mParent = theParent;
    }

    public GroupBuilder<T, UnionBuilder<T, E>> left() {
        return new GroupBuilder(this);
    }

    public GroupBuilder<T, UnionBuilder<T, E>> right() {
        return new GroupBuilder(this);
    }

    public GroupBuilder<T, E> closeUnion() {
        return this.mParent;
    }

    @Override
    public int size() {
        return (this.mLeft == null ? 0 : this.mLeft.size()) + (this.mRight == null ? 0 : this.mRight.size());
    }

    @Override
    public UnionBuilder<T, E> addGroup(Group theGroup) {
        if (this.mLeft == null) {
            this.mLeft = theGroup;
        } else if (this.mRight == null) {
            this.mRight = theGroup;
        } else {
            throw new IllegalArgumentException("Cannot set left or right arguments of union, both already set");
        }
        return this;
    }

    @Override
    public UnionBuilder<T, E> removeGroup(Group theGroup) {
        if (this.mLeft != null && this.mLeft.equals(theGroup)) {
            this.mLeft = null;
        } else if (this.mRight != null && this.mRight.equals(theGroup)) {
            this.mRight = null;
        }
        return this;
    }

    @Override
    public void addChild(Group theGroup) {
        this.addGroup(theGroup);
    }

    @Override
    public TupleExpr expr() {
        if (this.mLeft != null && this.mRight != null) {
            return new Union(this.mLeft.expr(), this.mRight.expr());
        }
        if (this.mLeft != null && this.mRight == null) {
            return this.mLeft.expr();
        }
        if (this.mRight != null && this.mLeft == null) {
            return this.mRight.expr();
        }
        return null;
    }

    @Override
    public boolean isOptional() {
        return false;
    }
}

