/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceManager;
import org.openrdf.query.algebra.evaluation.federation.JoinExecutorBase;

public class ServiceJoinIterator
extends JoinExecutorBase<BindingSet> {
    protected Service service;
    protected EvaluationStrategy strategy;

    public ServiceJoinIterator(CloseableIteration<BindingSet, QueryEvaluationException> leftIter, Service service, BindingSet bindings, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(leftIter, service, bindings);
        this.service = service;
        this.strategy = strategy;
        this.run();
    }

    @Override
    protected void handleBindings() throws Exception {
        Var serviceRef = this.service.getServiceRef();
        if (!serviceRef.hasValue()) {
            while (!this.closed && this.leftIter.hasNext()) {
                this.addResult(this.strategy.evaluate(this.service, (BindingSet)this.leftIter.next()));
            }
            return;
        }
        String serviceUri = serviceRef.getValue().stringValue();
        FederatedService fs = FederatedServiceManager.getInstance().getService(serviceUri);
        this.addResult(fs.evaluate(this.service, this.leftIter, this.service.getBaseURI()));
    }
}

