/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import info.aduna.iteration.Iterations;
import info.aduna.text.StringUtil;
import java.util.Collection;
import java.util.List;
import org.openrdf.console.ConsoleIO;
import org.openrdf.console.ConsoleParameters;
import org.openrdf.console.ConsoleState;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class TupleAndGraphQueryEvaluator {
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final ConsoleParameters parameters;
    private static final ParserConfig nonVerifyingParserConfig = new ParserConfig();

    TupleAndGraphQueryEvaluator(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateTupleQuery(QueryLanguage queryLn, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        RepositoryConnection con = repository.getConnection();
        try {
            this.consoleIO.writeln("Evaluating query...");
            long startTime = System.nanoTime();
            TupleQueryResult tupleQueryResult = con.prepareTupleQuery(queryLn, queryString).evaluate();
            try {
                int resultCount = 0;
                List<String> bindingNames = tupleQueryResult.getBindingNames();
                if (bindingNames.isEmpty()) {
                    while (tupleQueryResult.hasNext()) {
                        tupleQueryResult.next();
                        ++resultCount;
                    }
                } else {
                    int consoleWidth = this.parameters.getWidth();
                    int columnWidth = (consoleWidth - 1) / bindingNames.size() - 3;
                    StringBuilder builder = new StringBuilder(consoleWidth);
                    for (String bindingName : bindingNames) {
                        builder.append("| ").append(bindingName);
                        StringUtil.appendN(' ', columnWidth - bindingName.length(), builder);
                    }
                    builder.append("|");
                    String header = builder.toString();
                    builder.setLength(0);
                    for (int i = bindingNames.size(); i > 0; --i) {
                        builder.append('+');
                        StringUtil.appendN('-', columnWidth + 1, builder);
                    }
                    builder.append('+');
                    String separatorLine = builder.toString();
                    this.consoleIO.writeln(separatorLine);
                    this.consoleIO.writeln(header);
                    this.consoleIO.writeln(separatorLine);
                    List<Namespace> namespaces = Iterations.asList(con.getNamespaces());
                    while (tupleQueryResult.hasNext()) {
                        BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                        ++resultCount;
                        builder.setLength(0);
                        for (String bindingName : bindingNames) {
                            Value value = bindingSet.getValue(bindingName);
                            String valueStr = this.getStringRepForValue(value, namespaces);
                            builder.append("| ").append(valueStr);
                            StringUtil.appendN(' ', columnWidth - valueStr.length(), builder);
                        }
                        builder.append("|");
                        this.consoleIO.writeln(builder.toString());
                    }
                    this.consoleIO.writeln(separatorLine);
                }
                long endTime = System.nanoTime();
                this.consoleIO.writeln(resultCount + " result(s) (" + (endTime - startTime) / 1000000L + " ms)");
            }
            finally {
                tupleQueryResult.close();
            }
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateGraphQuery(QueryLanguage queryLn, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        RepositoryConnection con = repository.getConnection();
        con.setParserConfig(nonVerifyingParserConfig);
        try {
            this.consoleIO.writeln("Evaluating query...");
            long startTime = System.nanoTime();
            List<Namespace> namespaces = Iterations.asList(con.getNamespaces());
            GraphQueryResult queryResult = con.prepareGraphQuery(queryLn, queryString).evaluate();
            try {
                int resultCount = 0;
                while (queryResult.hasNext()) {
                    Statement statement = (Statement)queryResult.next();
                    ++resultCount;
                    this.consoleIO.write(this.getStringRepForValue(statement.getSubject(), namespaces));
                    this.consoleIO.write("   ");
                    this.consoleIO.write(this.getStringRepForValue(statement.getPredicate(), namespaces));
                    this.consoleIO.write("   ");
                    this.consoleIO.write(this.getStringRepForValue(statement.getObject(), namespaces));
                    this.consoleIO.writeln();
                }
                long endTime = System.nanoTime();
                this.consoleIO.writeln(resultCount + " results (" + (endTime - startTime) / 1000000L + " ms)");
            }
            finally {
                queryResult.close();
            }
        }
        finally {
            con.close();
        }
    }

    private String getStringRepForValue(Value value, Collection<Namespace> namespaces) {
        String result = "";
        if (value != null) {
            URI uri;
            String prefix;
            result = this.parameters.isShowPrefix() && value instanceof URI ? ((prefix = this.getPrefixForNamespace((uri = (URI)value).getNamespace(), namespaces)) == null ? NTriplesUtil.toNTriplesString(value) : prefix + ":" + uri.getLocalName()) : NTriplesUtil.toNTriplesString(value);
        }
        return result;
    }

    private String getPrefixForNamespace(String namespace, Collection<Namespace> namespaces) {
        String result = null;
        for (Namespace ns : namespaces) {
            if (!namespace.equals(ns.getName())) continue;
            result = ns.getPrefix();
            break;
        }
        return result;
    }

    static {
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, false);
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_LANGUAGE_TAGS, false);
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, false);
    }
}

