/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import info.aduna.iteration.Iterations;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.openrdf.console.ConsoleIO;
import org.openrdf.console.ConsoleParameters;
import org.openrdf.console.ConsoleState;
import org.openrdf.console.TupleAndGraphQueryEvaluator;
import org.openrdf.model.Namespace;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedOperation;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.query.parser.serql.SeRQLUtil;
import org.openrdf.query.parser.sparql.SPARQLUtil;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryEvaluator.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final ConsoleParameters parameters;
    private final TupleAndGraphQueryEvaluator tg_eval;

    QueryEvaluator(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.parameters = parameters;
        this.tg_eval = new TupleAndGraphQueryEvaluator(consoleIO, state, parameters);
    }

    public void executeQuery(String command, String operation) {
        if ("select".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command);
        } else if ("construct".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command);
        } else if ("serql".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command.substring("serql".length()));
        } else if ("sparql".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SPARQL, command.substring("sparql".length()));
        } else {
            this.consoleIO.writeError("Unknown command");
        }
    }

    private void evaluateQuery(QueryLanguage queryLn, String queryText) {
        try {
            String queryString = this.addQueryPrefixes(queryLn, queryText);
            ParsedOperation query = QueryParserUtil.parseOperation(queryLn, queryString, null);
            this.evaluateQuery(queryLn, queryString, query);
        }
        catch (UnsupportedQueryLanguageException e) {
            this.consoleIO.writeError("Unsupported query lanaguge: " + queryLn.getName());
        }
        catch (MalformedQueryException e) {
            this.consoleIO.writeError("Malformed query: " + e.getMessage());
        }
        catch (QueryInterruptedException e) {
            this.consoleIO.writeError("Query interrupted: " + e.getMessage());
            LOGGER.error("Query interrupted", (Throwable)e);
        }
        catch (QueryEvaluationException e) {
            this.consoleIO.writeError("Query evaluation error: " + e.getMessage());
            LOGGER.error("Query evaluation error", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Failed to evaluate query: " + e.getMessage());
            LOGGER.error("Failed to evaluate query", (Throwable)e);
        }
        catch (UpdateExecutionException e) {
            this.consoleIO.writeError("Failed to execute update: " + e.getMessage());
            LOGGER.error("Failed to execute update", (Throwable)e);
        }
    }

    private void evaluateQuery(QueryLanguage queryLn, String queryString, ParsedOperation query) throws MalformedQueryException, QueryEvaluationException, RepositoryException, UpdateExecutionException {
        if (query instanceof ParsedTupleQuery) {
            this.tg_eval.evaluateTupleQuery(queryLn, queryString);
        } else if (query instanceof ParsedGraphQuery) {
            this.tg_eval.evaluateGraphQuery(queryLn, queryString);
        } else if (query instanceof ParsedBooleanQuery) {
            this.evaluateBooleanQuery(queryLn, queryString);
        } else if (query instanceof ParsedUpdate) {
            this.executeUpdate(queryLn, queryString);
        } else {
            this.consoleIO.writeError("Unexpected query type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addQueryPrefixes(QueryLanguage queryLn, String queryString) {
        StringBuffer result = new StringBuffer(queryString.length() + 512);
        result.append(queryString);
        String lowerCaseQuery = queryString.toLowerCase(Locale.ENGLISH);
        Repository repository = this.state.getRepository();
        if (repository != null && this.parameters.isQueryPrefix() && (QueryLanguage.SERQL.equals(queryLn) && lowerCaseQuery.indexOf("using namespace ") == -1 || QueryLanguage.SPARQL.equals(queryLn) && !lowerCaseQuery.startsWith("prefix"))) {
            try {
                RepositoryConnection con = repository.getConnection();
                try {
                    List<Namespace> namespaces = Iterations.asList(con.getNamespaces());
                    if (!namespaces.isEmpty()) {
                        this.addQueryPrefixes(queryLn, result, namespaces);
                    }
                }
                finally {
                    con.close();
                }
            }
            catch (RepositoryException e) {
                this.consoleIO.writeError("Error connecting to repository: " + e.getMessage());
                LOGGER.error("Error connecting to repository", (Throwable)e);
            }
        }
        return result.toString();
    }

    private void addQueryPrefixes(QueryLanguage queryLn, StringBuffer result, Collection<Namespace> namespaces) {
        StringBuilder namespaceClause = new StringBuilder(512);
        if (QueryLanguage.SERQL.equals(queryLn)) {
            namespaceClause.append(" USING NAMESPACE ");
            for (Namespace namespace : namespaces) {
                namespaceClause.append(namespace.getPrefix());
                namespaceClause.append(" = ");
                namespaceClause.append("<");
                namespaceClause.append(SeRQLUtil.encodeString(namespace.getName()));
                namespaceClause.append(">, ");
            }
            namespaceClause.setLength(namespaceClause.length() - 2);
            result.append(namespaceClause.toString());
        } else if (QueryLanguage.SPARQL.equals(queryLn)) {
            for (Namespace namespace : namespaces) {
                namespaceClause.append("PREFIX ");
                namespaceClause.append(namespace.getPrefix());
                namespaceClause.append(": ");
                namespaceClause.append("<");
                namespaceClause.append(SPARQLUtil.encodeString(namespace.getName()));
                namespaceClause.append("> ");
            }
            result.insert(0, namespaceClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateBooleanQuery(QueryLanguage queryLn, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        RepositoryConnection con = repository.getConnection();
        try {
            this.consoleIO.writeln("Evaluating query...");
            long startTime = System.nanoTime();
            boolean result = con.prepareBooleanQuery(queryLn, queryString).evaluate();
            this.consoleIO.writeln("Answer: " + result);
            long endTime = System.nanoTime();
            this.consoleIO.writeln("Query evaluated in " + (endTime - startTime) / 1000000L + " ms");
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(QueryLanguage queryLn, String queryString) throws RepositoryException, UpdateExecutionException, MalformedQueryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        RepositoryConnection con = repository.getConnection();
        try {
            this.consoleIO.writeln("Executing update...");
            long startTime = System.nanoTime();
            con.prepareUpdate(queryLn, queryString).execute();
            long endTime = System.nanoTime();
            this.consoleIO.writeln("Update executed in " + (endTime - startTime) / 1000000L + " ms");
        }
        finally {
            con.close();
        }
    }
}

