/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import java.io.IOException;
import org.openrdf.console.ConsoleIO;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryLockedException;
import org.openrdf.sail.LockManager;
import org.openrdf.sail.SailLockedException;
import org.openrdf.sail.helpers.DirectoryLockManager;

public class LockRemover {
    private final ConsoleIO consoleIO;

    LockRemover(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
    }

    protected boolean tryToRemoveLock(Repository repo) throws IOException, RepositoryException {
        boolean lockRemoved = false;
        DirectoryLockManager lockManager = new DirectoryLockManager(repo.getDataDir());
        if (lockManager.isLocked() && this.consoleIO.askProceed("WARNING: The lock from another process on this repository needs to be removed", true)) {
            repo.shutDown();
            lockRemoved = lockManager.revokeLock();
            repo.initialize();
        }
        return lockRemoved;
    }

    protected boolean tryToRemoveLock(RepositoryLockedException rle) throws IOException {
        SailLockedException sle;
        LockManager lockManager;
        boolean lockRemoved = false;
        if (rle.getCause() instanceof SailLockedException && (lockManager = (sle = (SailLockedException)rle.getCause()).getLockManager()) != null && lockManager.isLocked() && this.consoleIO.askProceed("WARNING: The lock from process '" + sle.getLockedBy() + "' on this repository needs to be removed", true)) {
            lockRemoved = lockManager.revokeLock();
        }
        return lockRemoved;
    }
}

