/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.navigation;

import info.aduna.webapp.navigation.NavigationModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class NavigationHandlerInterceptor
implements HandlerInterceptor {
    private NavigationModel navigationModel;

    public NavigationModel getNavigationModel() {
        return this.navigationModel;
    }

    public void setNavigationModel(NavigationModel navigationModel) {
        this.navigationModel = navigationModel;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView mav) {
        NavigationModel sessionNavigationModel = (NavigationModel)request.getSession().getAttribute("navigation-model");
        if (sessionNavigationModel == null) {
            sessionNavigationModel = this.navigationModel;
        }
        if (mav != null && sessionNavigationModel != null) {
            mav.addObject("view", (Object)sessionNavigationModel.findView(request.getRequestURI().substring(request.getContextPath().length())));
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        HttpSession session = request.getSession(true);
        if (session.getAttribute("navigation-model") == null) {
            session.setAttribute("navigation-model", this.getNavigationModel().clone());
        }
        return true;
    }
}

