/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.LockingIteration;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import java.util.ArrayList;
import java.util.Collections;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.openrdf.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailException;
import org.openrdf.sail.SailReadOnlyException;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.model.MemBNode;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementIterator;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.openrdf.sail.memory.model.ReadMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStoreConnection
extends NotifyingSailConnectionBase
implements InferencerConnection {
    protected final MemoryStore store;
    private volatile Lock txnLock;
    private volatile Lock txnStLock;

    protected MemoryStoreConnection(MemoryStore store) {
        super(store);
        this.store = store;
    }

    @Override
    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        Lock stLock = this.store.getStatementsReadLock();
        boolean releaseLock = true;
        try {
            int snapshot = this.store.getCurrentSnapshot();
            ReadMode readMode = ReadMode.COMMITTED;
            if (this.transactionActive()) {
                ++snapshot;
                readMode = ReadMode.TRANSACTION;
            }
            MemTripleSource tripleSource = new MemTripleSource(includeInferred, snapshot, readMode);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl(tripleSource, dataset);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer(new MemEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            CloseableIteration<BindingSet, QueryEvaluationException> iter = strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
            iter = new LockingIteration<BindingSet, QueryEvaluationException>(stLock, iter);
            releaseLock = false;
            CloseableIteration<BindingSet, QueryEvaluationException> closeableIteration = iter;
            return closeableIteration;
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
        finally {
            if (releaseLock) {
                stLock.release();
            }
        }
    }

    @Override
    protected void closeInternal() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        ArrayList<MemResource> contextIDs = new ArrayList<MemResource>(32);
        Lock stLock = this.store.getStatementsReadLock();
        try {
            MemValueFactory valueFactory;
            int snapshot = this.transactionActive() ? this.store.getCurrentSnapshot() + 1 : this.store.getCurrentSnapshot();
            ReadMode readMode = this.transactionActive() ? ReadMode.TRANSACTION : ReadMode.COMMITTED;
            MemValueFactory memValueFactory = valueFactory = this.store.getValueFactory();
            synchronized (memValueFactory) {
                for (MemURI memURI : valueFactory.getMemURIs()) {
                    if (!this.isContextResource(memURI, snapshot, readMode)) continue;
                    contextIDs.add(memURI);
                }
                for (MemBNode memBNode : valueFactory.getMemBNodes()) {
                    if (!this.isContextResource(memBNode, snapshot, readMode)) continue;
                    contextIDs.add(memBNode);
                }
            }
        }
        finally {
            stLock.release();
        }
        return new CloseableIteratorIteration(contextIDs.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContextResource(MemResource memResource, int snapshot, ReadMode readMode) throws SailException {
        MemStatementList contextStatements = memResource.getContextStatementList();
        if (contextStatements.size() == 0) {
            return false;
        }
        MemStatementIterator iter = new MemStatementIterator(contextStatements, null, null, null, false, snapshot, readMode, new MemResource[0]);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Lock stLock = this.store.getStatementsReadLock();
        boolean releaseLock = true;
        try {
            int snapshot = this.store.getCurrentSnapshot();
            ReadMode readMode = ReadMode.COMMITTED;
            if (this.transactionActive()) {
                ++snapshot;
                readMode = ReadMode.TRANSACTION;
            }
            CloseableIteration<MemStatement, SailException> iter = this.store.createStatementIterator(SailException.class, subj, pred, obj, !includeInferred, snapshot, readMode, contexts);
            iter = new LockingIteration<MemStatement, SailException>(stLock, iter);
            releaseLock = false;
            CloseableIteration<MemStatement, SailException> closeableIteration = iter;
            return closeableIteration;
        }
        finally {
            if (releaseLock) {
                stLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Lock stLock = this.store.getStatementsReadLock();
        try {
            int snapshot = this.store.getCurrentSnapshot();
            ReadMode readMode = ReadMode.COMMITTED;
            if (this.transactionActive()) {
                ++snapshot;
                readMode = ReadMode.TRANSACTION;
            }
            boolean bl = this.store.hasStatement(subj, pred, obj, !includeInferred, snapshot, readMode, contexts);
            return bl;
        }
        finally {
            stLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long sizeInternal(Resource ... contexts) throws SailException {
        Lock stLock = this.store.getStatementsReadLock();
        try {
            long l;
            CloseableIteration<? extends Statement, SailException> iter = this.getStatementsInternal(null, null, null, false, contexts);
            try {
                long size = 0L;
                while (iter.hasNext()) {
                    iter.next();
                    ++size;
                }
                l = size;
            }
            catch (Throwable throwable) {
                iter.close();
                throw throwable;
            }
            iter.close();
            return l;
        }
        finally {
            stLock.release();
        }
    }

    @Override
    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return new CloseableIteratorIteration<NamespaceImpl, SailException>(this.store.getNamespaceStore().iterator());
    }

    @Override
    protected String getNamespaceInternal(String prefix) throws SailException {
        return this.store.getNamespaceStore().getNamespace(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startTransactionInternal() throws SailException {
        if (!this.store.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        this.txnStLock = this.store.getStatementsReadLock();
        boolean releaseLocks = true;
        try {
            this.txnLock = this.store.getTransactionLock();
            try {
                this.store.startTransaction();
                releaseLocks = false;
            }
            finally {
                if (releaseLocks) {
                    this.txnLock.release();
                }
            }
        }
        finally {
            if (releaseLocks) {
                this.txnStLock.release();
            }
        }
    }

    @Override
    protected void commitInternal() throws SailException {
        this.store.commit();
        this.txnLock.release();
        this.txnStLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rollbackInternal() throws SailException {
        try {
            this.store.rollback();
        }
        finally {
            this.txnLock.release();
            this.txnStLock.release();
        }
    }

    @Override
    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatementInternal(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                boolean bl = this.addStatementInternal(subj, pred, obj, false, contexts);
                this.updateLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected boolean addStatementInternal(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        assert (this.txnStLock.isActive());
        assert (this.txnLock.isActive());
        Statement st = null;
        if (contexts.length == 0) {
            st = this.store.addStatement(subj, pred, obj, null, explicit);
            if (st != null) {
                this.notifyStatementAdded(st);
            }
        } else {
            for (Resource context : contexts) {
                st = this.store.addStatement(subj, pred, obj, context, explicit);
                if (st == null) continue;
                this.notifyStatementAdded(st);
            }
        }
        return st != null;
    }

    @Override
    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.removeStatementsInternal(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                boolean bl = this.removeStatementsInternal(subj, pred, obj, false, contexts);
                this.updateLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatementsInternal(null, null, null, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.removeStatementsInternal(null, null, null, false, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public void flushUpdates() {
    }

    protected boolean removeStatementsInternal(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        CloseableIteration<MemStatement, SailException> stIter = this.store.createStatementIterator(SailException.class, subj, pred, obj, explicit, this.store.getCurrentSnapshot() + 1, ReadMode.TRANSACTION, contexts);
        return this.removeIteratorStatements(stIter, explicit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeIteratorStatements(CloseableIteration<MemStatement, SailException> stIter, boolean explicit) throws SailException {
        boolean statementsRemoved = false;
        try {
            while (stIter.hasNext()) {
                MemStatement st = (MemStatement)stIter.next();
                if (!this.store.removeStatement(st, explicit)) continue;
                statementsRemoved = true;
                this.notifyStatementRemoved(st);
            }
        }
        finally {
            stIter.close();
        }
        return statementsRemoved;
    }

    @Override
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        try {
            this.store.getNamespaceStore().setNamespace(prefix, name);
        }
        catch (IllegalArgumentException e) {
            throw new SailException(e.getMessage());
        }
    }

    @Override
    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.store.getNamespaceStore().removeNamespace(prefix);
    }

    @Override
    protected void clearNamespacesInternal() throws SailException {
        this.store.getNamespaceStore().clear();
    }

    protected class MemEvaluationStatistics
    extends EvaluationStatistics {
        protected MemEvaluationStatistics() {
        }

        protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
            return new MemCardinalityCalculator();
        }

        protected class MemCardinalityCalculator
        extends EvaluationStatistics.CardinalityCalculator {
            protected MemCardinalityCalculator() {
            }

            public double getCardinality(StatementPattern sp) {
                Value pred;
                Value subj = this.getConstantValue(sp.getSubjectVar());
                if (!(subj instanceof Resource)) {
                    subj = null;
                }
                if (!((pred = this.getConstantValue(sp.getPredicateVar())) instanceof URI)) {
                    pred = null;
                }
                Value obj = this.getConstantValue(sp.getObjectVar());
                Value context = this.getConstantValue(sp.getContextVar());
                if (!(context instanceof Resource)) {
                    context = null;
                }
                MemValueFactory valueFactory = MemoryStoreConnection.this.store.getValueFactory();
                MemResource memSubj = valueFactory.getMemResource((Resource)subj);
                MemURI memPred = valueFactory.getMemURI((URI)pred);
                MemValue memObj = valueFactory.getMemValue(obj);
                MemResource memContext = valueFactory.getMemResource((Resource)context);
                if (subj != null && memSubj == null || pred != null && memPred == null || obj != null && memObj == null || context != null && memContext == null) {
                    return 0.0;
                }
                ArrayList<Integer> listSizes = new ArrayList<Integer>(4);
                if (memSubj != null) {
                    listSizes.add(memSubj.getSubjectStatementCount());
                }
                if (memPred != null) {
                    listSizes.add(memPred.getPredicateStatementCount());
                }
                if (memObj != null) {
                    listSizes.add(memObj.getObjectStatementCount());
                }
                if (memContext != null) {
                    listSizes.add(memContext.getContextStatementCount());
                }
                double cardinality = listSizes.isEmpty() ? (double)MemoryStoreConnection.this.store.size() : (double)((Integer)Collections.min(listSizes)).intValue();
                return cardinality;
            }

            protected Value getConstantValue(Var var) {
                if (var != null) {
                    return var.getValue();
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MemTripleSource
    implements TripleSource {
        protected final int snapshot;
        protected final ReadMode readMode;
        protected final boolean includeInferred;

        public MemTripleSource(boolean includeInferred, int snapshot, ReadMode readMode) {
            this.includeInferred = includeInferred;
            this.snapshot = snapshot;
            this.readMode = readMode;
        }

        public CloseableIteration<MemStatement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) {
            return MemoryStoreConnection.this.store.createStatementIterator(QueryEvaluationException.class, subj, pred, obj, !this.includeInferred, this.snapshot, this.readMode, contexts);
        }

        @Override
        public MemValueFactory getValueFactory() {
            return MemoryStoreConnection.this.store.getValueFactory();
        }
    }
}

