/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository;

import info.aduna.lang.service.FileFormatServiceRegistry;
import info.aduna.webapp.util.HttpServerUtil;
import info.aduna.webapp.views.EmptySuccessView;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.OpenRDFException;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.HTTPException;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.BooleanQueryResultView;
import org.openrdf.http.server.repository.GraphQueryResultView;
import org.openrdf.http.server.repository.QueryResultView;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.http.server.repository.TupleQueryResultView;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.BooleanQueryResultWriterRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.manager.RepositoryManager;
import org.openrdf.rio.RDFWriterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class RepositoryController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RepositoryManager repositoryManager;
    private static final String METHOD_DELETE = "DELETE";

    public RepositoryController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST", METHOD_DELETE});
    }

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod = request.getMethod();
        String queryStr = request.getParameter("query");
        if (METHOD_DELETE.equals(reqMethod)) {
            String repId = RepositoryInterceptor.getRepositoryID(request);
            this.logger.info("DELETE request invoked for repository '" + repId + "'");
            if (queryStr != null) {
                this.logger.warn("query supplied on repository delete request, aborting delete");
                throw new HTTPException(400, "Repository delete error: query supplied with request");
            }
            if ("SYSTEM".equals(repId)) {
                this.logger.warn("attempted delete of SYSTEM repository, aborting");
                throw new HTTPException(403, "SYSTEM Repository can not be deleted");
            }
            try {
                RepositoryConnection connection = RepositoryInterceptor.getRepositoryConnection(request);
                connection.close();
                boolean success = this.repositoryManager.removeRepository(repId);
                if (success) {
                    this.logger.info("DELETE request successfully completed");
                    return new ModelAndView((View)EmptySuccessView.getInstance());
                }
                this.logger.error("error while attempting to delete repository '" + repId + "'");
                throw new HTTPException(400, "could not locate repository configuration for repository '" + repId + "'.");
            }
            catch (OpenRDFException e) {
                this.logger.error("error while attempting to delete repository '" + repId + "'", (Throwable)e);
                throw new ServerHTTPException("Repository delete error: " + e.getMessage(), (Throwable)e);
            }
        }
        Repository repository = RepositoryInterceptor.getRepository(request);
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        int qryCode = 0;
        if (this.logger.isInfoEnabled() || this.logger.isDebugEnabled()) {
            qryCode = String.valueOf(queryStr).hashCode();
        }
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET query {}", (Object)qryCode);
        } else if ("POST".equals(reqMethod)) {
            this.logger.info("POST query {}", (Object)qryCode);
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            if (!"application/x-www-form-urlencoded".equals(mimeType)) {
                throw new ClientHTTPException(415, "Unsupported MIME type: " + mimeType);
            }
        }
        this.logger.debug("query {} = {}", (Object)qryCode, (Object)queryStr);
        if (queryStr != null) {
            QueryResultView view;
            FileFormatServiceRegistry registry;
            Object queryResult;
            block19: {
                Query query = this.getQuery(repository, repositoryCon, queryStr, request, response);
                try {
                    if (query instanceof TupleQuery) {
                        TupleQuery tQuery = (TupleQuery)query;
                        queryResult = tQuery.evaluate();
                        registry = TupleQueryResultWriterRegistry.getInstance();
                        view = TupleQueryResultView.getInstance();
                        break block19;
                    }
                    if (query instanceof GraphQuery) {
                        GraphQuery gQuery = (GraphQuery)query;
                        queryResult = gQuery.evaluate();
                        registry = RDFWriterRegistry.getInstance();
                        view = GraphQueryResultView.getInstance();
                        break block19;
                    }
                    if (query instanceof BooleanQuery) {
                        BooleanQuery bQuery = (BooleanQuery)query;
                        queryResult = bQuery.evaluate();
                        registry = BooleanQueryResultWriterRegistry.getInstance();
                        view = BooleanQueryResultView.getInstance();
                        break block19;
                    }
                    throw new ClientHTTPException(400, "Unsupported query type: " + query.getClass().getName());
                }
                catch (QueryInterruptedException e) {
                    this.logger.info("Query interrupted", (Throwable)e);
                    throw new ServerHTTPException(503, "Query evaluation took too long");
                }
                catch (QueryEvaluationException e) {
                    this.logger.info("Query evaluation error", (Throwable)e);
                    if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                        throw (HTTPException)e.getCause();
                    }
                    throw new ServerHTTPException("Query evaluation error: " + e.getMessage());
                }
            }
            TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, registry);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("filenameHint", "query-result");
            model.put("queryResult", queryResult);
            model.put("factory", factory);
            return new ModelAndView((View)view, model);
        }
        throw new ClientHTTPException(400, "Missing parameter: query");
    }

    private Query getQuery(Repository repository, RepositoryConnection repositoryCon, String queryStr, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException {
        Query result = null;
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf(queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String timeout = request.getParameter("timeout");
        int maxQueryTime = 0;
        if (timeout != null) {
            try {
                maxQueryTime = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                throw new ClientHTTPException(400, "Invalid timeout value: " + timeout);
            }
        }
        String[] defaultGraphURIs = request.getParameterValues("default-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("named-graph-uri");
        DatasetImpl dataset = null;
        if (defaultGraphURIs != null || namedGraphURIs != null) {
            URI uri;
            dataset = new DatasetImpl();
            if (defaultGraphURIs != null) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = this.createURIOrNull(repository, defaultGraphURI);
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs != null) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = this.createURIOrNull(repository, namedGraphURI);
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
        }
        try {
            result = repositoryCon.prepareQuery(queryLn, queryStr, baseURI);
            result.setIncludeInferred(includeInferred);
            if (maxQueryTime > 0) {
                result.setMaxQueryTime(maxQueryTime);
            }
            if (dataset != null) {
                result.setDataset(dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repository.getValueFactory());
                result.setBinding(bindingName, bindingValue);
            }
        }
        catch (UnsupportedQueryLanguageException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_QUERY_LANGUAGE, queryLn.getName());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (MalformedQueryException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (RepositoryException e) {
            this.logger.error("Repository error", (Throwable)e);
            response.sendError(500);
        }
        return result;
    }

    private URI createURIOrNull(Repository repository, String graphURI) {
        if ("null".equals(graphURI)) {
            return null;
        }
        return repository.getValueFactory().createURI(graphURI);
    }
}

