/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql;

import java.io.File;
import java.util.Map;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryBase;
import org.openrdf.repository.sparql.SPARQLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLRepository
extends RepositoryBase {
    private String queryEndpointUrl;
    private String updateEndpointUrl;
    private Map<String, String> additionalHttpHeaders;

    public SPARQLRepository(String queryEndpointUrl) {
        this.queryEndpointUrl = queryEndpointUrl;
    }

    public SPARQLRepository(String queryEndpointUrl, String updateEndpointUrl) {
        this.queryEndpointUrl = queryEndpointUrl;
        this.updateEndpointUrl = updateEndpointUrl;
    }

    @Override
    public RepositoryConnection getConnection() throws RepositoryException {
        return new SPARQLConnection(this, this.queryEndpointUrl, this.updateEndpointUrl);
    }

    @Override
    public File getDataDir() {
        return null;
    }

    @Override
    public ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
    }

    @Override
    public boolean isWritable() throws RepositoryException {
        return false;
    }

    @Override
    public void setDataDir(File dataDir) {
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
    }

    public String toString() {
        return this.queryEndpointUrl;
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders;
    }
}

