/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.manager;

import java.io.File;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigUtil;
import org.openrdf.repository.event.NotifyingRepositoryConnection;
import org.openrdf.repository.event.base.NotifyingRepositoryWrapper;
import org.openrdf.repository.manager.SystemRepositoryConfig;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemRepository
extends NotifyingRepositoryWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ID = "SYSTEM";
    public static final String TITLE = "System configuration repository";
    public static final String REPOSITORY_TYPE = "openrdf:SystemRepository";

    public SystemRepository(File systemDir) throws RepositoryException {
        super.setDelegate(new SailRepository(new MemoryStore(systemDir)));
    }

    public void initialize() throws RepositoryException {
        super.initialize();
        NotifyingRepositoryConnection con = this.getConnection();
        try {
            if (con.isEmpty()) {
                this.logger.debug("Initializing empty {} repository", (Object)ID);
                con.setAutoCommit(false);
                con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                con.setNamespace("sys", "http://www.openrdf.org/config/repository#");
                RepositoryConfig repConfig = new RepositoryConfig(ID, TITLE, new SystemRepositoryConfig());
                RepositoryConfigUtil.updateRepositoryConfigs(con, repConfig);
                con.commit();
            }
        }
        catch (RepositoryConfigException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            con.close();
        }
    }

    public void setDelegate(Repository delegate) {
        throw new UnsupportedOperationException("Setting delegate on system repository not allowed");
    }
}

