/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.lang.ObjectUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.AggregateOperator;
import org.openrdf.query.algebra.AggregateOperatorBase;
import org.openrdf.query.algebra.Avg;
import org.openrdf.query.algebra.Count;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.GroupConcat;
import org.openrdf.query.algebra.GroupElem;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.Max;
import org.openrdf.query.algebra.Min;
import org.openrdf.query.algebra.Sample;
import org.openrdf.query.algebra.Sum;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.MathUtil;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;
import org.openrdf.query.impl.EmptyBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupIterator
extends CloseableIteratorIteration<BindingSet, QueryEvaluationException> {
    private final ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
    private final EvaluationStrategy strategy;
    private final BindingSet parentBindings;
    private final Group group;
    private boolean initialized = false;
    private final Object lock = new Object();

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.group = group;
        this.parentBindings = parentBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    super.setIterator(this.createIterator());
                    this.initialized = true;
                }
            }
        }
        return super.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    super.setIterator(this.createIterator());
                    this.initialized = true;
                }
            }
        }
        return (BindingSet)super.next();
    }

    private Iterator<BindingSet> createIterator() throws QueryEvaluationException {
        Collection<Entry> entries = this.buildEntries();
        LinkedList<QueryBindingSet> bindingSets = new LinkedList<QueryBindingSet>();
        for (Entry entry : entries) {
            QueryBindingSet sol = new QueryBindingSet(this.parentBindings);
            for (String name : this.group.getGroupBindingNames()) {
                Value value;
                BindingSet prototype = entry.getPrototype();
                if (prototype == null || (value = prototype.getValue(name)) == null) continue;
                sol.setBinding(name, value);
            }
            entry.bindSolution(sol);
            bindingSets.add(sol);
        }
        return bindingSets.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Entry> buildEntries() throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.strategy.evaluate(this.group.getArg(), this.parentBindings);
        try {
            LinkedHashMap<Key, Entry> entries = new LinkedHashMap<Key, Entry>();
            if (!iter.hasNext()) {
                entries.put(new Key(new EmptyBindingSet()), new Entry(new EmptyBindingSet()));
            }
            while (iter.hasNext()) {
                BindingSet sol;
                try {
                    sol = (BindingSet)iter.next();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                Key key = new Key(sol);
                Entry entry = (Entry)entries.get(key);
                if (entry == null) {
                    entry = new Entry(sol);
                    entries.put(key, entry);
                }
                entry.addSolution(sol);
            }
            Collection<Entry> collection = entries.values();
            return collection;
        }
        finally {
            iter.close();
        }
    }

    private class ConcatAggregate
    extends Aggregate {
        private StringBuilder concatenated;
        private String separator;

        public ConcatAggregate(GroupConcat groupConcatOp) throws ValueExprEvaluationException, QueryEvaluationException {
            super(groupConcatOp);
            this.concatenated = new StringBuilder();
            this.separator = " ";
            ValueExpr separatorExpr = groupConcatOp.getSeparator();
            if (separatorExpr != null) {
                Value separatorValue = GroupIterator.this.strategy.evaluate(separatorExpr, GroupIterator.this.parentBindings);
                this.separator = separatorValue.stringValue();
            }
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && this.distinct(v)) {
                this.concatenated.append(v.stringValue());
                this.concatenated.append(this.separator);
            }
        }

        public Value getValue() {
            if (this.concatenated.length() == 0) {
                return GroupIterator.this.vf.createLiteral("");
            }
            int len = this.concatenated.length() - this.separator.length();
            return GroupIterator.this.vf.createLiteral(this.concatenated.substring(0, len));
        }
    }

    private class SampleAggregate
    extends Aggregate {
        private Value sample;
        private Random random;

        public SampleAggregate(Sample operator) {
            super(operator);
            this.sample = null;
            this.random = new Random(System.currentTimeMillis());
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.sample == null || this.random.nextFloat() < 0.5f) {
                this.sample = this.evaluate(s);
            }
        }

        public Value getValue() {
            return this.sample;
        }
    }

    private class AvgAggregate
    extends Aggregate {
        private long count;
        private Literal sum;
        private ValueExprEvaluationException typeError;

        public AvgAggregate(Avg operator) {
            super(operator);
            this.count = 0L;
            this.sum = GroupIterator.this.vf.createLiteral("0", XMLSchema.INTEGER);
            this.typeError = null;
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.typeError != null) {
                return;
            }
            Value v = this.evaluate(s);
            if (this.distinct(v)) {
                if (v instanceof Literal) {
                    Literal nextLiteral = (Literal)v;
                    if (nextLiteral.getDatatype() != null && XMLDatatypeUtil.isNumericDatatype(nextLiteral.getDatatype())) {
                        this.sum = MathUtil.compute(this.sum, nextLiteral, MathExpr.MathOp.PLUS);
                    } else {
                        this.typeError = new ValueExprEvaluationException("not a number: " + v);
                    }
                    ++this.count;
                } else if (v != null) {
                    this.typeError = new ValueExprEvaluationException("not a number: " + v);
                }
            }
        }

        public Value getValue() throws ValueExprEvaluationException {
            if (this.typeError != null) {
                throw this.typeError;
            }
            if (this.count == 0L) {
                return GroupIterator.this.vf.createLiteral(0.0);
            }
            Literal sizeLit = GroupIterator.this.vf.createLiteral(this.count);
            return MathUtil.compute(this.sum, sizeLit, MathExpr.MathOp.DIVIDE);
        }
    }

    private class SumAggregate
    extends Aggregate {
        private Literal sum;
        private ValueExprEvaluationException typeError;

        public SumAggregate(Sum operator) {
            super(operator);
            this.sum = GroupIterator.this.vf.createLiteral("0", XMLSchema.INTEGER);
            this.typeError = null;
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.typeError != null) {
                return;
            }
            Value v = this.evaluate(s);
            if (this.distinct(v)) {
                if (v instanceof Literal) {
                    Literal nextLiteral = (Literal)v;
                    if (nextLiteral.getDatatype() != null && XMLDatatypeUtil.isNumericDatatype(nextLiteral.getDatatype())) {
                        this.sum = MathUtil.compute(this.sum, nextLiteral, MathExpr.MathOp.PLUS);
                    } else {
                        this.typeError = new ValueExprEvaluationException("not a number: " + v);
                    }
                } else if (v != null) {
                    this.typeError = new ValueExprEvaluationException("not a number: " + v);
                }
            }
        }

        public Value getValue() throws ValueExprEvaluationException {
            if (this.typeError != null) {
                throw this.typeError;
            }
            return this.sum;
        }
    }

    private class MaxAggregate
    extends Aggregate {
        private final ValueComparator comparator;
        private Value max;

        public MaxAggregate(Max operator) {
            super(operator);
            this.comparator = new ValueComparator();
            this.max = null;
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (this.distinct(v)) {
                if (this.max == null) {
                    this.max = v;
                } else if (this.comparator.compare(v, this.max) > 0) {
                    this.max = v;
                }
            }
        }

        public Value getValue() {
            return this.max;
        }
    }

    private class MinAggregate
    extends Aggregate {
        private final ValueComparator comparator;
        private Value min;

        public MinAggregate(Min operator) {
            super(operator);
            this.comparator = new ValueComparator();
            this.min = null;
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (this.distinct(v)) {
                if (this.min == null) {
                    this.min = v;
                } else if (this.comparator.compare(v, this.min) < 0) {
                    this.min = v;
                }
            }
        }

        public Value getValue() {
            return this.min;
        }
    }

    private class CountAggregate
    extends Aggregate {
        private long count;

        public CountAggregate(Count operator) {
            super(operator);
            this.count = 0L;
        }

        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.getArg() != null) {
                Value value = this.evaluate(s);
                if (value != null && this.distinct(value)) {
                    ++this.count;
                }
            } else {
                ++this.count;
            }
        }

        public Value getValue() {
            return GroupIterator.this.vf.createLiteral(Long.toString(this.count), XMLSchema.INTEGER);
        }
    }

    private abstract class Aggregate {
        private final Set<Value> distinct;
        private final ValueExpr arg;

        public Aggregate(AggregateOperatorBase operator) {
            this.arg = operator.getArg();
            this.distinct = operator.isDistinct() ? new HashSet<Value>() : null;
        }

        public abstract Value getValue() throws ValueExprEvaluationException;

        public abstract void processAggregate(BindingSet var1) throws QueryEvaluationException;

        protected boolean distinct(Value value) {
            return this.distinct == null || this.distinct.add(value);
        }

        protected ValueExpr getArg() {
            return this.arg;
        }

        protected Value evaluate(BindingSet s) throws QueryEvaluationException {
            try {
                return GroupIterator.this.strategy.evaluate(this.getArg(), s);
            }
            catch (ValueExprEvaluationException e) {
                return null;
            }
        }
    }

    private class Entry {
        private BindingSet prototype;
        private Map<String, Aggregate> aggregates;

        public Entry(BindingSet prototype) throws ValueExprEvaluationException, QueryEvaluationException {
            this.prototype = prototype;
            this.aggregates = new LinkedHashMap<String, Aggregate>();
            for (GroupElem ge : GroupIterator.this.group.getGroupElements()) {
                Aggregate create = this.create(ge.getOperator());
                if (create == null) continue;
                this.aggregates.put(ge.getName(), create);
            }
        }

        public BindingSet getPrototype() {
            return this.prototype;
        }

        public void addSolution(BindingSet bindingSet) throws QueryEvaluationException {
            for (Aggregate aggregate : this.aggregates.values()) {
                aggregate.processAggregate(bindingSet);
            }
        }

        public void bindSolution(QueryBindingSet sol) throws QueryEvaluationException {
            for (String name : this.aggregates.keySet()) {
                try {
                    Value value = this.aggregates.get(name).getValue();
                    if (value == null) continue;
                    sol.setBinding(name, value);
                }
                catch (ValueExprEvaluationException ex) {}
            }
        }

        private Aggregate create(AggregateOperator operator) throws ValueExprEvaluationException, QueryEvaluationException {
            if (operator instanceof Count) {
                return new CountAggregate((Count)operator);
            }
            if (operator instanceof Min) {
                return new MinAggregate((Min)operator);
            }
            if (operator instanceof Max) {
                return new MaxAggregate((Max)operator);
            }
            if (operator instanceof Sum) {
                return new SumAggregate((Sum)operator);
            }
            if (operator instanceof Avg) {
                return new AvgAggregate((Avg)operator);
            }
            if (operator instanceof Sample) {
                return new SampleAggregate((Sample)operator);
            }
            if (operator instanceof GroupConcat) {
                return new ConcatAggregate((GroupConcat)operator);
            }
            return null;
        }
    }

    protected class Key {
        private BindingSet bindingSet;
        private int hash;

        public Key(BindingSet bindingSet) {
            this.bindingSet = bindingSet;
            for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                Value value = bindingSet.getValue(name);
                if (value == null) continue;
                this.hash ^= value.hashCode();
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other instanceof Key && other.hashCode() == this.hash) {
                BindingSet otherSolution = ((Key)other).bindingSet;
                for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                    Value v2;
                    Value v1 = this.bindingSet.getValue(name);
                    if (ObjectUtil.nullEquals(v1, v2 = otherSolution.getValue(name))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

