/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.statements;

import info.aduna.webapp.util.HttpServerUtil;
import info.aduna.webapp.views.EmptySuccessView;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.protocol.transaction.TransactionReader;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.HTTPException;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.http.server.repository.statements.ExportStatementsView;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StatementsController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public StatementsController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result;
        Repository repository = RepositoryInterceptor.getRepository(request);
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET statements");
            result = this.getExportStatementsResult(repository, repositoryCon, request, response);
        } else if ("POST".equals(reqMethod)) {
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            if ("application/x-rdftransaction".equals(mimeType)) {
                this.logger.info("POST transaction to repository");
                result = this.getTransactionResultResult(repository, repositoryCon, request, response);
            } else if (request.getParameterMap().containsKey("update")) {
                this.logger.info("POST SPARQL update request to repository");
                result = this.getSparqlUpdateResult(repository, repositoryCon, request, response);
            } else {
                this.logger.info("POST data to repository");
                result = this.getAddDataResult(repository, repositoryCon, request, response, false);
            }
        } else if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT data in repository");
            result = this.getAddDataResult(repository, repositoryCon, request, response, true);
        } else if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE data from repository");
            result = this.getDeleteDataResult(repository, repositoryCon, request, response);
        } else {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        return result;
    }

    private ModelAndView getSparqlUpdateResult(Repository repository, RepositoryConnection repositoryCon, HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException, HTTPException {
        URI uri;
        ProtocolUtil.logRequestParameters(request);
        String sparqlUpdateString = request.getParameterValues("update")[0];
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf(queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String[] defaultRemoveGraphURIs = request.getParameterValues("remove-graph-uri");
        String[] defaultInsertGraphURIs = request.getParameterValues("insert-graph-uri");
        String[] defaultGraphURIs = request.getParameterValues("using-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("using-named-graph-uri");
        DatasetImpl dataset = new DatasetImpl();
        if (defaultRemoveGraphURIs != null) {
            for (String graphURI : defaultRemoveGraphURIs) {
                try {
                    uri = this.createURIOrNull(repository, graphURI);
                    dataset.addDefaultRemoveGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default remove graph: " + graphURI);
                }
            }
        }
        if (defaultInsertGraphURIs != null && defaultInsertGraphURIs.length > 0) {
            String graphURI = defaultInsertGraphURIs[0];
            try {
                URI uri2 = this.createURIOrNull(repository, graphURI);
                dataset.setDefaultInsertGraph(uri2);
            }
            catch (IllegalArgumentException e) {
                throw new ClientHTTPException(400, "Illegal URI for default insert graph: " + graphURI);
            }
        }
        if (defaultGraphURIs != null) {
            for (String defaultGraphURI : defaultGraphURIs) {
                try {
                    uri = this.createURIOrNull(repository, defaultGraphURI);
                    dataset.addDefaultGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                }
            }
        }
        if (namedGraphURIs != null) {
            for (String namedGraphURI : namedGraphURIs) {
                try {
                    uri = this.createURIOrNull(repository, namedGraphURI);
                    dataset.addNamedGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                }
            }
        }
        try {
            Update update = repositoryCon.prepareUpdate(queryLn, sparqlUpdateString, baseURI);
            update.setIncludeInferred(includeInferred);
            if (dataset != null) {
                update.setDataset(dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repository.getValueFactory());
                update.setBinding(bindingName, bindingValue);
            }
            update.execute();
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (UpdateExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                throw (HTTPException)e.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                throw (HTTPException)e.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
    }

    private URI createURIOrNull(Repository repository, String graphURI) {
        if ("null".equals(graphURI)) {
            return null;
        }
        return repository.getValueFactory().createURI(graphURI);
    }

    private ModelAndView getExportStatementsResult(Repository repository, RepositoryConnection repositoryCon, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = repository.getValueFactory();
        Resource subj = ProtocolUtil.parseResourceParam(request, "subj", vf);
        URI pred = ProtocolUtil.parseURIParam(request, "pred", vf);
        Value obj = ProtocolUtil.parseValueParam(request, "obj", vf);
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
        boolean useInferencing = ProtocolUtil.parseBooleanParam(request, "infer", true);
        RDFWriterFactory rdfWriterFactory = ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subj);
        model.put("predicate", pred);
        model.put("object", obj);
        model.put("contexts", contexts);
        model.put("useInferencing", useInferencing);
        model.put("factory", rdfWriterFactory);
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    private ModelAndView getTransactionResultResult(Repository repository, RepositoryConnection repositoryCon, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException, ServerHTTPException, HTTPException {
        ServletInputStream in = request.getInputStream();
        try {
            this.logger.debug("Processing transaction...");
            TransactionReader reader = new TransactionReader();
            Collection<TransactionOperation> txn = reader.parse((InputStream)in);
            boolean wasAutoCommit = repositoryCon.isAutoCommit();
            repositoryCon.setAutoCommit(false);
            for (TransactionOperation op : txn) {
                op.execute(repositoryCon);
            }
            repositoryCon.setAutoCommit(wasAutoCommit);
            this.logger.debug("Transaction processed ");
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (SAXParseException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (SAXException e) {
            throw new ServerHTTPException("Failed to parse transaction data: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServerHTTPException("Failed to read data: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                throw (HTTPException)e.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
    }

    private ModelAndView getAddDataResult(Repository repository, RepositoryConnection repositoryCon, HttpServletRequest request, HttpServletResponse response, boolean replaceCurrent) throws IOException, ServerHTTPException, ClientHTTPException, HTTPException {
        ProtocolUtil.logRequestParameters(request);
        String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
        RDFFormat rdfFormat = Rio.getParserFormatForMIMEType(mimeType);
        if (rdfFormat == null) {
            throw new ClientHTTPException(415, "Unsupported MIME type: " + mimeType);
        }
        ValueFactory vf = repository.getValueFactory();
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
        URI baseURI = ProtocolUtil.parseURIParam(request, "baseURI", vf);
        if (baseURI == null) {
            baseURI = vf.createURI("foo:bar");
            this.logger.info("no base URI specified, using dummy '{}'", (Object)baseURI);
        }
        ServletInputStream in = request.getInputStream();
        try {
            boolean wasAutoCommit = repositoryCon.isAutoCommit();
            repositoryCon.setAutoCommit(false);
            if (replaceCurrent) {
                repositoryCon.clear(contexts);
            }
            repositoryCon.add((InputStream)in, ((Object)baseURI).toString(), rdfFormat, contexts);
            repositoryCon.setAutoCommit(wasAutoCommit);
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (UnsupportedRDFormatException e) {
            throw new ClientHTTPException(415, "No RDF parser available for format " + rdfFormat.getName());
        }
        catch (RDFParseException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (IOException e) {
            throw new ServerHTTPException("Failed to read data: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                throw (HTTPException)e.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
    }

    private ModelAndView getDeleteDataResult(Repository repository, RepositoryConnection repositoryCon, HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException, HTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = repository.getValueFactory();
        Resource subj = ProtocolUtil.parseResourceParam(request, "subj", vf);
        URI pred = ProtocolUtil.parseURIParam(request, "pred", vf);
        Value obj = ProtocolUtil.parseValueParam(request, "obj", vf);
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
        try {
            repositoryCon.remove(subj, pred, obj, contexts);
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (RepositoryException e) {
            if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                throw (HTTPException)e.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
    }
}

