/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.aws.s3.AWSS3ApiMetadata;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.options.AWSS3PutObjectOptions;
import org.jclouds.aws.s3.blobstore.options.AWSS3PutOptions;
import org.jclouds.aws.s3.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.rest.RestContext;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.S3BlobStore;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.options.PutObjectOptions;

public class AWSS3BlobStore
extends S3BlobStore {
    private final Provider<MultipartUploadStrategy> multipartUploadStrategy;
    private final LoadingCache<String, AccessControlList> bucketAcls;
    private final BlobToObject blob2Object;

    @Inject
    AWSS3BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AWSS3Client sync, Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, LoadingCache<String, AccessControlList> bucketAcls, Provider<MultipartUploadStrategy> multipartUploadStrategy) {
        super(context, blobUtils, defaultLocation, locations, (S3Client)sync, convertBucketsToStorageMetadata, container2BucketListOptions, bucket2ResourceList, object2Blob, blob2ObjectGetOptions, blob2Object, object2BlobMd, fetchBlobMetadataProvider, bucketAcls);
        this.multipartUploadStrategy = multipartUploadStrategy;
        this.bucketAcls = bucketAcls;
        this.blob2Object = blob2Object;
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            return ((MultipartUploadStrategy)this.multipartUploadStrategy.get()).execute(container, blob, options);
        }
        if (options instanceof AWSS3PutOptions && ((AWSS3PutOptions)options).getStorageClass() == ObjectMetadata.StorageClass.REDUCED_REDUNDANCY) {
            return this.putBlobWithReducedRedundancy(container, blob);
        }
        return super.putBlob(container, blob, options);
    }

    private String putBlobWithReducedRedundancy(String container, Blob blob) {
        AWSS3PutObjectOptions.Builder options = AWSS3PutObjectOptions.builder();
        try {
            AccessControlList acl = (AccessControlList)this.bucketAcls.getUnchecked((Object)container);
            if (acl != null && acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
                options.acl(CannedAccessPolicy.PUBLIC_READ);
            }
            options.storageClass(ObjectMetadata.StorageClass.REDUCED_REDUNDANCY);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            // empty catch block
        }
        return ((AWSS3Client)((RestContext)this.getContext().unwrap(AWSS3ApiMetadata.CONTEXT_TOKEN)).getApi()).putObject(container, this.blob2Object.apply(blob), new PutObjectOptions[]{options.build()});
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if ((location == null || location.getId().equals("us-standard")) && this.containerExists(container)) {
            return false;
        }
        return super.createContainerInLocation(location, container, options);
    }
}

