/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import org.jclouds.aws.s3.config.AWSS3RestClientModule;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.s3.blobstore.S3BlobSignerExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSS3BlobSignerExpectTest")
public class AWSS3BlobSignerExpectTest
extends S3BlobSignerExpectTest {
    private static final String DATE = "Thu, 05 Jun 2008 16:38:19 GMT";
    private static final String HOST = "container.s3.amazonaws.com";

    public AWSS3BlobSignerExpectTest() {
        this.provider = "aws-s3";
    }

    protected HttpRequest getBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://container.s3.amazonaws.com/name").addHeader("Host", new String[]{HOST})).addHeader("Date", new String[]{DATE})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    protected HttpRequest getBlobWithTime() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://container.s3.amazonaws.com/name?Expires=1212683902&AWSAccessKeyId=identity&Signature=Y4Ac4sZfBemGZmgfG78F7IX%2BIFg%3D").addHeader("Host", new String[]{HOST})).addHeader("Date", new String[]{DATE})).build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://container.s3.amazonaws.com/name").addHeader("Host", new String[]{HOST})).addHeader("Range", new String[]{"bytes=0-1"})).addHeader("Date", new String[]{DATE})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    @Test
    public void testSignGetBlobWithTime() {
        BlobStore getBlobWithTime = (BlobStore)this.requestsSendResponses(this.init());
        HttpRequest compare = this.getBlobWithTime();
        Assert.assertEquals((Object)getBlobWithTime.getContext().getSigner().signGetBlob(this.container, this.name, 3L), (Object)compare);
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://container.s3.amazonaws.com/name").addHeader("Host", new String[]{HOST})).addHeader("Expect", new String[]{"100-continue"})).addHeader("Date", new String[]{DATE})).addHeader("Authorization", new String[]{"AWS identity:j9Dy/lmmvlCKjA4lkqZenLxMkR4="})).build();
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://container.s3.amazonaws.com/name?Expires=1212683902&AWSAccessKeyId=identity&Signature=genkB2vLxe3AWV/bPvRTMqQts7E%3D").addHeader("Expect", new String[]{"100-continue"})).addHeader("Host", new String[]{HOST})).addHeader("Date", new String[]{DATE})).build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://container.s3.amazonaws.com/name").addHeader("Host", new String[]{HOST})).addHeader("Date", new String[]{DATE})).addHeader("Authorization", new String[]{"AWS identity:4FnyjdX/ULdDMRbVlLNjZfEo9RQ="})).build();
    }

    @Test
    public void testSignPutBlobWithTime() throws Exception {
        BlobStore signPutBloblWithTime = (BlobStore)this.requestsSendResponses(this.init());
        Blob blob = signPutBloblWithTime.blobBuilder(this.name).payload(this.text).contentType("text/plain").build();
        HttpRequest compare = this.putBlobWithTime();
        compare.setPayload(blob.getPayload());
        Assert.assertEquals((Object)signPutBloblWithTime.getContext().getSigner().signPutBlob(this.container, blob, 3L), (Object)compare);
    }

    protected Module createModule() {
        return new TestAWSS3RestClientModule();
    }

    @ConfiguresRestClient
    private static final class TestAWSS3RestClientModule
    extends AWSS3RestClientModule {
        private TestAWSS3RestClientModule() {
        }

        @TimeStamp
        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return AWSS3BlobSignerExpectTest.DATE;
        }
    }
}

